//
//  LetterFix.m
//  LetterFix2
//
//  Created by kuri on 10/02/01.
//  Copyright 2010-2011 kuri. All rights reserved.
//
#import <objc/runtime.h>
#import <objc/objc-runtime.h>
#import <WebKit/WebKit.h>
#import "LetterFix.h"
#import "LFApp.h"

static NSMutableArray *khash;
static LFApp *app;
static char *roman[] = {"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X"};
static NSString *dep[] = {@"ミリ", @"キロ", @"センチ", @"メートル", @"グラム", @"トン", @"アール", @"ヘクタール",
    @"リットル", @"ワット", @"カロリー", @"ドル", @"セント", @"パーセント", @"ミリバール", @"ページ",
    @"mm", @"cm", @"km", @"mg", @"kg", @"cc", @"明治", @"大正", @"昭和", @"平成", @"No.", @"K.K.", @"TEL",
    @"(上)", @"(中)", @"(下)", @"(左)", @"(右)", @"(株)", @"(有)", @"(代)", @"Σ"};

void swizzlingMethod(Class aClass, SEL aSelector, SEL nSelector, IMP nImplement) {
    Method orig_method, alt_method;
    
    if ((orig_method = class_getInstanceMethod(aClass, aSelector)) == NULL) {
	NSLog(@"Swizzling Method: Original Method is not found.");
	return; // Original Method is not found.
    }
    // If orig_method was the superclass's instance method, so now we'll add the implement as method of self class.
    if (class_addMethod(aClass, aSelector, method_getImplementation(orig_method), method_getTypeEncoding(orig_method)) == YES) {
	orig_method = class_getInstanceMethod(aClass, aSelector);
    }
    if (class_addMethod(aClass, nSelector, nImplement, method_getTypeEncoding(orig_method)) == NO) {
	NSLog(@"Swizzling Method: Can't add new method.");
	return; // Can't add new method
    }
    alt_method  = class_getInstanceMethod(aClass, nSelector);
    method_exchangeImplementations(orig_method, alt_method);
    //NSLog(@"Swizzling Method: Success.");
}

int fixTextNode(DOMText *node, DOMRange *range, BOOL isCheck, BOOL isOpen)
{
    int      replaced = 0;
    int      c_start = -1;
    int      c_end = -1;
    int      i;
    
    if ([node nodeType] != DOM_TEXT_NODE) return 0;

    // 文字列選択位置を保存
    if ([node isEqualNode:[range startContainer]]) {
	c_start = [range startOffset];
    }
    if ([node isEqualNode:[range endContainer]]) {
	c_end = [range endOffset];
    }

    // 誤ったUnicodeテーブルが用いられている文字を本来の文字に置換
    for (i = 0; i < [[node data] length]; i++) {
	switch ([[node data] characterAtIndex:i]) {
	    case 0x2015: // ―
		[node replaceData:i length:1 data:@"—"]; // U+2014
		break;
	    case 0xff5e: // ～
		[node replaceData:i length:1 data:@"〜"]; // U+301c
		break;
	    case 0x2225: // ∥
		[node replaceData:i length:1 data:@"‖"]; // U+2016
		break;
	    case 0xff0d: // －
		[node replaceData:i length:1 data:@"−"]; // U+2212
		break;
	    case 0xffe0: // ￠
		[node replaceData:i length:1 data:@"¢"]; // U+00a2
		break;
	    case 0xffe1: // ￡
		[node replaceData:i length:1 data:@"£"]; // U+00a3
		break;
	    case 0xffe2: // ￢
		[node replaceData:i length:1 data:@"¬"]; // U+00ac
		break;
	}
    }

    for (i = 0; i < [[node data] length]; i++) {
	NSString *us = [[node data] substringWithRange:NSMakeRange(i, 1)];
	unichar   uc = [us characterAtIndex:0];
	NSInteger loc;
	NSString *ns = nil;
	if ([us canBeConvertedToEncoding:NSISO2022JPStringEncoding] != YES && uc != 0xa0) {
	    replaced++;
	    if ([app ver] >= LF_SnowLeopard || !isOpen) {
		if ((0x2460 <= uc && uc <= 0x2473) && ([app isOsDependentFix]==YES)) {       // ①〜⑳ -> (1)〜(20)
		    ns = [NSString stringWithFormat:@"(%-d)", (uc-0x2460+1)];
		} else if ((0x2160 <= uc && uc <= 0x2169) && ([app isOsDependentFix]==YES)) {// Ⅰ〜Ⅹ -> I〜X
		    ns = [NSString stringWithFormat:@"%s", roman[uc-0x2160]];
		} else if (((loc = [@"㍉㌔㌢㍍㌘㌧㌃㌶㍑㍗㌍㌦㌣㌫㍊㌻㎜㎝㎞㎎㎏㏄㍾㍽㍼㍻№㏍℡㊤㊥㊦㊧㊨㈱㈲㈹∑" rangeOfString:us].location) != NSNotFound)
			   && ([app isOsDependentFix]==YES)) {
		    ns = dep[loc];
		} else if ([app isAllLetterFix]==YES) {
		    ns = @"〓";
		} else {
		    ns = us;
		}
	    } else if ([app ver] == LF_Leopard) {
		loc = [@"㈰㈪㈫㈬㈭㈮㈯㉀㈷㉂㉃㈹㈺㈱㈾㈴㈲㈻㈶㈳㈵㈼㈽㈿㈸" rangeOfString:us].location;
		if (0 <= loc && loc <= 19) {
		    ns = [NSString stringWithFormat:@"(%-d)", (loc+1)];
		} else if (20 <= loc && loc <= 24) {
		    ns = [NSString stringWithFormat:@"%s", roman[loc-20]];
		} else if ([app isAllLetterFix]==YES) {
		    ns = @"〓";
		} else {
		    ns = us;
		}
	    } 
	    
	    if ((c_start != -1) && (i < c_start)) {
		c_start += [ns length] - 1;
	    }
	    if ((c_end != -1) && (i < c_end)) {
		c_end += [ns length] - 1;
	    }
	    if (!isCheck) {
		[node replaceData:i length:1 data:ns];
		i += [ns length] - 1;
	    }
	}
    }
    if (!isCheck) {
	if ((c_start != -1) && 0 < replaced) {
	    [range setStart:node offset:c_start];
	}
	if ((c_end != -1) && 0 < replaced) {
	    [range setEnd:node offset:c_end];
	}
    }
    return replaced;
}

int fixReflexively(DOMNode *node, DOMRange *range, BOOL isCheck, BOOL isOpen)
{
    DOMNode *n;
    int      replaced = 0;
    
    if ([node hasChildNodes]) {
	for (n = [node firstChild]; n != NULL; n = [n nextSibling]) {
	    replaced += fixReflexively(n, range, isCheck, isOpen); // 再帰的にノードをたどる
	}
    } else {
	if ([node nodeType] == DOM_TEXT_NODE) {
	    replaced = fixTextNode((DOMText*)node, range, isCheck, isOpen);
	}
    }
    return replaced;
}

int fixLetter(id self, id composeView, BOOL isCheck, BOOL isOpen)
{
    int replaced = 0;
    
    @try {
	WebFrame    *frame     = [(WebView *)composeView mainFrame];
	DOMDocument *dom       = [frame DOMDocument];
	DOMElement  *root      = [dom documentElement];
	DOMNodeList *nodelist  = [root getElementsByTagName:@"body"];
	
	if ([nodelist length] != 1) return -1;
	
	DOMNode     *body      = [nodelist item:0];
	DOMRange    *range     = [composeView selectedDOMRange];
	
	replaced = fixReflexively(body, range, isCheck, isOpen);
	
	if (0 < replaced && !isCheck) {
	    [composeView setSelectedDOMRange:range affinity:NSSelectionAffinityUpstream];
	}
    }
    @catch (NSException * e) {
	NSLog(@"LetterFix: caught %@ %@", [e name], [e reason]);
    }
    
    return replaced;
}

BOOL checkSubject(id self)
{
    NSMutableString *substr = [NSMutableString stringWithString:[[self backEnd] subject]];
    NSInteger i;
    
    for (i = 0; i < [substr length]; i++) {
	NSString *us = [substr substringWithRange:NSMakeRange(i, 1)];
	unichar   uc = [us characterAtIndex:0];
	switch (uc) {
	    case 0x2014: // —
            case 0x301c: // 〜
	    case 0x2016: // ‖
	    case 0x2212: // −
	    case 0x00a2: // ¢
	    case 0x00a3: // £
	    case 0x00ac: // ¬
                if ([app ver] >= LF_SnowLeopard) return TRUE;
                break;
	    case 0x2015: // ―
	    case 0xff5e: // ～
	    case 0x2225: // ∥
	    case 0xff0d: // －
	    case 0xffe0: // ￠
	    case 0xffe1: // ￡
	    case 0xffe2: // ￢
		return TRUE;
	    default:
		if ([us canBeConvertedToEncoding:NSISO2022JPStringEncoding] != YES) return TRUE;
		break;
	}
    }
    
    return FALSE;
}

void fixHeader(id self)
{
    NSMutableString *substr = [NSMutableString stringWithString:[[self backEnd] subject]];

    NSInteger i;
    for (i = 0; i < [substr length]; i++) {
	NSString *us = [substr substringWithRange:NSMakeRange(i, 1)];
	unichar   uc = [us characterAtIndex:0];
	NSString *ns;
	NSInteger loc;
	
	switch (uc) {
	    case 0x2015: // ―
                if ([app ver] == LF_Leopard) {
                    [substr replaceCharactersInRange:NSMakeRange(i, 1) withString:@"—"];
                    break;
                }
	    case 0xff5e: // ～
                if ([app ver] == LF_Leopard) {
                    [substr replaceCharactersInRange:NSMakeRange(i, 1) withString:@"〜"];
                    break;
                }
	    case 0xff0d: // －
                if ([app ver] == LF_Leopard) {
                    [substr replaceCharactersInRange:NSMakeRange(i, 1) withString:@"−"];
                    break;
                }
	    case 0x2014: // —
	    case 0x301c: // 〜
	    case 0x2212: // −
		if ([app ver] >= LF_SnowLeopard)[substr replaceCharactersInRange:NSMakeRange(i, 1) withString:@"-"];
		break;
	    case 0x2225: // ∥
                if ([app ver] == LF_Leopard) {
                    [substr replaceCharactersInRange:NSMakeRange(i, 1) withString:@"‖"];
                    break;
                }
	    case 0xffe0: // ￠
                if ([app ver] == LF_Leopard) {
                    [substr replaceCharactersInRange:NSMakeRange(i, 1) withString:@"¢"];
                    break;
                }
	    case 0xffe1: // ￡
                if ([app ver] == LF_Leopard) {
                    [substr replaceCharactersInRange:NSMakeRange(i, 1) withString:@"£"];
                    break;
                }
	    case 0xffe2: // ￢
                if ([app ver] == LF_Leopard) {
                    [substr replaceCharactersInRange:NSMakeRange(i, 1) withString:@"¬"];
                    break;
                }
	    case 0x2016: // ‖
	    case 0x00a2: // ¢
	    case 0x00a3: // £
	    case 0x00ac: // ¬
		if ([app ver] >= LF_SnowLeopard)[substr replaceCharactersInRange:NSMakeRange(i, 1) withString:@"〓"];
		break;                
	    default:
		if ([us canBeConvertedToEncoding:NSISO2022JPStringEncoding] != YES) {
		    if ((0x2460 <= uc && uc <= 0x2473) && ([app isOsDependentFix]==YES)) {       // ①〜⑳ -> (1)〜(20)
			ns = [NSString stringWithFormat:@"(%-d)", (uc-0x2460+1)];
		    } else if ((0x2160 <= uc && uc <= 0x2169) && ([app isOsDependentFix]==YES)) {// Ⅰ〜Ⅹ -> I〜X
			ns = [NSString stringWithFormat:@"%s", roman[uc-0x2160]];
		    } else if (((loc = [@"㍉㌔㌢㍍㌘㌧㌃㌶㍑㍗㌍㌦㌣㌫㍊㌻㎜㎝㎞㎎㎏㏄㍾㍽㍼㍻№㏍℡㊤㊥㊦㊧㊨㈱㈲㈹∑" rangeOfString:us].location) != NSNotFound)
			       && ([app isOsDependentFix]==YES)) {
			ns = dep[loc];
		    } else {
			ns = @"〓";
		    }
		    [substr replaceCharactersInRange:NSMakeRange(i, 1) withString:ns];
		    if (1 < [ns length]) {
			i += [ns length] - 1;
		    }
		}
		break;
	}
    }
    [[(LetterFix *)self backEnd] setSubject:substr];
    [[self window] setTitle:substr];

    id headers = [self headersEditor];
    NSTextField *subjectField = nil;
    if ([app ver] == LF_Leopard || [app ver] == LF_SnowLeopard) {
	object_getInstanceVariable(headers, "subjectField", (void **)&subjectField);
    } else if ([app ver] == LF_Lion || [app ver] == LF_MountainLion) {
	object_getInstanceVariable(headers, "_subjectField", (void **)&subjectField);
    }
    if (subjectField != nil)
	[subjectField setStringValue:substr];
}

BOOL _isLoaded(id self, SEL _cmd)
{
    BOOL result = [self _isLoaded]; // call swizzled(original) method
    if ([app isActive] == NO) {
	return result;
    }
    if (result == NO) {
	[khash removeObject:self];
	return result;
    }
    if ([khash containsObject:self] == YES) return result;
    
    @try {
	id composeView = [self webView];
	if ((composeView==NULL) || ([(WebView *)composeView isLoading]==YES) || ([(WebView *)composeView isEditable]==NO))
	    return result;
	
	id backend   = [self backEnd];
	if ([app changeEncode]==YES)
	    [backend setPreferredEncoding:0x820];    
	[khash addObject:self];
	
	switch ([self messageType]) {
	    case 1: // 返信
	    case 2: // 全員に返信
	    case 3: // 転送
	    case 4: // 下書きを開く
	    case 7: // リダイレクト
	    case 8: // 差出人に返信
		break;
	    case 5: // 新規メッセージ
	    case 14:// 添付ファイルとして返信
		return result;
	    default:
		NSLog(@"Unknown MessageType: %d", [self messageType]);
		return result;
	}
	
	if (0 < fixLetter(self, [self webView], TRUE, TRUE)) {
	  if ([app operationAtOpen] == 0) {
	    NSAlert *alert = [[[NSAlert alloc] init] autorelease];
	    [alert addButtonWithTitle:@"変換"];
	    [alert addButtonWithTitle:@"変換しない"];
	    [alert setShowsSuppressionButton:TRUE];
	    [alert setMessageText:@"編集前にメッセージを変換しますか？"];
	    [alert setInformativeText:@"このメッセージには ISO 2022-JP に変換できない文字が含まれています。"
	     @"変換しない場合、エンコーディングを「自動」に設定します。"];
	    [alert setAlertStyle:NSInformationalAlertStyle];
	    [alert beginSheetModalForWindow:[self window] modalDelegate:self didEndSelector:@selector(alert0DidEnd:returnCode:contextInfo:) contextInfo:nil];
	  } else if ([app operationAtOpen] == 1) {
	    fixLetter(self, [self webView], FALSE, TRUE);
	    [[self backEnd] setHasChanges:FALSE];
	  }
	}
    }
    @catch (NSException * exception) {
	NSLog(@"LetterFix: caught %@ %@", [exception name], [exception reason]);
    }
    
    return result;
}

void alert0DidEnd_returnCode_contextInfo_(id self, SEL _cmd, id alert, int returnCode, void* arg1)
{
    if (returnCode == NSAlertFirstButtonReturn) {
	fixLetter(self, [self webView], FALSE, TRUE);
	[[self backEnd] setHasChanges:FALSE];
    } else if (returnCode == NSAlertSecondButtonReturn) {
	[[self backEnd] setPreferredEncoding:-1];
    }
    if ([[alert suppressionButton] state] == NSOnState) {
	if (returnCode == NSAlertFirstButtonReturn) {
	  [app setOperationAtOpen:1];
	} else if (returnCode == NSAlertSecondButtonReturn) {
	  [app setOperationAtOpen:2];
	}
    }
}

void _send_(id self, SEL _cmd, id arg1) 
{
    if (([app isActive] != NO) && (0 < fixLetter(self, [self webView], TRUE, FALSE))) {
	NSAlert *alert = [[[NSAlert alloc] init] autorelease];
	[alert addButtonWithTitle:@"変換して送信"];
	[alert addButtonWithTitle:@"キャンセル"];
	[alert addButtonWithTitle:@"変換せずに送信"];
	[alert addButtonWithTitle:@"変換のみ"];
	[alert setMessageText:@"メッセージを変換して送信しますか？"];
	[alert setInformativeText:@"送信しようとしているメッセージには ISO 2022-JP に変換できない文字が含まれています。"
	 @"ISO 2022-JP で送信するためには、これらの文字を変換可能なものに置き換える必要があります。\n"
	 @"変換せずに送信する場合、エンコーディング設定を「自動」に設定の上送信します。"];
	[alert setAlertStyle:NSInformationalAlertStyle];
	[alert beginSheetModalForWindow:[self window] modalDelegate:self didEndSelector:@selector(alert1DidEnd:returnCode:contextInfo:) contextInfo:arg1];
    } else if (([app isActive] != NO) && ([app isCheckSubject] != NO) && checkSubject(self)) {
	FL_alertSubject(self, _cmd, arg1);
    } else {
	[self _send: arg1];
    }
}

void FL_alertSubject(id self, SEL _cmd, id arg1)
{
    NSAlert *alert = [[[NSAlert alloc] init] autorelease];
    [alert addButtonWithTitle:@"変換して送信"];
    [alert addButtonWithTitle:@"キャンセル"];
    [alert addButtonWithTitle:@"変換せずに送信"];
    [alert addButtonWithTitle:@"変換のみ"];
    [alert setMessageText:@"件名に ISO 2022-JP に変換できない文字が含まれています"];
    [alert setInformativeText:@"送信するメッセージの件名に ISO 2022-JP に変換できない文字が含まれています。\n"
     @"なお Mail.app のバグにより、件名に本来は ISO 2022-JP に変換可能な一部の文字（—―−－〜～‖∥¢￠£￡¬￢）が含まれていると、"
     @"件名を UTF-8 の MIMEエンコードで送信します。そのため、これらの文字も置き換えて送信します。"];
    [alert setAlertStyle:NSInformationalAlertStyle];
    [alert beginSheetModalForWindow:[self window] modalDelegate:self didEndSelector:@selector(alert3DidEnd:returnCode:contextInfo:) contextInfo:arg1];
}

void alert1DidEnd_returnCode_contextInfo_(id self, SEL _cmd, id alert, int returnCode, void* arg1)
{
    if (returnCode == NSAlertFirstButtonReturn) {
	fixLetter(self, [self webView], FALSE, FALSE);
	if ([[self backEnd] preferredEncoding] != 0x820) [[self backEnd] setPreferredEncoding:0x820];
	[[alert window] orderOut:arg1];
	if (([app isCheckSubject] != NO) && checkSubject(self)) FL_alertSubject(self, _cmd, arg1);
	else [self _send: arg1];
    } else if (returnCode == NSAlertSecondButtonReturn) {
	// Cancel
    } else if (returnCode == NSAlertThirdButtonReturn) {
	if ([[self backEnd] preferredEncoding] == 0x820) [[self backEnd] setPreferredEncoding:-1];
	[[alert window] orderOut:arg1];
	[self _send: arg1];
    } else if (returnCode == (NSAlertThirdButtonReturn + 1)) {
	fixLetter(self, [self webView], FALSE, FALSE);
	if ([[self backEnd] preferredEncoding] != 0x820) [[self backEnd] setPreferredEncoding:0x820];
    }
}

void alert3DidEnd_returnCode_contextInfo_(id self, SEL _cmd, id alert, int returnCode, void* arg1)
{
    if (returnCode == NSAlertFirstButtonReturn) {
	fixHeader(self);
	[[alert window] orderOut:arg1];
	[self _send: arg1];
    } else if (returnCode == NSAlertSecondButtonReturn) {
	// Cancel
    } else if (returnCode == NSAlertThirdButtonReturn) {
	[[alert window] orderOut:arg1];
	[self _send: arg1];
    } else if (returnCode == (NSAlertThirdButtonReturn + 1)) {
	fixHeader(self);
    }
}

void _saveDocument_(id self, SEL _cmd, id arg1) 
{
    if (([app isActive] != NO) && (0 < fixLetter(self, [self webView], TRUE, FALSE)) && ([[self backEnd] preferredEncoding] == 0x820)) {
	NSAlert *alert = [[[NSAlert alloc] init] autorelease];
	[alert addButtonWithTitle:@"変換"];
	[alert addButtonWithTitle:@"変換しない"];
	[alert setMessageText:@"保存前にメッセージを変換しますか？"];
	[alert setInformativeText:@"このメッセージには ISO 2022-JP エンコーディングに変換できない文字が含まれています。"
	 @"ISO 2022-JP で保存するためには、これらの文字を変換可能なものに置き換える必要があります。\n"
	 @"変換しない場合、保存のためエンコーディングの設定を「自動」に変更します。"];
	[alert setAlertStyle:NSWarningAlertStyle];
	[alert beginSheetModalForWindow:[self window] modalDelegate:self didEndSelector:@selector(alert2DidEnd:returnCode:contextInfo:) contextInfo:arg1];
    } else {
	[self _saveDocument: arg1];
    }
}

void alert2DidEnd_returnCode_contextInfo_(id self, SEL _cmd, id alert, int returnCode, void* arg1)
{
    if (returnCode == NSAlertFirstButtonReturn) {
	fixLetter(self, [self webView], FALSE, FALSE);
    } else if (returnCode == NSAlertSecondButtonReturn) {
	[[self backEnd] setPreferredEncoding:-1];
    }
    [[alert window] orderOut:arg1];
    [self _saveDocument: (id)arg1];
}

#define MailDocumentEditor (NSClassFromString(@"MailDocumentEditor")) // hidden Mail.app class
#define MVMailBundle       (NSClassFromString(@"MVMailBundle"))

@implementation LetterFix
+ (void) initialize
{
    class_setSuperclass([self class], MVMailBundle); // depricated function 10.5対応のためこのワーニングだけは消せません
    [super initialize];
    [self registerBundle];
    
    //
    // swizzling method 
    //
    swizzlingMethod(MailDocumentEditor, @selector(isLoaded), @selector(_isLoaded), (IMP)_isLoaded);
    swizzlingMethod(MailDocumentEditor, @selector(send:), @selector(_send:), (IMP)_send_);
    swizzlingMethod(MailDocumentEditor, @selector(saveDocument:), @selector(_saveDocument:), (IMP)_saveDocument_);
    class_addMethod(MailDocumentEditor, @selector(alert0DidEnd:returnCode:contextInfo:), (IMP)alert0DidEnd_returnCode_contextInfo_, "v@:@i^v");
    class_addMethod(MailDocumentEditor, @selector(alert1DidEnd:returnCode:contextInfo:), (IMP)alert1DidEnd_returnCode_contextInfo_, "v@:@i^v");
    class_addMethod(MailDocumentEditor, @selector(alert2DidEnd:returnCode:contextInfo:), (IMP)alert2DidEnd_returnCode_contextInfo_, "v@:@i^v");
    class_addMethod(MailDocumentEditor, @selector(alert3DidEnd:returnCode:contextInfo:), (IMP)alert3DidEnd_returnCode_contextInfo_, "v@:@i^v");
    //
    // end of swizzling method
    //
    
    khash = [[NSMutableArray alloc] initWithCapacity:1];
    
    app = [[LFApp alloc] init];
    
    NSLog(@"LetterFix Plugin (version %s/%lx) is registered.", LETTERFIX_VERSION, [app ver]);
}
@end