%
% This is part of BLFSbookja package.
%
% This is a CTIE change file for the original XML source of the BLFSbook.
%
% $Author: matsuand $
% $Rev: 304 $
% $Date: 2011-04-20 13:11:17 +0900 (Wed, 20 Apr 2011) $
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Window Managers</title>
@y
  <title>ウィンドウマネージャー</title>
@z

@x
    <title>Introduction</title>
@y
    <title>はじめに</title>
@z

@x
    <para>Window Managers and Desktop Environments are the primary user
    interfaces into the <application>X</application> Window System. A window
    manager is a program that controls the appearance of windows and provides
    the means by which the user can interact with them. A Desktop Environment
    provides a more complete interface to the operating system, and provides a
    range of integrated utilities and applications.</para>
@y
    <para>
    ウィンドウマネージャー (Window Manager) とデスクトップ環境 (Desktop Environment) は <application>X</application> ウィンドウシステムにおける主要なユーザーインターフェースです。
    ウィンドウマネージャーは、ウィンドウの見た目を制御し、ユーザーがウィンドウとのやり取りを行うための手段を提供するものです。
    デスクトップ環境は、さらに完全なものとしてオペレーティングシステムとの間のインターフェースを提供します。
    そして数多くのユーティリティやアプリケーションも提供します。
    </para>
@z

@x
    <para>There are many Window Managers available. Some of the more well
    known ones include <application>fvwm2</application>, <application>Window
    Maker</application>, <application>AfterStep</application>,
    <application>Enlightenment</application>,
    <application>Sawfish</application>,
    and <application>Blackbox</application>.</para>
@y
    <para>
    ウィンドウマネージャーは実に多くのものがあります。
    よく知られているものとして <application>fvwm2</application>, <application>Window Maker</application>, <application>AfterStep</application>, <application>Enlightenment</application>, <application>Sawfish</application>, <application>Blackbox</application> があります。
    </para>
@z

@x
    <para>The Desktop Environments available for Linux are
    <application>GNOME</application>, <application>KDE</application>, and
    <application>XFce</application>.</para>
@y
    <para>
    Linux において利用可能なデスクトップ環境 (Desktop Environments) には <application>GNOME</application>, <application>KDE</application>, <application>XFce</application> があります。
    </para>
@z

@x
    <para>Choosing a Window Manager or Desktop Environment is highly
    subjective. The choice depends on the look and feel of the packages, the
    resources (RAM, disk space) required, and the utilities included.
    One web site that provides a very good summary of what is available,
    screenshots, and their respective features is
    <ulink url="http://www.plig.org/xwinman/">Window Managers for
    X</ulink>.</para>
@y
    <para>
    ウィンドウマネージャーやデスクトップ環境をどれにするかは極めて主観的なものです。
    選択にあたって考慮する観点には、見映えや操作感、必要となるリソース (RAM, ディスクスペース)、導入されるユーティリティが何か、といったものです。
    どのようなものが利用可能か、どういった機能があるか、という概要を、スクリーンショットをまじえて説明している以下のウェブサイトがあります。
    <ulink url="http://www.plig.org/xwinman/">X におけるウィンドウマネージャー (Window Managers for X)</ulink>
    </para>
@z

@x
    <para>In this chapter, the installation instructions of several Window
    Managers and one lightweight Desktop Environment are presented. Later in
    the book, both <application>KDE</application> and
    <application>GNOME</application> have their own sections.</para>
@y
    <para>
    本章ではウィンドウマネージャーのいくつかと、一つの軽量デスクトップ環境について、そのインストール手順を示します。
    本章以降の別の章にて <application>KDE</application> と
    <application>GNOME</application> を説明しています。
    </para>
@z
