/***********************************************************
	decode.c
***********************************************************/
#include "ar.h"

extern struct lha_opts opts;

static off_t
put_decode_buf(char *buf, size_t size,
               uint32_t *pos, uint32_t c, size_t *limit,
               FILE *outfile, off_t remainder, uint16_t *crc)
{
    buf[(*pos)++] = c;

    if (*pos == *limit) {
        fwrite_crc(buf, *limit, outfile, crc);
        if (outfile != stdout && opts.quiet < 1) {
            putc('.', stdout);
        }

        remainder -= *limit;
        if (remainder == 0) return 0;

        *pos = 0;
        *limit = (uint)MIN(remainder, size);
        return remainder;
    }

    return remainder;
}

void
decode(struct lzh_istream *rp, FILE *outfile, off_t remainder, uint16_t *crc)
{
    char buf[MAXDICSIZ];
    uint32_t pos;
    size_t limit;

    huf_decode_start(rp, opts.method);

    pos = 0;
    limit = (size_t)MIN(remainder, MAXDICSIZ);

    for (;;) {
        uint16_t c = decode_c(rp);
        if (c <= UCHAR_MAX) {
            remainder = put_decode_buf(buf, sizeof(buf), &pos, c, &limit,
                                       outfile, remainder, crc);
            if (remainder == 0) return;
        }
        else {
            uint32_t off;
            uint16_t len, i;

            len = c - (UCHAR_MAX + 1 - THRESHOLD);
            off = (pos - decode_p(rp) - 1) & (MAXDICSIZ - 1);

            for (i = 0; i < len; i++) {
                remainder = put_decode_buf(buf, sizeof(buf), &pos, buf[off],
                                           &limit,
                                           outfile, remainder, crc);
                if (remainder == 0) return;
                off = (off+1) & (MAXDICSIZ - 1);
            }
        }
    }
}
