#!/bin/bash

print_usage()
{
  cat <<EOF
usage: $0 [-n] [test number]

option:
   -n:   do not cleanup.
EOF
  exit
}

for _opt
do
   case $_opt in
   --help) print_usage ;;
   -n) no_cleanup=true; shift ;;
   *) perform_number=$1; shift ;;
   esac
done

# Be Bourne compatible
# -- followings are derived from configure script generated by autoconf 2.59 --
if test -n "${ZSH_VERSION+set}" && (emulate ksh) >/dev/null 2>&1; then
  emulate ksh
  NULLCMD=:
  # Zsh 3.x and 4.x performs word splitting on ${1+"$@"}, which
  # is contrary to our usage.  Disable this feature.
  alias -g '${1+"$@"}'='"$@"'
elif test -n "${BASH_VERSION+set}" && (set -o posix) >/dev/null 2>&1; then
  set -o posix
fi
DUALCASE=1; export DUALCASE # for MKS sh

: ${lha_dir=$(cd . && pwd)}
: ${lha_cmd=$(cd $lha_dir && pwd)/olha}
: ${srcdir=$(cd ./tests && pwd)}
: ${builddir=$srcdir}

cd $builddir || exit 1

if [[ x$no_cleanup = x ]]; then
  trap '_stat=$?; chmod -R 755 test-* 2>/dev/null;
        rm -rf test-*; exit $_stat' 0 1 2 3 15
fi

typeset -i i	# for loop
typeset -i test_number=0 error_num=0
error_tests=""

# fd 1: for logging
# fd 2: output screen
# fd 5: for logging
exec 5>test.log >&5

lha=exec_lha
exec_lha()
{
  echo "$ $lha_cmd $@" >&5	# for logging (stdout(fd 1) may be redirected)
  $lha_cmd "$@"
}

message()
{
  echo "$@" >&2
  echo "$@"
}

check()
{
  ((test_number = test_number + 1))
  typeset exit_status=$1
  typeset lineno=$2
  if [[ $exit_status -eq 0 ]]; then
    echo    "$FILENAME #$test_number ... ok" >&2
    echo    "$FILENAME #$test_number ... ok at line $lineno"
  else
    message "$FILENAME #$test_number ... failed at line $lineno"
    ((error_num = error_num + 1))
    error_tests="$error_tests $FILENAME #$test_number"
    result=1
  fi
}

cleanup()
{
  if [[ x$no_cleanup = x ]]; then
    chmod -R 755 test-tmp* 2>/dev/null
    rm -rf test-tmp*
  fi
}

testsuite()
{
    # the `FILENAME' variable should be set the each test filename.
    FILENAME=$1 test_number=0

    . $srcdir/$FILENAME

    cleanup
}

# utility functions

change_timestamp()
{
    typeset time=$1; shift

    # assume that `touch' command supports POSIX's -t switch.

    # -t [[CC]YY]MMDDhhmm[.ss]
    touch -t $time "$@"

    # [[CC]YY]MMDDhhmm
    # touch $time "$@"
}

# test start

message testing $lha_cmd
message `$lha --version 2>&1`

testsuite lha-test1		# create test data. it is needed for each test

if [[ $perform_number != "" ]] && [[ $perform_number != all ]]; then
  testsuite lha-test$perform_number
else
  testsuite lha-test2
  testsuite lha-test3
  testsuite lha-test4
  testsuite lha-test5
  #testsuite lha-test6		# this feature was removed.
  testsuite lha-test7
  testsuite lha-test8
  #testsuite lha-test9		# incomplete
  testsuite lha-test10
  testsuite lha-test11
  testsuite lha-test12
  testsuite lha-test13
  case `$lha --version 2>&1` in
  *djgpp* | *-pc-mingw*)
    # No symlink support on DJGPP and MinGW
    message testing to handle symbolic links ... skip
    ;;
  *)
    testsuite lha-test14
  esac
  testsuite lha-test15
  testsuite lha-test16
  testsuite lha-test17
  testsuite lha-test18
  # followings will take a long time
  if [[ $perform_number = all ]]; then
    testsuite lha-test51	# extract 2G over files
    testsuite lha-test52	# extract 4G over files
  fi
fi

if (( $error_num != 0 )); then
  message $error_num tests failed!
  message test number: $error_tests
fi

exit $result
