/***********************************************************
	ar.h
***********************************************************/
#include <stdio.h>
#include <stdint.h>
#include <limits.h>
#include <sys/types.h>

typedef unsigned char uchar;    /*  8 bits or more */
typedef unsigned int uint;      /* 16 bits or more */
typedef unsigned short ushort;  /* 16 bits or more */
typedef unsigned long ulong;    /* 32 bits or more */

struct lzh_istream {
    FILE *fp;
    unsigned long compsize;

    unsigned short bitbuf, subbitbuf;
    int bitcount;
};

struct lzh_ostream {
    FILE *fp;
    unsigned long compsize;
    unsigned long origsize;
    int unpackable;

    unsigned short subbitbuf;
    int bitcount;

    unsigned int crc;
};

struct lzh_header {
    char filename[1024];
    int  namelen;
    char method[5];
    int compsize;
    int origsize;
    time_t mtime;
    int file_crc;
    char os_id;
    int level;
};

struct lha_method {
    char *id;
    int dicbit;
    int pbit;
    int maxmatch;
};

struct lha_opts {
    int nocompress;
    char *outdir;
    int quiet;
    int header_level;
    int generic;
    int verbose;
    int force_extract;
    int archive_to_stdio;

    /* compress parameter */
    struct lha_method *method;
};
#define INITIALIZE_OPTS(opts)                   \
    do {                                        \
        (opts).nocompress = 0;                  \
        (opts).outdir = NULL;                   \
        (opts).quiet = 0;                       \
        (opts).header_level = 2;                \
        (opts).generic = 0;                     \
        (opts).verbose = 0;                     \
        (opts).force_extract = 0;               \
        (opts).archive_to_stdio = 0;            \
                                                \
        /* default is the -lh5- method */       \
        (opts).method   = &methods[5];          \
    } while (0)

/* ar.c */
extern struct lha_opts opts;

/* io.c */

#define INIT_CRC  0             /* CCITT: 0xFFFF */
#define UPDATE_CRC(crc, c) \
    (crc) = crctable[((crc) ^ (unsigned char)(c)) & 0xFF] ^ ((crc) >> CHAR_BIT)

#define BITBUFSIZ (CHAR_BIT * sizeof(unsigned short)) /* size of bitbuf */

/* encode.c and decode.c */

#define MAXDICBIT    16            /* 12(-lh4-) or 13(-lh5-) */
#define MAXDICSIZ (1U << MAXDICBIT)
#define MATCHBIT   8            /* bits for MAXMATCH - THRESHOLD */
#define MAXMATCH 256            /* formerly F (not more than UCHAR_MAX + 1) */
#define THRESHOLD  3            /* choose optimal value */

/* huf.c */

#define NC (UCHAR_MAX + MAXMATCH + 2 - THRESHOLD)
        /* alphabet = {0, 1, 2, ..., NC - 1} */
#define CBIT 9                  /* $\lfloor \log_2 NC \rfloor + 1$ */
#define CODE_BIT  16            /* codeword length */

extern ushort left[], right[];

#include "prototypes.h"
