#include "ar.h"

void
list_start(void)
{
    if (opts.quiet < 2)
        printf("%-14.14s %-7.7s %10.10s %10.10s %-5.5s %-4.4s %-5.5s %-4.4s\n",
               "Filename",
               "OS",
               "Original",
               "Compressed",
               "Ratio",
               "CRC",
               "Method",
               "Lv");
}

static char*
os_string(char id)
{
    int i;
    static struct os {
        char id;
        char *name;
    } os_types[] = {
        {'M',  "MS-DOS"},       /* Microsoft */
        {'U',  "Unix"},         /* Unix or POSIX compliant OS */
        {'J',  "Java"},         /* Sun Microsystems */
        {'\0', "generic"},
        {'w',  "Win9x"},        /* reserved by UNLHA32.DLL */
        {'W',  "WinNT"},        /* reserved by UNLHA32.DLL */
        {'2',  "OS/2"},         /* IBM OS/2 */
        {'9',  "OS9"},          /* unknown */
        {'K',  "OS/68K"},       /* unknown */
        {'3',  "OS/386"},       /* unknown */
        {'H',  "Human"},        /* SHARP Human68K */
        {'C',  "CP/M"},         /* Digital Research */
        {'F',  "FLEX"},         /* unknown */
        {'m',  "Mac"},          /* Apple */
        {'R',  "Runser"},       /* unknown */
        {'T',  "TownsOS"},      /* Fujitsu FM-TOWNS */
        {'X',  "XOSK"},         /* unknown */
    };

    for (i = 0; i < sizeof(os_types)/sizeof(os_types[0]); i++) {
        if (id == os_types[i].id)
            return os_types[i].name;
    }

    return "Unknown";
}

void
list(struct lzh_header *h)
{
    uint r;

    printf("%-14.*s", h->namelen, h->filename);
    if (h->namelen > 14)
        printf("\n              ");
    r = ratio(h->compsize, h->origsize);
    printf(" %-7s %10lu %10lu %u.%03u %04x %-6.6s [%d]\n",
           os_string(h->os_id),
           h->origsize,
           h->compsize,
           r / 1000,
           r % 1000,
           h->file_crc,
           h->method,
           h->level);
}
