/*
* See the file LICENSE for redistribution information.
*
* Copyright: 2010- 1stclass.co.jp.  All rights reserved.
*
* Created by Hajime Kurita
*/
#include <string.h>

#ifdef __cplusplus
#include "1stclass.hpp"
int firstclass::itoa(int n, char s[]){
#else
#include "1stclass.h"
int itoa(int n, char s[]){
#endif
  int i, sign;
  if ((sign = n) < 0)
    n = -n;
  i = 0;
  do { // generate digits in reverse order
    s[i++] = n % 10 + '0'; // get next digit
  } while ((n /= 10) > 0); // delete it
  if (sign < 0)
    s[i++] = '-';
  s[i] = '\0';
  reverse_char(s);
  return 0;
}
