/*
* See the file LICENSE for redistribution information.
*
* Copyright: 2010- 1stclass.co.jp.  All rights reserved.
*
* Created by Hajime Kurita
*/
#include <string.h>

#ifdef __cplusplus
#include "1stclass.hpp"
string firstclass::shmf(const string in_file){
  const char *file=in_file.c_str();
  char shm_file[2048]="";
#else
#include "1stclass.h"
int shmf(const char *file, char *shm_file){
#endif

  char tmp_file[2048]="";
  int i;
  safe_strcat(tmp_file, file, sizeof(tmp_file));
  for(i=0;i<2048;i++){
    if(tmp_file[i] == '/'){
      tmp_file[i]='_';
    }
    else if(tmp_file[i] == '\0'){
      break;
    }
  }

  safe_strcat(shm_file, "/dev/shm/", 2048);
  safe_strcat(shm_file, tmp_file, 2048);

#ifdef __cplusplus
  string result(shm_file);
  return result;
#else
  return 0;
#endif
}
