#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/gpio.h>
#include <cpu/sh7722.h>

enum {
	PINMUX_RESERVED = 0,

	PINMUX_DATA_BEGIN,
	PTA7_DATA, PTA6_DATA, PTA5_DATA, PTA4_DATA,
	PTA3_DATA, PTA2_DATA, PTA1_DATA, PTA0_DATA,
	PTB7_DATA, PTB6_DATA, PTB5_DATA, PTB4_DATA,
	PTB3_DATA, PTB2_DATA, PTB1_DATA, PTB0_DATA,
	PTC7_DATA, PTC5_DATA, PTC4_DATA, PTC3_DATA, PTC2_DATA, PTC0_DATA,
	PTD7_DATA, PTD6_DATA, PTD5_DATA, PTD4_DATA,
	PTD3_DATA, PTD2_DATA, PTD1_DATA, PTD0_DATA,
	PTE7_DATA, PTE6_DATA, PTE5_DATA, PTE4_DATA, PTE1_DATA, PTE0_DATA,
	PTF6_DATA, PTF5_DATA, PTF4_DATA,
	PTF3_DATA, PTF2_DATA, PTF1_DATA, PTF0_DATA,
	PTG4_DATA, PTG3_DATA, PTG2_DATA, PTG1_DATA, PTG0_DATA,
	PTH7_DATA, PTH6_DATA, PTH5_DATA, PTH4_DATA,
	PTH3_DATA, PTH2_DATA, PTH1_DATA, PTH0_DATA,
	PTJ7_DATA, PTJ6_DATA, PTJ5_DATA, PTJ1_DATA, PTJ0_DATA,
	PTK6_DATA, PTK5_DATA, PTK4_DATA,
	PTK3_DATA, PTK2_DATA, PTK1_DATA, PTK0_DATA,
	PTL7_DATA, PTL6_DATA, PTL5_DATA, PTL4_DATA,
	PTL3_DATA, PTL2_DATA, PTL1_DATA, PTL0_DATA,
	PTM7_DATA, PTM6_DATA, PTM5_DATA, PTM4_DATA,
	PTM3_DATA, PTM2_DATA, PTM1_DATA, PTM0_DATA,
	PTN7_DATA, PTN6_DATA, PTN5_DATA, PTN4_DATA,
	PTN3_DATA, PTN2_DATA, PTN1_DATA, PTN0_DATA,
	PTQ6_DATA, PTQ5_DATA, PTQ4_DATA,
	PTQ3_DATA, PTQ2_DATA, PTQ1_DATA, PTQ0_DATA,
	PTR4_DATA, PTR3_DATA, PTR2_DATA, PTR1_DATA, PTR0_DATA,
	PTS4_DATA, PTS3_DATA, PTS2_DATA, PTS1_DATA, PTS0_DATA,
	PTT4_DATA, PTT3_DATA, PTT2_DATA, PTT1_DATA, PTT0_DATA,
	PTU4_DATA, PTU3_DATA, PTU2_DATA, PTU1_DATA, PTU0_DATA,
	PTV4_DATA, PTV3_DATA, PTV2_DATA, PTV1_DATA, PTV0_DATA,
	PTW6_DATA, PTW5_DATA, PTW4_DATA,
	PTW3_DATA, PTW2_DATA, PTW1_DATA, PTW0_DATA,
	PTX6_DATA, PTX5_DATA, PTX4_DATA,
	PTX3_DATA, PTX2_DATA, PTX1_DATA, PTX0_DATA,
	PTY6_DATA, PTY5_DATA, PTY4_DATA,
	PTY3_DATA, PTY2_DATA, PTY1_DATA, PTY0_DATA,
	PTZ5_DATA, PTZ4_DATA, PTZ3_DATA, PTZ2_DATA, PTZ1_DATA, PTZ0_DATA,
	PINMUX_DATA_END,

	PINMUX_INPUT_BEGIN,
	PTA7_IN, PTA6_IN, PTA5_IN, PTA4_IN,
	PTA3_IN, PTA2_IN, PTA1_IN, PTA0_IN,
	PTB7_IN, PTB6_IN, PTB5_IN, PTB4_IN,
	PTB3_IN, PTB2_IN, PTB1_IN, PTB0_IN,
	PTC7_IN, PTC5_IN, PTC4_IN, PTC3_IN, PTC2_IN, PTC0_IN,
	PTD7_IN, PTD6_IN, PTD5_IN, PTD4_IN, PTD3_IN, PTD2_IN, PTD1_IN,
	PTE7_IN, PTE6_IN, PTE5_IN, PTE4_IN, PTE1_IN, PTE0_IN,
	PTF6_IN, PTF5_IN, PTF4_IN, PTF3_IN, PTF2_IN, PTF1_IN,
	PTH6_IN, PTH5_IN, PTH1_IN, PTH0_IN,
	PTJ1_IN, PTJ0_IN,
	PTK6_IN, PTK5_IN, PTK4_IN, PTK3_IN, PTK2_IN, PTK0_IN,
	PTL7_IN, PTL6_IN, PTL5_IN, PTL4_IN,
	PTL3_IN, PTL2_IN, PTL1_IN, PTL0_IN,
	PTM7_IN, PTM6_IN, PTM5_IN, PTM4_IN,
	PTM3_IN, PTM2_IN, PTM1_IN, PTM0_IN,
	PTN7_IN, PTN6_IN, PTN5_IN, PTN4_IN,
	PTN3_IN, PTN2_IN, PTN1_IN, PTN0_IN,
	PTQ5_IN, PTQ4_IN, PTQ3_IN, PTQ2_IN, PTQ0_IN,
	PTR2_IN,
	PTS4_IN, PTS2_IN, PTS1_IN,
	PTT4_IN, PTT3_IN, PTT2_IN, PTT1_IN,
	PTU4_IN, PTU3_IN, PTU2_IN, PTU1_IN, PTU0_IN,
	PTV4_IN, PTV3_IN, PTV2_IN, PTV1_IN, PTV0_IN,
	PTW6_IN, PTW4_IN, PTW3_IN, PTW2_IN, PTW1_IN, PTW0_IN,
	PTX6_IN, PTX5_IN, PTX4_IN, PTX3_IN, PTX2_IN, PTX1_IN, PTX0_IN,
	PTY5_IN, PTY4_IN, PTY3_IN, PTY2_IN, PTY0_IN,
	PTZ5_IN, PTZ4_IN, PTZ3_IN, PTZ2_IN, PTZ1_IN,
	PINMUX_INPUT_END,

	PINMUX_INPUT_PULLDOWN_BEGIN,
	PTA7_IN_PD, PTA6_IN_PD, PTA5_IN_PD, PTA4_IN_PD,
	PTA3_IN_PD, PTA2_IN_PD, PTA1_IN_PD, PTA0_IN_PD,
	PTE7_IN_PD, PTE6_IN_PD, PTE5_IN_PD, PTE4_IN_PD,	PTE1_IN_PD, PTE0_IN_PD,
	PTF6_IN_PD, PTF5_IN_PD, PTF4_IN_PD, PTF3_IN_PD, PTF2_IN_PD, PTF1_IN_PD,
	PTH6_IN_PD, PTH5_IN_PD, PTH1_IN_PD, PTH0_IN_PD,
	PTK6_IN_PD, PTK5_IN_PD, PTK4_IN_PD, PTK3_IN_PD, PTK2_IN_PD, PTK0_IN_PD,
	PTL7_IN_PD, PTL6_IN_PD, PTL5_IN_PD, PTL4_IN_PD,
	PTL3_IN_PD, PTL2_IN_PD, PTL1_IN_PD, PTL0_IN_PD,
	PTM7_IN_PD, PTM6_IN_PD, PTM5_IN_PD, PTM4_IN_PD,
	PTM3_IN_PD, PTM2_IN_PD, PTM1_IN_PD, PTM0_IN_PD,
	PTQ5_IN_PD, PTQ4_IN_PD, PTQ3_IN_PD, PTQ2_IN_PD,
	PTS4_IN_PD, PTS2_IN_PD, PTS1_IN_PD,
	PTT4_IN_PD, PTT3_IN_PD, PTT2_IN_PD, PTT1_IN_PD,
	PTU4_IN_PD, PTU3_IN_PD, PTU2_IN_PD, PTU1_IN_PD, PTU0_IN_PD,
	PTV4_IN_PD, PTV3_IN_PD, PTV2_IN_PD, PTV1_IN_PD, PTV0_IN_PD,
	PTW6_IN_PD, PTW4_IN_PD,	PTW3_IN_PD, PTW2_IN_PD, PTW1_IN_PD, PTW0_IN_PD,
	PTX6_IN_PD, PTX5_IN_PD, PTX4_IN_PD,
	PTX3_IN_PD, PTX2_IN_PD, PTX1_IN_PD, PTX0_IN_PD,
	PINMUX_INPUT_PULLDOWN_END,

	PINMUX_INPUT_PULLUP_BEGIN,
	PTC7_IN_PU, PTC5_IN_PU,
	PTD7_IN_PU, PTD6_IN_PU, PTD5_IN_PU, PTD4_IN_PU,
	PTD3_IN_PU, PTD2_IN_PU, PTD1_IN_PU,
	PTJ1_IN_PU, PTJ0_IN_PU,
	PTQ0_IN_PU,
	PTR2_IN_PU,
	PTX6_IN_PU,
	PTY5_IN_PU, PTY4_IN_PU, PTY3_IN_PU, PTY2_IN_PU, PTY0_IN_PU,
	PTZ5_IN_PU, PTZ4_IN_PU, PTZ3_IN_PU, PTZ2_IN_PU, PTZ1_IN_PU,
	PINMUX_INPUT_PULLUP_END,

	PINMUX_OUTPUT_BEGIN,
	PTA7_OUT, PTA5_OUT,
	PTB7_OUT, PTB6_OUT, PTB5_OUT, PTB4_OUT,
	PTB3_OUT, PTB2_OUT, PTB1_OUT, PTB0_OUT,
	PTC4_OUT, PTC3_OUT, PTC2_OUT, PTC0_OUT,
	PTD6_OUT, PTD5_OUT, PTD4_OUT,
	PTD3_OUT, PTD2_OUT, PTD1_OUT, PTD0_OUT,
	PTE7_OUT, PTE6_OUT, PTE5_OUT, PTE4_OUT, PTE1_OUT, PTE0_OUT,
	PTF6_OUT, PTF5_OUT, PTF4_OUT, PTF3_OUT, PTF2_OUT, PTF0_OUT,
	PTG4_OUT, PTG3_OUT, PTG2_OUT, PTG1_OUT, PTG0_OUT,
	PTH7_OUT, PTH6_OUT, PTH5_OUT, PTH4_OUT,
	PTH3_OUT, PTH2_OUT, PTH1_OUT, PTH0_OUT,
	PTJ7_OUT, PTJ6_OUT, PTJ5_OUT, PTJ1_OUT, PTJ0_OUT,
	PTK6_OUT, PTK5_OUT, PTK4_OUT, PTK3_OUT, PTK1_OUT, PTK0_OUT,
	PTL7_OUT, PTL6_OUT, PTL5_OUT, PTL4_OUT,
	PTL3_OUT, PTL2_OUT, PTL1_OUT, PTL0_OUT,
	PTM7_OUT, PTM6_OUT, PTM5_OUT, PTM4_OUT,
	PTM3_OUT, PTM2_OUT, PTM1_OUT, PTM0_OUT,
	PTN7_OUT, PTN6_OUT, PTN5_OUT, PTN4_OUT,
	PTN3_OUT, PTN2_OUT, PTN1_OUT, PTN0_OUT,	PTQ6_OUT, PTQ5_OUT, PTQ4_OUT,
	PTQ3_OUT, PTQ2_OUT, PTQ1_OUT, PTQ0_OUT,
	PTR4_OUT, PTR3_OUT, PTR1_OUT, PTR0_OUT,
	PTS3_OUT, PTS2_OUT, PTS0_OUT,
	PTT4_OUT, PTT3_OUT, PTT2_OUT, PTT0_OUT,
	PTU4_OUT, PTU3_OUT, PTU2_OUT, PTU0_OUT,
	PTV4_OUT, PTV3_OUT, PTV2_OUT, PTV1_OUT, PTV0_OUT,
	PTW5_OUT, PTW4_OUT, PTW3_OUT, PTW2_OUT, PTW1_OUT, PTW0_OUT,
	PTX6_OUT, PTX5_OUT, PTX4_OUT, PTX3_OUT, PTX2_OUT, PTX1_OUT, PTX0_OUT,
	PTY5_OUT, PTY4_OUT, PTY3_OUT, PTY2_OUT, PTY1_OUT, PTY0_OUT,
	PINMUX_OUTPUT_END,

	PINMUX_MARK_BEGIN,
	SCIF0_TXD_MARK, SCIF0_RXD_MARK,
	SCIF0_RTS_MARK, SCIF0_CTS_MARK, SCIF0_SCK_MARK,
	SCIF1_TXD_MARK, SCIF1_RXD_MARK,
	SCIF1_RTS_MARK, SCIF1_CTS_MARK, SCIF1_SCK_MARK,
	SCIF2_TXD_MARK, SCIF2_RXD_MARK,
	SCIF2_RTS_MARK, SCIF2_CTS_MARK, SCIF2_SCK_MARK,
	SIOTXD_MARK, SIORXD_MARK,
	SIOD_MARK, SIOSTRB0_MARK, SIOSTRB1_MARK,
	SIOSCK_MARK, SIOMCK_MARK,
	VIO_D15_MARK, VIO_D14_MARK, VIO_D13_MARK, VIO_D12_MARK,
	VIO_D11_MARK, VIO_D10_MARK, VIO_D9_MARK, VIO_D8_MARK,
	VIO_D7_MARK, VIO_D6_MARK, VIO_D5_MARK, VIO_D4_MARK,
	VIO_D3_MARK, VIO_D2_MARK, VIO_D1_MARK, VIO_D0_MARK,
	VIO_CLK_MARK, VIO_VD_MARK, VIO_HD_MARK, VIO_FLD_MARK,
	VIO_CKO_MARK, VIO_STEX_MARK, VIO_STEM_MARK, VIO_VD2_MARK,
	VIO_HD2_MARK, VIO_CLK2_MARK,
	LCDD23_MARK, LCDD22_MARK, LCDD21_MARK, LCDD20_MARK,
	LCDD19_MARK, LCDD18_MARK, LCDD17_MARK, LCDD16_MARK,
	LCDD15_MARK, LCDD14_MARK, LCDD13_MARK, LCDD12_MARK,
	LCDD11_MARK, LCDD10_MARK, LCDD9_MARK, LCDD8_MARK,
	LCDD7_MARK, LCDD6_MARK, LCDD5_MARK, LCDD4_MARK,
	LCDD3_MARK, LCDD2_MARK, LCDD1_MARK, LCDD0_MARK,
	LCDLCLK_MARK, LCDDON_MARK, LCDVCPWC_MARK, LCDVEPWC_MARK,
	LCDVSYN_MARK, LCDDCK_MARK, LCDHSYN_MARK, LCDDISP_MARK,
	LCDRS_MARK, LCDCS_MARK, LCDWR_MARK, LCDRD_MARK,
	LCDDON2_MARK, LCDVCPWC2_MARK, LCDVEPWC2_MARK, LCDVSYN2_MARK,
	LCDCS2_MARK,
	IOIS16_MARK, A25_MARK, A24_MARK, A23_MARK, A22_MARK,
	BS_MARK, CS6B_CE1B_MARK, WAIT_MARK, CS6A_CE2B_MARK,
	HPD63_MARK, HPD62_MARK, HPD61_MARK, HPD60_MARK,
	HPD59_MARK, HPD58_MARK, HPD57_MARK, HPD56_MARK,
	HPD55_MARK, HPD54_MARK, HPD53_MARK, HPD52_MARK,
	HPD51_MARK, HPD50_MARK, HPD49_MARK, HPD48_MARK,
	HPDQM7_MARK, HPDQM6_MARK, HPDQM5_MARK, HPDQM4_MARK,
	IRQ0_MARK, IRQ1_MARK, IRQ2_MARK, IRQ3_MARK,
	IRQ4_MARK, IRQ5_MARK, IRQ6_MARK, IRQ7_MARK,
	SDHICD_MARK, SDHIWP_MARK, SDHID3_MARK, SDHID2_MARK,
	SDHID1_MARK, SDHID0_MARK, SDHICMD_MARK, SDHICLK_MARK,
	SIUAOLR_MARK, SIUAOBT_MARK, SIUAISLD_MARK, SIUAILR_MARK,
	SIUAIBT_MARK, SIUAOSLD_MARK, SIUMCKA_MARK, SIUFCKA_MARK,
	SIUBOLR_MARK, SIUBOBT_MARK, SIUBISLD_MARK, SIUBILR_MARK,
	SIUBIBT_MARK, SIUBOSLD_MARK, SIUMCKB_MARK, SIUFCKB_MARK,
	AUDSYNC_MARK, AUDATA3_MARK, AUDATA2_MARK, AUDATA1_MARK,	AUDATA0_MARK,
	DACK_MARK, DREQ0_MARK,
	DV_CLKI_MARK, DV_CLK_MARK, DV_HSYNC_MARK, DV_VSYNC_MARK,
	DV_D15_MARK, DV_D14_MARK, DV_D13_MARK, DV_D12_MARK,
	DV_D11_MARK, DV_D10_MARK, DV_D9_MARK, DV_D8_MARK,
	DV_D7_MARK, DV_D6_MARK, DV_D5_MARK, DV_D4_MARK,
	DV_D3_MARK, DV_D2_MARK, DV_D1_MARK, DV_D0_MARK,
	STATUS0_MARK, PDSTATUS_MARK,
	SIOF0_MCK_MARK, SIOF0_SCK_MARK,
	SIOF0_SYNC_MARK, SIOF0_SS1_MARK, SIOF0_SS2_MARK,
	SIOF0_TXD_MARK,	SIOF0_RXD_MARK,
	SIOF1_MCK_MARK, SIOF1_SCK_MARK,
	SIOF1_SYNC_MARK, SIOF1_SS1_MARK, SIOF1_SS2_MARK,
	SIOF1_TXD_MARK, SIOF1_RXD_MARK,
	SIM_D_MARK, SIM_CLK_MARK, SIM_RST_MARK,
	TS_SDAT_MARK, TS_SCK_MARK, TS_SDEN_MARK, TS_SPSYNC_MARK,
	IRDA_IN_MARK, IRDA_OUT_MARK,
	TPUTO_MARK,
	FCE_MARK, NAF7_MARK, NAF6_MARK, NAF5_MARK, NAF4_MARK,
	NAF3_MARK, NAF2_MARK, NAF1_MARK, NAF0_MARK, FCDE_MARK,
	FOE_MARK, FSC_MARK, FWE_MARK, FRB_MARK,
	KEYIN0_MARK, KEYIN1_MARK, KEYIN2_MARK, KEYIN3_MARK, KEYIN4_MARK,
	KEYOUT0_MARK, KEYOUT1_MARK, KEYOUT2_MARK, KEYOUT3_MARK,
	KEYOUT4_IN6_MARK, KEYOUT5_IN5_MARK,
	PINMUX_MARK_END,

	PINMUX_FUNCTION_BEGIN,
	VIO_D7_SCIF1_SCK, VIO_D6_SCIF1_RXD, VIO_D5_SCIF1_TXD, VIO_D4,
	VIO_D3, VIO_D2, VIO_D1, VIO_D0_LCDLCLK,
	HPD55, HPD54, HPD53, HPD52, HPD51, HPD50, HPD49, HPD48,
	IOIS16, HPDQM7, HPDQM6, HPDQM5, HPDQM4,
	SDHICD, SDHIWP, SDHID3, IRQ2_SDHID2, SDHID1, SDHID0, SDHICMD, SDHICLK,
	A25, A24, A23, A22, IRQ5, IRQ4_BS,
	PTF6, SIOSCK_SIUBOBT, SIOSTRB1_SIUBOLR,
	SIOSTRB0_SIUBIBT, SIOD_SIUBILR, SIORXD_SIUBISLD, SIOTXD_SIUBOSLD,
	AUDSYNC, AUDATA3, AUDATA2, AUDATA1, AUDATA0,
	LCDVCPWC_LCDVCPWC2, LCDVSYN2_DACK, LCDVSYN, LCDDISP_LCDRS,
	LCDHSYN_LCDCS, LCDDON_LCDDON2, LCDD17_DV_HSYNC, LCDD16_DV_VSYNC,
	STATUS0, PDSTATUS, IRQ1, IRQ0,
	SIUAILR_SIOF1_SS2, SIUAIBT_SIOF1_SS1, SIUAOLR_SIOF1_SYNC,
	SIUAOBT_SIOF1_SCK, SIUAISLD_SIOF1_RXD, SIUAOSLD_SIOF1_TXD, PTK0,
	LCDD15_DV_D15, LCDD14_DV_D14, LCDD13_DV_D13, LCDD12_DV_D12,
	LCDD11_DV_D11, LCDD10_DV_D10, LCDD9_DV_D9, LCDD8_DV_D8,
	LCDD7_DV_D7, LCDD6_DV_D6, LCDD5_DV_D5, LCDD4_DV_D4,
	LCDD3_DV_D3, LCDD2_DV_D2, LCDD1_DV_D1, LCDD0_DV_D0,
	HPD63, HPD62, HPD61, HPD60, HPD59, HPD58, HPD57, HPD56,
	SIOF0_SS2_SIM_RST, SIOF0_SS1_TS_SPSYNC, SIOF0_SYNC_TS_SDEN,
	SIOF0_SCK_TS_SCK, PTQ2, PTQ1, PTQ0,
	LCDRD, CS6B_CE1B_LCDCS2, WAIT, LCDDCK_LCDWR, LCDVEPWC_LCDVEPWC2,
	SCIF0_CTS_SIUAISPD, SCIF0_RTS_SIUAOSPD,
	SCIF0_SCK_TPUTO, SCIF0_RXD, SCIF0_TXD,
	FOE_VIO_VD2, FWE, FSC, DREQ0, FCDE,
	NAF2_VIO_D10, NAF1_VIO_D9, NAF0_VIO_D8,
	FRB_VIO_CLK2, FCE_VIO_HD2,
	NAF7_VIO_D15, NAF6_VIO_D14, NAF5_VIO_D13, NAF4_VIO_D12, NAF3_VIO_D11,
	VIO_FLD_SCIF2_CTS, VIO_CKO_SCIF2_RTS, VIO_STEX_SCIF2_SCK,
	VIO_STEM_SCIF2_TXD, VIO_HD_SCIF2_RXD,
	VIO_VD_SCIF1_CTS, VIO_CLK_SCIF1_RTS,
	CS6A_CE2B, LCDD23, LCDD22, LCDD21, LCDD20,
	LCDD19_DV_CLKI, LCDD18_DV_CLK,
	KEYOUT5_IN5, KEYOUT4_IN6, KEYOUT3, KEYOUT2, KEYOUT1, KEYOUT0,
	KEYIN4_IRQ7, KEYIN3, KEYIN2, KEYIN1, KEYIN0_IRQ6,

	PSA15_KEYIN0, PSA15_IRQ6, PSA14_KEYIN4, PSA14_IRQ7,
	PSA9_IRQ4, PSA9_BS, PSA4_IRQ2, PSA4_SDHID2,
	PSB15_SIOTXD, PSB15_SIUBOSLD, PSB14_SIORXD, PSB14_SIUBISLD,
	PSB13_SIOD, PSB13_SIUBILR, PSB12_SIOSTRB0, PSB12_SIUBIBT,
	PSB11_SIOSTRB1, PSB11_SIUBOLR, PSB10_SIOSCK, PSB10_SIUBOBT,
	PSB9_SIOMCK, PSB9_SIUMCKB, PSB8_SIOF0_MCK, PSB8_IRQ3,
	PSB7_SIOF0_TXD, PSB7_IRDA_OUT, PSB6_SIOF0_RXD, PSB6_IRDA_IN,
	PSB5_SIOF0_SCK, PSB5_TS_SCK, PSB4_SIOF0_SYNC, PSB4_TS_SDEN,
	PSB3_SIOF0_SS1, PSB3_TS_SPSYNC, PSB2_SIOF0_SS2, PSB2_SIM_RST,
	PSB1_SIUMCKA, PSB1_SIOF1_MCK, PSB0_SIUAOSLD, PSB0_SIOF1_TXD,
	PSC15_SIUAISLD, PSC15_SIOF1_RXD, PSC14_SIUAOBT, PSC14_SIOF1_SCK,
	PSC13_SIUAOLR, PSC13_SIOF1_SYNC, PSC12_SIUAIBT, PSC12_SIOF1_SS1,
	PSC11_SIUAILR, PSC11_SIOF1_SS2, PSC0_NAF, PSC0_VIO,
	PSD13_VIO, PSD13_SCIF2, PSD12_VIO, PSD12_SCIF1,
	PSD11_VIO, PSD11_SCIF1, PSD10_VIO_D0, PSD10_LCDLCLK,
	PSD9_SIOMCK_SIUMCKB, PSD9_SIUFCKB, PSD8_SCIF0_SCK, PSD8_TPUTO,
	PSD7_SCIF0_RTS, PSD7_SIUAOSPD, PSD6_SCIF0_CTS, PSD6_SIUAISPD,
	PSD5_CS6B_CE1B, PSD5_LCDCS2,
	PSD3_LCDVEPWC_LCDVCPWC, PSD3_LCDVEPWC2_LCDVCPWC2,
	PSD2_LCDDON, PSD2_LCDDON2, PSD0_LCDD19_LCDD0, PSD0_DV,
	PSE15_SIOF0_MCK_IRQ3, PSE15_SIM_D,
	PSE14_SIOF0_TXD_IRDA_OUT, PSE14_SIM_CLK,
	PSE13_SIOF0_RXD_IRDA_IN, PSE13_TS_SDAT, PSE12_LCDVSYN2, PSE12_DACK,
	PSE11_SIUMCKA_SIOF1_MCK, PSE11_SIUFCKA,
	PSE3_FLCTL, PSE3_VIO, PSE2_NAF2, PSE2_VIO_D10,
	PSE1_NAF1, PSE1_VIO_D9, PSE0_NAF0, PSE0_VIO_D8,

	HIZA14_KEYSC, HIZA14_HIZ,
	HIZA10_NAF, HIZA10_HIZ,
	HIZA9_VIO, HIZA9_HIZ,
	HIZA8_LCDC, HIZA8_HIZ,
	HIZA7_LCDC, HIZA7_HIZ,
	HIZA6_LCDC, HIZA6_HIZ,
	HIZB1_VIO, HIZB1_HIZ,
	HIZB0_VIO, HIZB0_HIZ,
	HIZC15_IRQ7, HIZC15_HIZ,
	HIZC14_IRQ6, HIZC14_HIZ,
	HIZC13_IRQ5, HIZC13_HIZ,
	HIZC12_IRQ4, HIZC12_HIZ,
	HIZC11_IRQ3, HIZC11_HIZ,
	HIZC10_IRQ2, HIZC10_HIZ,
	HIZC9_IRQ1, HIZC9_HIZ,
	HIZC8_IRQ0, HIZC8_HIZ,
	MSELB9_VIO, MSELB9_VIO2,
	MSELB8_RGB, MSELB8_SYS,
	PINMUX_FUNCTION_END,
};

static pinmux_enum_t pinmux_data[] = {
	/* PTA */
	PINMUX_DATA(PTA7_DATA, PTA7_IN, PTA7_IN_PD, PTA7_OUT),
	PINMUX_DATA(PTA6_DATA, PTA6_IN, PTA6_IN_PD),
	PINMUX_DATA(PTA5_DATA, PTA5_IN, PTA5_IN_PD, PTA5_OUT),
	PINMUX_DATA(PTA4_DATA, PTA4_IN, PTA4_IN_PD),
	PINMUX_DATA(PTA3_DATA, PTA3_IN, PTA3_IN_PD),
	PINMUX_DATA(PTA2_DATA, PTA2_IN, PTA2_IN_PD),
	PINMUX_DATA(PTA1_DATA, PTA1_IN, PTA1_IN_PD),
	PINMUX_DATA(PTA0_DATA, PTA0_IN, PTA0_IN_PD),

	/* PTB */
	PINMUX_DATA(PTB7_DATA, PTB7_IN, PTB7_OUT),
	PINMUX_DATA(PTB6_DATA, PTB6_IN, PTB6_OUT),
	PINMUX_DATA(PTB5_DATA, PTB5_IN, PTB5_OUT),
	PINMUX_DATA(PTB4_DATA, PTB4_IN, PTB4_OUT),
	PINMUX_DATA(PTB3_DATA, PTB3_IN, PTB3_OUT),
	PINMUX_DATA(PTB2_DATA, PTB2_IN, PTB2_OUT),
	PINMUX_DATA(PTB1_DATA, PTB1_IN, PTB1_OUT),
	PINMUX_DATA(PTB0_DATA, PTB0_IN, PTB0_OUT),

	/* PTC */
	PINMUX_DATA(PTC7_DATA, PTC7_IN, PTC7_IN_PU),
	PINMUX_DATA(PTC5_DATA, PTC5_IN, PTC5_IN_PU),
	PINMUX_DATA(PTC4_DATA, PTC4_IN, PTC4_OUT),
	PINMUX_DATA(PTC3_DATA, PTC3_IN, PTC3_OUT),
	PINMUX_DATA(PTC2_DATA, PTC2_IN, PTC2_OUT),
	PINMUX_DATA(PTC0_DATA, PTC0_IN, PTC0_OUT),

	/* PTD */
	PINMUX_DATA(PTD7_DATA, PTD7_IN, PTD7_IN_PU),
	PINMUX_DATA(PTD6_DATA, PTD6_OUT, PTD6_IN, PTD6_IN_PU),
	PINMUX_DATA(PTD5_DATA, PTD5_OUT, PTD5_IN, PTD5_IN_PU),
	PINMUX_DATA(PTD4_DATA, PTD4_OUT, PTD4_IN, PTD4_IN_PU),
	PINMUX_DATA(PTD3_DATA, PTD3_OUT, PTD3_IN, PTD3_IN_PU),
	PINMUX_DATA(PTD2_DATA, PTD2_OUT, PTD2_IN, PTD2_IN_PU),
	PINMUX_DATA(PTD1_DATA, PTD1_OUT, PTD1_IN, PTD1_IN_PU),
	PINMUX_DATA(PTD0_DATA, PTD0_OUT),

	/* PTE */
	PINMUX_DATA(PTE7_DATA, PTE7_OUT, PTE7_IN, PTE7_IN_PD),
	PINMUX_DATA(PTE6_DATA, PTE6_OUT, PTE6_IN, PTE6_IN_PD),
	PINMUX_DATA(PTE5_DATA, PTE5_OUT, PTE5_IN, PTE5_IN_PD),
	PINMUX_DATA(PTE4_DATA, PTE4_OUT, PTE4_IN, PTE4_IN_PD),
	PINMUX_DATA(PTE1_DATA, PTE1_OUT, PTE1_IN, PTE1_IN_PD),
	PINMUX_DATA(PTE0_DATA, PTE0_OUT, PTE0_IN, PTE0_IN_PD),

	/* PTF */
	PINMUX_DATA(PTF6_DATA, PTF6_OUT, PTF6_IN, PTF6_IN_PD),
	PINMUX_DATA(PTF5_DATA, PTF5_OUT, PTF5_IN, PTF5_IN_PD),
	PINMUX_DATA(PTF4_DATA, PTF4_OUT, PTF4_IN, PTF4_IN_PD),
	PINMUX_DATA(PTF3_DATA, PTF3_OUT, PTF3_IN, PTF3_IN_PD),
	PINMUX_DATA(PTF2_DATA, PTF2_OUT, PTF2_IN, PTF2_IN_PD),
	PINMUX_DATA(PTF1_DATA, PTF1_IN, PTF1_IN_PD),
	PINMUX_DATA(PTF0_DATA, PTF0_OUT),

	/* PTG */
	PINMUX_DATA(PTG4_DATA, PTG4_OUT),
	PINMUX_DATA(PTG3_DATA, PTG3_OUT),
	PINMUX_DATA(PTG2_DATA, PTG2_OUT),
	PINMUX_DATA(PTG1_DATA, PTG1_OUT),
	PINMUX_DATA(PTG0_DATA, PTG0_OUT),

	/* PTH */
	PINMUX_DATA(PTH7_DATA, PTH7_OUT),
	PINMUX_DATA(PTH6_DATA, PTH6_OUT, PTH6_IN, PTH6_IN_PD),
	PINMUX_DATA(PTH5_DATA, PTH5_OUT, PTH5_IN, PTH5_IN_PD),
	PINMUX_DATA(PTH4_DATA, PTH4_OUT),
	PINMUX_DATA(PTH3_DATA, PTH3_OUT),
	PINMUX_DATA(PTH2_DATA, PTH2_OUT),
	PINMUX_DATA(PTH1_DATA, PTH1_OUT, PTH1_IN, PTH1_IN_PD),
	PINMUX_DATA(PTH0_DATA, PTH0_OUT, PTH0_IN, PTH0_IN_PD),

	/* PTJ */
	PINMUX_DATA(PTJ7_DATA, PTJ7_OUT),
	PINMUX_DATA(PTJ6_DATA, PTJ6_OUT),
	PINMUX_DATA(PTJ5_DATA, PTJ5_OUT),
	PINMUX_DATA(PTJ1_DATA, PTJ1_OUT, PTJ1_IN, PTJ1_IN_PU),
	PINMUX_DATA(PTJ0_DATA, PTJ0_OUT, PTJ0_IN, PTJ0_IN_PU),

	/* PTK */
	PINMUX_DATA(PTK6_DATA, PTK6_OUT, PTK6_IN, PTK6_IN_PD),
	PINMUX_DATA(PTK5_DATA, PTK5_OUT, PTK5_IN, PTK5_IN_PD),
	PINMUX_DATA(PTK4_DATA, PTK4_OUT, PTK4_IN, PTK4_IN_PD),
	PINMUX_DATA(PTK3_DATA, PTK3_OUT, PTK3_IN, PTK3_IN_PD),
	PINMUX_DATA(PTK2_DATA, PTK2_IN, PTK2_IN_PD),
	PINMUX_DATA(PTK1_DATA, PTK1_OUT),
	PINMUX_DATA(PTK0_DATA, PTK0_OUT, PTK0_IN, PTK0_IN_PD),

	/* PTL */
	PINMUX_DATA(PTL7_DATA, PTL7_OUT, PTL7_IN, PTL7_IN_PD),
	PINMUX_DATA(PTL6_DATA, PTL6_OUT, PTL6_IN, PTL6_IN_PD),
	PINMUX_DATA(PTL5_DATA, PTL5_OUT, PTL5_IN, PTL5_IN_PD),
	PINMUX_DATA(PTL4_DATA, PTL4_OUT, PTL4_IN, PTL4_IN_PD),
	PINMUX_DATA(PTL3_DATA, PTL3_OUT, PTL3_IN, PTL3_IN_PD),
	PINMUX_DATA(PTL2_DATA, PTL2_OUT, PTL2_IN, PTL2_IN_PD),
	PINMUX_DATA(PTL1_DATA, PTL1_OUT, PTL1_IN, PTL1_IN_PD),
	PINMUX_DATA(PTL0_DATA, PTL0_OUT, PTL0_IN, PTL0_IN_PD),

	/* PTM */
	PINMUX_DATA(PTM7_DATA, PTM7_OUT, PTM7_IN, PTM7_IN_PD),
	PINMUX_DATA(PTM6_DATA, PTM6_OUT, PTM6_IN, PTM6_IN_PD),
	PINMUX_DATA(PTM5_DATA, PTM5_OUT, PTM5_IN, PTM5_IN_PD),
	PINMUX_DATA(PTM4_DATA, PTM4_OUT, PTM4_IN, PTM4_IN_PD),
	PINMUX_DATA(PTM3_DATA, PTM3_OUT, PTM3_IN, PTM3_IN_PD),
	PINMUX_DATA(PTM2_DATA, PTM2_OUT, PTM2_IN, PTM2_IN_PD),
	PINMUX_DATA(PTM1_DATA, PTM1_OUT, PTM1_IN, PTM1_IN_PD),
	PINMUX_DATA(PTM0_DATA, PTM0_OUT, PTM0_IN, PTM0_IN_PD),

	/* PTN */
	PINMUX_DATA(PTN7_DATA, PTN7_OUT, PTN7_IN),
	PINMUX_DATA(PTN6_DATA, PTN6_OUT, PTN6_IN),
	PINMUX_DATA(PTN5_DATA, PTN5_OUT, PTN5_IN),
	PINMUX_DATA(PTN4_DATA, PTN4_OUT, PTN4_IN),
	PINMUX_DATA(PTN3_DATA, PTN3_OUT, PTN3_IN),
	PINMUX_DATA(PTN2_DATA, PTN2_OUT, PTN2_IN),
	PINMUX_DATA(PTN1_DATA, PTN1_OUT, PTN1_IN),
	PINMUX_DATA(PTN0_DATA, PTN0_OUT, PTN0_IN),

	/* PTQ */
	PINMUX_DATA(PTQ6_DATA, PTQ6_OUT),
	PINMUX_DATA(PTQ5_DATA, PTQ5_OUT, PTQ5_IN, PTQ5_IN_PD),
	PINMUX_DATA(PTQ4_DATA, PTQ4_OUT, PTQ4_IN, PTQ4_IN_PD),
	PINMUX_DATA(PTQ3_DATA, PTQ3_OUT, PTQ3_IN, PTQ3_IN_PD),
	PINMUX_DATA(PTQ2_DATA, PTQ2_IN, PTQ2_IN_PD),
	PINMUX_DATA(PTQ1_DATA, PTQ1_OUT),
	PINMUX_DATA(PTQ0_DATA, PTQ0_OUT, PTQ0_IN, PTQ0_IN_PU),

	/* PTR */
	PINMUX_DATA(PTR4_DATA, PTR4_OUT),
	PINMUX_DATA(PTR3_DATA, PTR3_OUT),
	PINMUX_DATA(PTR2_DATA, PTR2_IN, PTR2_IN_PU),
	PINMUX_DATA(PTR1_DATA, PTR1_OUT),
	PINMUX_DATA(PTR0_DATA, PTR0_OUT),

	/* PTS */
	PINMUX_DATA(PTS4_DATA, PTS4_IN, PTS4_IN_PD),
	PINMUX_DATA(PTS3_DATA, PTS3_OUT),
	PINMUX_DATA(PTS2_DATA, PTS2_OUT, PTS2_IN, PTS2_IN_PD),
	PINMUX_DATA(PTS1_DATA, PTS1_IN, PTS1_IN_PD),
	PINMUX_DATA(PTS0_DATA, PTS0_OUT),

	/* PTT */
	PINMUX_DATA(PTT4_DATA, PTT4_OUT, PTT4_IN, PTT4_IN_PD),
	PINMUX_DATA(PTT3_DATA, PTT3_OUT, PTT3_IN, PTT3_IN_PD),
	PINMUX_DATA(PTT2_DATA, PTT2_OUT, PTT2_IN, PTT2_IN_PD),
	PINMUX_DATA(PTT1_DATA, PTT1_IN, PTT1_IN_PD),
	PINMUX_DATA(PTT0_DATA, PTT0_OUT),

	/* PTU */
	PINMUX_DATA(PTU4_DATA, PTU4_OUT, PTU4_IN, PTU4_IN_PD),
	PINMUX_DATA(PTU3_DATA, PTU3_OUT, PTU3_IN, PTU3_IN_PD),
	PINMUX_DATA(PTU2_DATA, PTU2_OUT, PTU2_IN, PTU2_IN_PD),
	PINMUX_DATA(PTU1_DATA, PTU1_IN, PTU1_IN_PD),
	PINMUX_DATA(PTU0_DATA, PTU0_OUT, PTU0_IN, PTU0_IN_PD),

	/* PTV */
	PINMUX_DATA(PTV4_DATA, PTV4_OUT, PTV4_IN, PTV4_IN_PD),
	PINMUX_DATA(PTV3_DATA, PTV3_OUT, PTV3_IN, PTV3_IN_PD),
	PINMUX_DATA(PTV2_DATA, PTV2_OUT, PTV2_IN, PTV2_IN_PD),
	PINMUX_DATA(PTV1_DATA, PTV1_OUT, PTV1_IN, PTV1_IN_PD),
	PINMUX_DATA(PTV0_DATA, PTV0_OUT, PTV0_IN, PTV0_IN_PD),

	/* PTW */
	PINMUX_DATA(PTW6_DATA, PTW6_IN, PTW6_IN_PD),
	PINMUX_DATA(PTW5_DATA, PTW5_OUT),
	PINMUX_DATA(PTW4_DATA, PTW4_OUT, PTW4_IN, PTW4_IN_PD),
	PINMUX_DATA(PTW3_DATA, PTW3_OUT, PTW3_IN, PTW3_IN_PD),
	PINMUX_DATA(PTW2_DATA, PTW2_OUT, PTW2_IN, PTW2_IN_PD),
	PINMUX_DATA(PTW1_DATA, PTW1_OUT, PTW1_IN, PTW1_IN_PD),
	PINMUX_DATA(PTW0_DATA, PTW0_OUT, PTW0_IN, PTW0_IN_PD),

	/* PTX */
	PINMUX_DATA(PTX6_DATA, PTX6_OUT, PTX6_IN, PTX6_IN_PD),
	PINMUX_DATA(PTX5_DATA, PTX5_OUT, PTX5_IN, PTX5_IN_PD),
	PINMUX_DATA(PTX4_DATA, PTX4_OUT, PTX4_IN, PTX4_IN_PD),
	PINMUX_DATA(PTX3_DATA, PTX3_OUT, PTX3_IN, PTX3_IN_PD),
	PINMUX_DATA(PTX2_DATA, PTX2_OUT, PTX2_IN, PTX2_IN_PD),
	PINMUX_DATA(PTX1_DATA, PTX1_OUT, PTX1_IN, PTX1_IN_PD),
	PINMUX_DATA(PTX0_DATA, PTX0_OUT, PTX0_IN, PTX0_IN_PD),

	/* PTY */
	PINMUX_DATA(PTY5_DATA, PTY5_OUT, PTY5_IN, PTY5_IN_PU),
	PINMUX_DATA(PTY4_DATA, PTY4_OUT, PTY4_IN, PTY4_IN_PU),
	PINMUX_DATA(PTY3_DATA, PTY3_OUT, PTY3_IN, PTY3_IN_PU),
	PINMUX_DATA(PTY2_DATA, PTY2_OUT, PTY2_IN, PTY2_IN_PU),
	PINMUX_DATA(PTY1_DATA, PTY1_OUT),
	PINMUX_DATA(PTY0_DATA, PTY0_OUT, PTY0_IN, PTY0_IN_PU),

	/* PTZ */
	PINMUX_DATA(PTZ5_DATA, PTZ5_IN, PTZ5_IN_PU),
	PINMUX_DATA(PTZ4_DATA, PTZ4_IN, PTZ4_IN_PU),
	PINMUX_DATA(PTZ3_DATA, PTZ3_IN, PTZ3_IN_PU),
	PINMUX_DATA(PTZ2_DATA, PTZ2_IN, PTZ2_IN_PU),
	PINMUX_DATA(PTZ1_DATA, PTZ1_IN, PTZ1_IN_PU),

	/* SCIF0 */
	PINMUX_DATA(SCIF0_TXD_MARK, SCIF0_TXD),
	PINMUX_DATA(SCIF0_RXD_MARK, SCIF0_RXD),
	PINMUX_DATA(SCIF0_RTS_MARK, PSD7_SCIF0_RTS, SCIF0_RTS_SIUAOSPD),
	PINMUX_DATA(SCIF0_CTS_MARK, PSD6_SCIF0_CTS, SCIF0_CTS_SIUAISPD),
	PINMUX_DATA(SCIF0_SCK_MARK, PSD8_SCIF0_SCK, SCIF0_SCK_TPUTO),

	/* SCIF1 */
	PINMUX_DATA(SCIF1_TXD_MARK, PSD11_SCIF1, VIO_D5_SCIF1_TXD),
	PINMUX_DATA(SCIF1_RXD_MARK, PSD11_SCIF1, VIO_D6_SCIF1_RXD),
	PINMUX_DATA(SCIF1_RTS_MARK, PSD12_SCIF1, VIO_CLK_SCIF1_RTS),
	PINMUX_DATA(SCIF1_CTS_MARK, PSD12_SCIF1, VIO_VD_SCIF1_CTS),
	PINMUX_DATA(SCIF1_SCK_MARK, PSD11_SCIF1, VIO_D7_SCIF1_SCK),

	/* SCIF2 */
	PINMUX_DATA(SCIF2_TXD_MARK, PSD13_SCIF2, VIO_STEM_SCIF2_TXD),
	PINMUX_DATA(SCIF2_RXD_MARK, PSD13_SCIF2, VIO_HD_SCIF2_RXD),
	PINMUX_DATA(SCIF2_RTS_MARK, PSD13_SCIF2, VIO_CKO_SCIF2_RTS),
	PINMUX_DATA(SCIF2_CTS_MARK, PSD13_SCIF2, VIO_FLD_SCIF2_CTS),
	PINMUX_DATA(SCIF2_SCK_MARK, PSD13_SCIF2, VIO_STEX_SCIF2_SCK),

	/* SIO */
	PINMUX_DATA(SIOTXD_MARK, PSB15_SIOTXD, SIOTXD_SIUBOSLD),
	PINMUX_DATA(SIORXD_MARK, PSB14_SIORXD, SIORXD_SIUBISLD),
	PINMUX_DATA(SIOD_MARK, PSB13_SIOD, SIOD_SIUBILR),
	PINMUX_DATA(SIOSTRB0_MARK, PSB12_SIOSTRB0, SIOSTRB0_SIUBIBT),
	PINMUX_DATA(SIOSTRB1_MARK, PSB11_SIOSTRB1, SIOSTRB1_SIUBOLR),
	PINMUX_DATA(SIOSCK_MARK, PSB10_SIOSCK, SIOSCK_SIUBOBT),
	PINMUX_DATA(SIOMCK_MARK, PSD9_SIOMCK_SIUMCKB, PSB9_SIOMCK, PTF6),

	/* CEU */
	PINMUX_DATA(VIO_D15_MARK, PSC0_VIO, HIZA10_NAF, NAF7_VIO_D15),
	PINMUX_DATA(VIO_D14_MARK, PSC0_VIO, HIZA10_NAF, NAF6_VIO_D14),
	PINMUX_DATA(VIO_D13_MARK, PSC0_VIO, HIZA10_NAF, NAF5_VIO_D13),
	PINMUX_DATA(VIO_D12_MARK, PSC0_VIO, HIZA10_NAF, NAF4_VIO_D12),
	PINMUX_DATA(VIO_D11_MARK, PSC0_VIO, HIZA10_NAF, NAF3_VIO_D11),
	PINMUX_DATA(VIO_D10_MARK, PSE2_VIO_D10, HIZB0_VIO, NAF2_VIO_D10),
	PINMUX_DATA(VIO_D9_MARK, PSE1_VIO_D9, HIZB0_VIO, NAF1_VIO_D9),
	PINMUX_DATA(VIO_D8_MARK, PSE0_VIO_D8, HIZB0_VIO, NAF0_VIO_D8),
	PINMUX_DATA(VIO_D7_MARK, PSD11_VIO, VIO_D7_SCIF1_SCK),
	PINMUX_DATA(VIO_D6_MARK, PSD11_VIO, VIO_D6_SCIF1_RXD),
	PINMUX_DATA(VIO_D5_MARK, PSD11_VIO, VIO_D5_SCIF1_TXD),
	PINMUX_DATA(VIO_D4_MARK, VIO_D4),
	PINMUX_DATA(VIO_D3_MARK, VIO_D3),
	PINMUX_DATA(VIO_D2_MARK, VIO_D2),
	PINMUX_DATA(VIO_D1_MARK, VIO_D1),
	PINMUX_DATA(VIO_D0_MARK, PSD10_VIO_D0, VIO_D0_LCDLCLK),
	PINMUX_DATA(VIO_CLK_MARK, PSD12_VIO, MSELB9_VIO, VIO_CLK_SCIF1_RTS),
	PINMUX_DATA(VIO_VD_MARK, PSD12_VIO, MSELB9_VIO, VIO_VD_SCIF1_CTS),
	PINMUX_DATA(VIO_HD_MARK, PSD13_VIO, MSELB9_VIO, VIO_HD_SCIF2_RXD),
	PINMUX_DATA(VIO_FLD_MARK, PSD13_VIO, HIZA9_VIO, VIO_FLD_SCIF2_CTS),
	PINMUX_DATA(VIO_CKO_MARK, PSD13_VIO, HIZA9_VIO, VIO_CKO_SCIF2_RTS),
	PINMUX_DATA(VIO_STEX_MARK, PSD13_VIO, HIZA9_VIO, VIO_STEX_SCIF2_SCK),
	PINMUX_DATA(VIO_STEM_MARK, PSD13_VIO, HIZA9_VIO, VIO_STEM_SCIF2_TXD),
	PINMUX_DATA(VIO_VD2_MARK, PSE3_VIO, MSELB9_VIO2,
		    HIZB0_VIO, FOE_VIO_VD2),
	PINMUX_DATA(VIO_HD2_MARK, PSE3_VIO, MSELB9_VIO2,
		    HIZB1_VIO, HIZB1_VIO, FCE_VIO_HD2),
	PINMUX_DATA(VIO_CLK2_MARK, PSE3_VIO, MSELB9_VIO2,
		    HIZB1_VIO, FRB_VIO_CLK2),

	/* LCDC */
	PINMUX_DATA(LCDD23_MARK, HIZA8_LCDC, LCDD23),
	PINMUX_DATA(LCDD22_MARK, HIZA8_LCDC, LCDD22),
	PINMUX_DATA(LCDD21_MARK, HIZA8_LCDC, LCDD21),
	PINMUX_DATA(LCDD20_MARK, HIZA8_LCDC, LCDD20),
	PINMUX_DATA(LCDD19_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD19_DV_CLKI),
	PINMUX_DATA(LCDD18_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD18_DV_CLK),
	PINMUX_DATA(LCDD17_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC,
		    LCDD17_DV_HSYNC),
	PINMUX_DATA(LCDD16_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC,
		    LCDD16_DV_VSYNC),
	PINMUX_DATA(LCDD15_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD15_DV_D15),
	PINMUX_DATA(LCDD14_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD14_DV_D14),
	PINMUX_DATA(LCDD13_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD13_DV_D13),
	PINMUX_DATA(LCDD12_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD12_DV_D12),
	PINMUX_DATA(LCDD11_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD11_DV_D11),
	PINMUX_DATA(LCDD10_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD10_DV_D10),
	PINMUX_DATA(LCDD9_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD9_DV_D9),
	PINMUX_DATA(LCDD8_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD8_DV_D8),
	PINMUX_DATA(LCDD7_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD7_DV_D7),
	PINMUX_DATA(LCDD6_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD6_DV_D6),
	PINMUX_DATA(LCDD5_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD5_DV_D5),
	PINMUX_DATA(LCDD4_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD4_DV_D4),
	PINMUX_DATA(LCDD3_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD3_DV_D3),
	PINMUX_DATA(LCDD2_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD2_DV_D2),
	PINMUX_DATA(LCDD1_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD1_DV_D1),
	PINMUX_DATA(LCDD0_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD0_DV_D0),
	PINMUX_DATA(LCDLCLK_MARK, PSD10_LCDLCLK, VIO_D0_LCDLCLK),
	/* Main LCD */
	PINMUX_DATA(LCDDON_MARK, PSD2_LCDDON, HIZA7_LCDC, LCDDON_LCDDON2),
	PINMUX_DATA(LCDVCPWC_MARK, PSD3_LCDVEPWC_LCDVCPWC,
		    HIZA6_LCDC, LCDVCPWC_LCDVCPWC2),
	PINMUX_DATA(LCDVEPWC_MARK, PSD3_LCDVEPWC_LCDVCPWC,
		    HIZA6_LCDC, LCDVEPWC_LCDVEPWC2),
	PINMUX_DATA(LCDVSYN_MARK, HIZA7_LCDC, LCDVSYN),
	/* Main LCD - RGB Mode */
	PINMUX_DATA(LCDDCK_MARK, MSELB8_RGB, HIZA8_LCDC, LCDDCK_LCDWR),
	PINMUX_DATA(LCDHSYN_MARK, MSELB8_RGB, HIZA7_LCDC, LCDHSYN_LCDCS),
	PINMUX_DATA(LCDDISP_MARK, MSELB8_RGB, HIZA7_LCDC, LCDDISP_LCDRS),
	/* Main LCD - SYS Mode */
	PINMUX_DATA(LCDRS_MARK, MSELB8_SYS, HIZA7_LCDC, LCDDISP_LCDRS),
	PINMUX_DATA(LCDCS_MARK, MSELB8_SYS, HIZA7_LCDC, LCDHSYN_LCDCS),
	PINMUX_DATA(LCDWR_MARK, MSELB8_SYS, HIZA8_LCDC, LCDDCK_LCDWR),
	PINMUX_DATA(LCDRD_MARK, HIZA7_LCDC, LCDRD),
	/* Sub LCD - SYS Mode */
	PINMUX_DATA(LCDDON2_MARK, PSD2_LCDDON2, HIZA7_LCDC, LCDDON_LCDDON2),
	PINMUX_DATA(LCDVCPWC2_MARK, PSD3_LCDVEPWC2_LCDVCPWC2,
		    HIZA6_LCDC, LCDVCPWC_LCDVCPWC2),
	PINMUX_DATA(LCDVEPWC2_MARK, PSD3_LCDVEPWC2_LCDVCPWC2,
		    HIZA6_LCDC, LCDVEPWC_LCDVEPWC2),
	PINMUX_DATA(LCDVSYN2_MARK, PSE12_LCDVSYN2, HIZA8_LCDC, LCDVSYN2_DACK),
	PINMUX_DATA(LCDCS2_MARK, PSD5_LCDCS2, CS6B_CE1B_LCDCS2),

	/* BSC */
	PINMUX_DATA(IOIS16_MARK, IOIS16),
	PINMUX_DATA(A25_MARK, A25),
	PINMUX_DATA(A24_MARK, A24),
	PINMUX_DATA(A23_MARK, A23),
	PINMUX_DATA(A22_MARK, A22),
	PINMUX_DATA(BS_MARK, PSA9_BS, IRQ4_BS),
	PINMUX_DATA(CS6B_CE1B_MARK, PSD5_CS6B_CE1B, CS6B_CE1B_LCDCS2),
	PINMUX_DATA(WAIT_MARK, WAIT),
	PINMUX_DATA(CS6A_CE2B_MARK, CS6A_CE2B),

	/* SBSC */
	PINMUX_DATA(HPD63_MARK, HPD63),
	PINMUX_DATA(HPD62_MARK, HPD62),
	PINMUX_DATA(HPD61_MARK, HPD61),
	PINMUX_DATA(HPD60_MARK, HPD60),
	PINMUX_DATA(HPD59_MARK, HPD59),
	PINMUX_DATA(HPD58_MARK, HPD58),
	PINMUX_DATA(HPD57_MARK, HPD57),
	PINMUX_DATA(HPD56_MARK, HPD56),
	PINMUX_DATA(HPD55_MARK, HPD55),
	PINMUX_DATA(HPD54_MARK, HPD54),
	PINMUX_DATA(HPD53_MARK, HPD53),
	PINMUX_DATA(HPD52_MARK, HPD52),
	PINMUX_DATA(HPD51_MARK, HPD51),
	PINMUX_DATA(HPD50_MARK, HPD50),
	PINMUX_DATA(HPD49_MARK, HPD49),
	PINMUX_DATA(HPD48_MARK, HPD48),
	PINMUX_DATA(HPDQM7_MARK, HPDQM7),
	PINMUX_DATA(HPDQM6_MARK, HPDQM6),
	PINMUX_DATA(HPDQM5_MARK, HPDQM5),
	PINMUX_DATA(HPDQM4_MARK, HPDQM4),

	/* IRQ */
	PINMUX_DATA(IRQ0_MARK, HIZC8_IRQ0, IRQ0),
	PINMUX_DATA(IRQ1_MARK, HIZC9_IRQ1, IRQ1),
	PINMUX_DATA(IRQ2_MARK, PSA4_IRQ2, HIZC10_IRQ2, IRQ2_SDHID2),
	PINMUX_DATA(IRQ3_MARK, PSE15_SIOF0_MCK_IRQ3, PSB8_IRQ3,
		    HIZC11_IRQ3, PTQ0),
	PINMUX_DATA(IRQ4_MARK, PSA9_IRQ4, HIZC12_IRQ4, IRQ4_BS),
	PINMUX_DATA(IRQ5_MARK, HIZC13_IRQ5, IRQ5),
	PINMUX_DATA(IRQ6_MARK, PSA15_IRQ6, HIZC14_IRQ6, KEYIN0_IRQ6),
	PINMUX_DATA(IRQ7_MARK, PSA14_IRQ7, HIZC15_IRQ7, KEYIN4_IRQ7),

	/* SDHI */
	PINMUX_DATA(SDHICD_MARK, SDHICD),
	PINMUX_DATA(SDHIWP_MARK, SDHIWP),
	PINMUX_DATA(SDHID3_MARK, SDHID3),
	PINMUX_DATA(SDHID2_MARK, PSA4_SDHID2, IRQ2_SDHID2),
	PINMUX_DATA(SDHID1_MARK, SDHID1),
	PINMUX_DATA(SDHID0_MARK, SDHID0),
	PINMUX_DATA(SDHICMD_MARK, SDHICMD),
	PINMUX_DATA(SDHICLK_MARK, SDHICLK),

	/* SIU - Port A */
	PINMUX_DATA(SIUAOLR_MARK, PSC13_SIUAOLR, SIUAOLR_SIOF1_SYNC),
	PINMUX_DATA(SIUAOBT_MARK, PSC14_SIUAOBT, SIUAOBT_SIOF1_SCK),
	PINMUX_DATA(SIUAISLD_MARK, PSC15_SIUAISLD, SIUAISLD_SIOF1_RXD),
	PINMUX_DATA(SIUAILR_MARK, PSC11_SIUAILR, SIUAILR_SIOF1_SS2),
	PINMUX_DATA(SIUAIBT_MARK, PSC12_SIUAIBT, SIUAIBT_SIOF1_SS1),
	PINMUX_DATA(SIUAOSLD_MARK, PSB0_SIUAOSLD, SIUAOSLD_SIOF1_TXD),
	PINMUX_DATA(SIUMCKA_MARK, PSE11_SIUMCKA_SIOF1_MCK, PSB1_SIUMCKA, PTK0),
	PINMUX_DATA(SIUFCKA_MARK, PSE11_SIUFCKA, PTK0),

	/* SIU - Port B */
	PINMUX_DATA(SIUBOLR_MARK, PSB11_SIUBOLR, SIOSTRB1_SIUBOLR),
	PINMUX_DATA(SIUBOBT_MARK, PSB10_SIUBOBT, SIOSCK_SIUBOBT),
	PINMUX_DATA(SIUBISLD_MARK, PSB14_SIUBISLD, SIORXD_SIUBISLD),
	PINMUX_DATA(SIUBILR_MARK, PSB13_SIUBILR, SIOD_SIUBILR),
	PINMUX_DATA(SIUBIBT_MARK, PSB12_SIUBIBT, SIOSTRB0_SIUBIBT),
	PINMUX_DATA(SIUBOSLD_MARK, PSB15_SIUBOSLD, SIOTXD_SIUBOSLD),
	PINMUX_DATA(SIUMCKB_MARK, PSD9_SIOMCK_SIUMCKB, PSB9_SIUMCKB, PTF6),
	PINMUX_DATA(SIUFCKB_MARK, PSD9_SIUFCKB, PTF6),

	/* AUD */
	PINMUX_DATA(AUDSYNC_MARK, AUDSYNC),
	PINMUX_DATA(AUDATA3_MARK, AUDATA3),
	PINMUX_DATA(AUDATA2_MARK, AUDATA2),
	PINMUX_DATA(AUDATA1_MARK, AUDATA1),
	PINMUX_DATA(AUDATA0_MARK, AUDATA0),

	/* DMAC */
	PINMUX_DATA(DACK_MARK, PSE12_DACK, LCDVSYN2_DACK),
	PINMUX_DATA(DREQ0_MARK, DREQ0),

	/* VOU */
	PINMUX_DATA(DV_CLKI_MARK, PSD0_DV, LCDD19_DV_CLKI),
	PINMUX_DATA(DV_CLK_MARK, PSD0_DV, LCDD18_DV_CLK),
	PINMUX_DATA(DV_HSYNC_MARK, PSD0_DV, LCDD17_DV_HSYNC),
	PINMUX_DATA(DV_VSYNC_MARK, PSD0_DV, LCDD16_DV_VSYNC),
	PINMUX_DATA(DV_D15_MARK, PSD0_DV, LCDD15_DV_D15),
	PINMUX_DATA(DV_D14_MARK, PSD0_DV, LCDD14_DV_D14),
	PINMUX_DATA(DV_D13_MARK, PSD0_DV, LCDD13_DV_D13),
	PINMUX_DATA(DV_D12_MARK, PSD0_DV, LCDD12_DV_D12),
	PINMUX_DATA(DV_D11_MARK, PSD0_DV, LCDD11_DV_D11),
	PINMUX_DATA(DV_D10_MARK, PSD0_DV, LCDD10_DV_D10),
	PINMUX_DATA(DV_D9_MARK, PSD0_DV, LCDD9_DV_D9),
	PINMUX_DATA(DV_D8_MARK, PSD0_DV, LCDD8_DV_D8),
	PINMUX_DATA(DV_D7_MARK, PSD0_DV, LCDD7_DV_D7),
	PINMUX_DATA(DV_D6_MARK, PSD0_DV, LCDD6_DV_D6),
	PINMUX_DATA(DV_D5_MARK, PSD0_DV, LCDD5_DV_D5),
	PINMUX_DATA(DV_D4_MARK, PSD0_DV, LCDD4_DV_D4),
	PINMUX_DATA(DV_D3_MARK, PSD0_DV, LCDD3_DV_D3),
	PINMUX_DATA(DV_D2_MARK, PSD0_DV, LCDD2_DV_D2),
	PINMUX_DATA(DV_D1_MARK, PSD0_DV, LCDD1_DV_D1),
	PINMUX_DATA(DV_D0_MARK, PSD0_DV, LCDD0_DV_D0),

	/* CPG */
	PINMUX_DATA(STATUS0_MARK, STATUS0),
	PINMUX_DATA(PDSTATUS_MARK, PDSTATUS),

	/* SIOF0 */
	PINMUX_DATA(SIOF0_MCK_MARK, PSE15_SIOF0_MCK_IRQ3, PSB8_SIOF0_MCK, PTQ0),
	PINMUX_DATA(SIOF0_SCK_MARK, PSB5_SIOF0_SCK, SIOF0_SCK_TS_SCK),
	PINMUX_DATA(SIOF0_SYNC_MARK, PSB4_SIOF0_SYNC, SIOF0_SYNC_TS_SDEN),
	PINMUX_DATA(SIOF0_SS1_MARK, PSB3_SIOF0_SS1, SIOF0_SS1_TS_SPSYNC),
	PINMUX_DATA(SIOF0_SS2_MARK, PSB2_SIOF0_SS2, SIOF0_SS2_SIM_RST),
	PINMUX_DATA(SIOF0_TXD_MARK, PSE14_SIOF0_TXD_IRDA_OUT,
		    PSB7_SIOF0_TXD, PTQ1),
	PINMUX_DATA(SIOF0_RXD_MARK, PSE13_SIOF0_RXD_IRDA_IN,
		    PSB6_SIOF0_RXD, PTQ2),

	/* SIOF1 */
	PINMUX_DATA(SIOF1_MCK_MARK, PSE11_SIUMCKA_SIOF1_MCK,
		    PSB1_SIOF1_MCK, PTK0),
	PINMUX_DATA(SIOF1_SCK_MARK, PSC14_SIOF1_SCK, SIUAOBT_SIOF1_SCK),
	PINMUX_DATA(SIOF1_SYNC_MARK, PSC13_SIOF1_SYNC, SIUAOLR_SIOF1_SYNC),
	PINMUX_DATA(SIOF1_SS1_MARK, PSC12_SIOF1_SS1, SIUAIBT_SIOF1_SS1),
	PINMUX_DATA(SIOF1_SS2_MARK, PSC11_SIOF1_SS2, SIUAILR_SIOF1_SS2),
	PINMUX_DATA(SIOF1_TXD_MARK, PSB0_SIOF1_TXD, SIUAOSLD_SIOF1_TXD),
	PINMUX_DATA(SIOF1_RXD_MARK, PSC15_SIOF1_RXD, SIUAISLD_SIOF1_RXD),

	/* SIM */
	PINMUX_DATA(SIM_D_MARK, PSE15_SIM_D, PTQ0),
	PINMUX_DATA(SIM_CLK_MARK, PSE14_SIM_CLK, PTQ1),
	PINMUX_DATA(SIM_RST_MARK, PSB2_SIM_RST, SIOF0_SS2_SIM_RST),

	/* TSIF */
	PINMUX_DATA(TS_SDAT_MARK, PSE13_TS_SDAT, PTQ2),
	PINMUX_DATA(TS_SCK_MARK, PSB5_TS_SCK, SIOF0_SCK_TS_SCK),
	PINMUX_DATA(TS_SDEN_MARK, PSB4_TS_SDEN, SIOF0_SYNC_TS_SDEN),
	PINMUX_DATA(TS_SPSYNC_MARK, PSB3_TS_SPSYNC, SIOF0_SS1_TS_SPSYNC),

	/* IRDA */
	PINMUX_DATA(IRDA_IN_MARK, PSE13_SIOF0_RXD_IRDA_IN, PSB6_IRDA_IN, PTQ2),
	PINMUX_DATA(IRDA_OUT_MARK, PSE14_SIOF0_TXD_IRDA_OUT,
		    PSB7_IRDA_OUT, PTQ1),

	/* TPU */
	PINMUX_DATA(TPUTO_MARK, PSD8_TPUTO, SCIF0_SCK_TPUTO),

	/* FLCTL */
	PINMUX_DATA(FCE_MARK, PSE3_FLCTL, FCE_VIO_HD2),
	PINMUX_DATA(NAF7_MARK, PSC0_NAF, HIZA10_NAF, NAF7_VIO_D15),
	PINMUX_DATA(NAF6_MARK, PSC0_NAF, HIZA10_NAF, NAF6_VIO_D14),
	PINMUX_DATA(NAF5_MARK, PSC0_NAF, HIZA10_NAF, NAF5_VIO_D13),
	PINMUX_DATA(NAF4_MARK, PSC0_NAF, HIZA10_NAF, NAF4_VIO_D12),
	PINMUX_DATA(NAF3_MARK, PSC0_NAF, HIZA10_NAF, NAF3_VIO_D11),
	PINMUX_DATA(NAF2_MARK, PSE2_NAF2, HIZB0_VIO, NAF2_VIO_D10),
	PINMUX_DATA(NAF1_MARK, PSE1_NAF1, HIZB0_VIO, NAF1_VIO_D9),
	PINMUX_DATA(NAF0_MARK, PSE0_NAF0, HIZB0_VIO, NAF0_VIO_D8),
	PINMUX_DATA(FCDE_MARK, FCDE),
	PINMUX_DATA(FOE_MARK, PSE3_FLCTL, HIZB0_VIO, FOE_VIO_VD2),
	PINMUX_DATA(FSC_MARK, FSC),
	PINMUX_DATA(FWE_MARK, FWE),
	PINMUX_DATA(FRB_MARK, PSE3_FLCTL, FRB_VIO_CLK2),

	/* KEYSC */
	PINMUX_DATA(KEYIN0_MARK, PSA15_KEYIN0, HIZC14_IRQ6, KEYIN0_IRQ6),
	PINMUX_DATA(KEYIN1_MARK, HIZA14_KEYSC, KEYIN1),
	PINMUX_DATA(KEYIN2_MARK, HIZA14_KEYSC, KEYIN2),
	PINMUX_DATA(KEYIN3_MARK, HIZA14_KEYSC, KEYIN3),
	PINMUX_DATA(KEYIN4_MARK, PSA14_KEYIN4, HIZC15_IRQ7, KEYIN4_IRQ7),
	PINMUX_DATA(KEYOUT0_MARK, HIZA14_KEYSC, KEYOUT0),
	PINMUX_DATA(KEYOUT1_MARK, HIZA14_KEYSC, KEYOUT1),
	PINMUX_DATA(KEYOUT2_MARK, HIZA14_KEYSC, KEYOUT2),
	PINMUX_DATA(KEYOUT3_MARK, HIZA14_KEYSC, KEYOUT3),
	PINMUX_DATA(KEYOUT4_IN6_MARK, HIZA14_KEYSC, KEYOUT4_IN6),
	PINMUX_DATA(KEYOUT5_IN5_MARK, HIZA14_KEYSC, KEYOUT5_IN5),
};

static struct pinmux_gpio pinmux_gpios[] = {
	/* PTA */
	PINMUX_GPIO(GPIO_PTA7, PTA7_DATA),
	PINMUX_GPIO(GPIO_PTA6, PTA6_DATA),
	PINMUX_GPIO(GPIO_PTA5, PTA5_DATA),
	PINMUX_GPIO(GPIO_PTA4, PTA4_DATA),
	PINMUX_GPIO(GPIO_PTA3, PTA3_DATA),
	PINMUX_GPIO(GPIO_PTA2, PTA2_DATA),
	PINMUX_GPIO(GPIO_PTA1, PTA1_DATA),
	PINMUX_GPIO(GPIO_PTA0, PTA0_DATA),

	/* PTB */
	PINMUX_GPIO(GPIO_PTB7, PTB7_DATA),
	PINMUX_GPIO(GPIO_PTB6, PTB6_DATA),
	PINMUX_GPIO(GPIO_PTB5, PTB5_DATA),
	PINMUX_GPIO(GPIO_PTB4, PTB4_DATA),
	PINMUX_GPIO(GPIO_PTB3, PTB3_DATA),
	PINMUX_GPIO(GPIO_PTB2, PTB2_DATA),
	PINMUX_GPIO(GPIO_PTB1, PTB1_DATA),
	PINMUX_GPIO(GPIO_PTB0, PTB0_DATA),

	/* PTC */
	PINMUX_GPIO(GPIO_PTC7, PTC7_DATA),
	PINMUX_GPIO(GPIO_PTC5, PTC5_DATA),
	PINMUX_GPIO(GPIO_PTC4, PTC4_DATA),
	PINMUX_GPIO(GPIO_PTC3, PTC3_DATA),
	PINMUX_GPIO(GPIO_PTC2, PTC2_DATA),
	PINMUX_GPIO(GPIO_PTC0, PTC0_DATA),

	/* PTD */
	PINMUX_GPIO(GPIO_PTD7, PTD7_DATA),
	PINMUX_GPIO(GPIO_PTD6, PTD6_DATA),
	PINMUX_GPIO(GPIO_PTD5, PTD5_DATA),
	PINMUX_GPIO(GPIO_PTD4, PTD4_DATA),
	PINMUX_GPIO(GPIO_PTD3, PTD3_DATA),
	PINMUX_GPIO(GPIO_PTD2, PTD2_DATA),
	PINMUX_GPIO(GPIO_PTD1, PTD1_DATA),
	PINMUX_GPIO(GPIO_PTD0, PTD0_DATA),

	/* PTE */
	PINMUX_GPIO(GPIO_PTE7, PTE7_DATA),
	PINMUX_GPIO(GPIO_PTE6, PTE6_DATA),
	PINMUX_GPIO(GPIO_PTE5, PTE5_DATA),
	PINMUX_GPIO(GPIO_PTE4, PTE4_DATA),
	PINMUX_GPIO(GPIO_PTE1, PTE1_DATA),
	PINMUX_GPIO(GPIO_PTE0, PTE0_DATA),

	/* PTF */
	PINMUX_GPIO(GPIO_PTF6, PTF6_DATA),
	PINMUX_GPIO(GPIO_PTF5, PTF5_DATA),
	PINMUX_GPIO(GPIO_PTF4, PTF4_DATA),
	PINMUX_GPIO(GPIO_PTF3, PTF3_DATA),
	PINMUX_GPIO(GPIO_PTF2, PTF2_DATA),
	PINMUX_GPIO(GPIO_PTF1, PTF1_DATA),
	PINMUX_GPIO(GPIO_PTF0, PTF0_DATA),

	/* PTG */
	PINMUX_GPIO(GPIO_PTG4, PTG4_DATA),
	PINMUX_GPIO(GPIO_PTG3, PTG3_DATA),
	PINMUX_GPIO(GPIO_PTG2, PTG2_DATA),
	PINMUX_GPIO(GPIO_PTG1, PTG1_DATA),
	PINMUX_GPIO(GPIO_PTG0, PTG0_DATA),

	/* PTH */
	PINMUX_GPIO(GPIO_PTH7, PTH7_DATA),
	PINMUX_GPIO(GPIO_PTH6, PTH6_DATA),
	PINMUX_GPIO(GPIO_PTH5, PTH5_DATA),
	PINMUX_GPIO(GPIO_PTH4, PTH4_DATA),
	PINMUX_GPIO(GPIO_PTH3, PTH3_DATA),
	PINMUX_GPIO(GPIO_PTH2, PTH2_DATA),
	PINMUX_GPIO(GPIO_PTH1, PTH1_DATA),
	PINMUX_GPIO(GPIO_PTH0, PTH0_DATA),

	/* PTJ */
	PINMUX_GPIO(GPIO_PTJ7, PTJ7_DATA),
	PINMUX_GPIO(GPIO_PTJ6, PTJ6_DATA),
	PINMUX_GPIO(GPIO_PTJ5, PTJ5_DATA),
	PINMUX_GPIO(GPIO_PTJ1, PTJ1_DATA),
	PINMUX_GPIO(GPIO_PTJ0, PTJ0_DATA),

	/* PTK */
	PINMUX_GPIO(GPIO_PTK6, PTK6_DATA),
	PINMUX_GPIO(GPIO_PTK5, PTK5_DATA),
	PINMUX_GPIO(GPIO_PTK4, PTK4_DATA),
	PINMUX_GPIO(GPIO_PTK3, PTK3_DATA),
	PINMUX_GPIO(GPIO_PTK2, PTK2_DATA),
	PINMUX_GPIO(GPIO_PTK1, PTK1_DATA),
	PINMUX_GPIO(GPIO_PTK0, PTK0_DATA),

	/* PTL */
	PINMUX_GPIO(GPIO_PTL7, PTL7_DATA),
	PINMUX_GPIO(GPIO_PTL6, PTL6_DATA),
	PINMUX_GPIO(GPIO_PTL5, PTL5_DATA),
	PINMUX_GPIO(GPIO_PTL4, PTL4_DATA),
	PINMUX_GPIO(GPIO_PTL3, PTL3_DATA),
	PINMUX_GPIO(GPIO_PTL2, PTL2_DATA),
	PINMUX_GPIO(GPIO_PTL1, PTL1_DATA),
	PINMUX_GPIO(GPIO_PTL0, PTL0_DATA),

	/* PTM */
	PINMUX_GPIO(GPIO_PTM7, PTM7_DATA),
	PINMUX_GPIO(GPIO_PTM6, PTM6_DATA),
	PINMUX_GPIO(GPIO_PTM5, PTM5_DATA),
	PINMUX_GPIO(GPIO_PTM4, PTM4_DATA),
	PINMUX_GPIO(GPIO_PTM3, PTM3_DATA),
	PINMUX_GPIO(GPIO_PTM2, PTM2_DATA),
	PINMUX_GPIO(GPIO_PTM1, PTM1_DATA),
	PINMUX_GPIO(GPIO_PTM0, PTM0_DATA),

	/* PTN */
	PINMUX_GPIO(GPIO_PTN7, PTN7_DATA),
	PINMUX_GPIO(GPIO_PTN6, PTN6_DATA),
	PINMUX_GPIO(GPIO_PTN5, PTN5_DATA),
	PINMUX_GPIO(GPIO_PTN4, PTN4_DATA),
	PINMUX_GPIO(GPIO_PTN3, PTN3_DATA),
	PINMUX_GPIO(GPIO_PTN2, PTN2_DATA),
	PINMUX_GPIO(GPIO_PTN1, PTN1_DATA),
	PINMUX_GPIO(GPIO_PTN0, PTN0_DATA),

	/* PTQ */
	PINMUX_GPIO(GPIO_PTQ6, PTQ6_DATA),
	PINMUX_GPIO(GPIO_PTQ5, PTQ5_DATA),
	PINMUX_GPIO(GPIO_PTQ4, PTQ4_DATA),
	PINMUX_GPIO(GPIO_PTQ3, PTQ3_DATA),
	PINMUX_GPIO(GPIO_PTQ2, PTQ2_DATA),
	PINMUX_GPIO(GPIO_PTQ1, PTQ1_DATA),
	PINMUX_GPIO(GPIO_PTQ0, PTQ0_DATA),

	/* PTR */
	PINMUX_GPIO(GPIO_PTR4, PTR4_DATA),
	PINMUX_GPIO(GPIO_PTR3, PTR3_DATA),
	PINMUX_GPIO(GPIO_PTR2, PTR2_DATA),
	PINMUX_GPIO(GPIO_PTR1, PTR1_DATA),
	PINMUX_GPIO(GPIO_PTR0, PTR0_DATA),

	/* PTS */
	PINMUX_GPIO(GPIO_PTS4, PTS4_DATA),
	PINMUX_GPIO(GPIO_PTS3, PTS3_DATA),
	PINMUX_GPIO(GPIO_PTS2, PTS2_DATA),
	PINMUX_GPIO(GPIO_PTS1, PTS1_DATA),
	PINMUX_GPIO(GPIO_PTS0, PTS0_DATA),

	/* PTT */
	PINMUX_GPIO(GPIO_PTT4, PTT4_DATA),
	PINMUX_GPIO(GPIO_PTT3, PTT3_DATA),
	PINMUX_GPIO(GPIO_PTT2, PTT2_DATA),
	PINMUX_GPIO(GPIO_PTT1, PTT1_DATA),
	PINMUX_GPIO(GPIO_PTT0, PTT0_DATA),

	/* PTU */
	PINMUX_GPIO(GPIO_PTU4, PTU4_DATA),
	PINMUX_GPIO(GPIO_PTU3, PTU3_DATA),
	PINMUX_GPIO(GPIO_PTU2, PTU2_DATA),
	PINMUX_GPIO(GPIO_PTU1, PTU1_DATA),
	PINMUX_GPIO(GPIO_PTU0, PTU0_DATA),

	/* PTV */
	PINMUX_GPIO(GPIO_PTV4, PTV4_DATA),
	PINMUX_GPIO(GPIO_PTV3, PTV3_DATA),
	PINMUX_GPIO(GPIO_PTV2, PTV2_DATA),
	PINMUX_GPIO(GPIO_PTV1, PTV1_DATA),
	PINMUX_GPIO(GPIO_PTV0, PTV0_DATA),

	/* PTW */
	PINMUX_GPIO(GPIO_PTW6, PTW6_DATA),
	PINMUX_GPIO(GPIO_PTW5, PTW5_DATA),
	PINMUX_GPIO(GPIO_PTW4, PTW4_DATA),
	PINMUX_GPIO(GPIO_PTW3, PTW3_DATA),
	PINMUX_GPIO(GPIO_PTW2, PTW2_DATA),
	PINMUX_GPIO(GPIO_PTW1, PTW1_DATA),
	PINMUX_GPIO(GPIO_PTW0, PTW0_DATA),

	/* PTX */
	PINMUX_GPIO(GPIO_PTX6, PTX6_DATA),
	PINMUX_GPIO(GPIO_PTX5, PTX5_DATA),
	PINMUX_GPIO(GPIO_PTX4, PTX4_DATA),
	PINMUX_GPIO(GPIO_PTX3, PTX3_DATA),
	PINMUX_GPIO(GPIO_PTX2, PTX2_DATA),
	PINMUX_GPIO(GPIO_PTX1, PTX1_DATA),
	PINMUX_GPIO(GPIO_PTX0, PTX0_DATA),

	/* PTY */
	PINMUX_GPIO(GPIO_PTY5, PTY5_DATA),
	PINMUX_GPIO(GPIO_PTY4, PTY4_DATA),
	PINMUX_GPIO(GPIO_PTY3, PTY3_DATA),
	PINMUX_GPIO(GPIO_PTY2, PTY2_DATA),
	PINMUX_GPIO(GPIO_PTY1, PTY1_DATA),
	PINMUX_GPIO(GPIO_PTY0, PTY0_DATA),

	/* PTZ */
	PINMUX_GPIO(GPIO_PTZ5, PTZ5_DATA),
	PINMUX_GPIO(GPIO_PTZ4, PTZ4_DATA),
	PINMUX_GPIO(GPIO_PTZ3, PTZ3_DATA),
	PINMUX_GPIO(GPIO_PTZ2, PTZ2_DATA),
	PINMUX_GPIO(GPIO_PTZ1, PTZ1_DATA),

	/* SCIF0 */
	PINMUX_GPIO(GPIO_FN_SCIF0_TXD, SCIF0_TXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF0_RXD, SCIF0_RXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF0_RTS, SCIF0_RTS_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF0_CTS, SCIF0_CTS_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF0_SCK, SCIF0_SCK_MARK),

	/* SCIF1 */
	PINMUX_GPIO(GPIO_FN_SCIF1_TXD, SCIF1_TXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF1_RXD, SCIF1_RXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF1_RTS, SCIF1_RTS_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF1_CTS, SCIF1_CTS_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF1_SCK, SCIF1_SCK_MARK),

	/* SCIF2 */
	PINMUX_GPIO(GPIO_FN_SCIF2_TXD, SCIF2_TXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF2_RXD, SCIF2_RXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF2_RTS, SCIF2_RTS_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF2_CTS, SCIF2_CTS_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF2_SCK, SCIF2_SCK_MARK),

	/* SIO */
	PINMUX_GPIO(GPIO_FN_SIOTXD, SIOTXD_MARK),
	PINMUX_GPIO(GPIO_FN_SIORXD, SIORXD_MARK),
	PINMUX_GPIO(GPIO_FN_SIOD, SIOD_MARK),
	PINMUX_GPIO(GPIO_FN_SIOSTRB0, SIOSTRB0_MARK),
	PINMUX_GPIO(GPIO_FN_SIOSTRB1, SIOSTRB1_MARK),
	PINMUX_GPIO(GPIO_FN_SIOSCK, SIOSCK_MARK),
	PINMUX_GPIO(GPIO_FN_SIOMCK, SIOMCK_MARK),

	/* CEU */
	PINMUX_GPIO(GPIO_FN_VIO_D15, VIO_D15_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D14, VIO_D14_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D13, VIO_D13_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D12, VIO_D12_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D11, VIO_D11_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D10, VIO_D10_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D9, VIO_D9_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D8, VIO_D8_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D7, VIO_D7_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D6, VIO_D6_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D5, VIO_D5_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D4, VIO_D4_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D3, VIO_D3_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D2, VIO_D2_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D1, VIO_D1_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D0, VIO_D0_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_CLK, VIO_CLK_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_VD, VIO_VD_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_HD, VIO_HD_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_FLD, VIO_FLD_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_CKO, VIO_CKO_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_STEX, VIO_STEX_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_STEM, VIO_STEM_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_VD2, VIO_VD2_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_HD2, VIO_HD2_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_CLK2, VIO_CLK2_MARK),

	/* LCDC */
	PINMUX_GPIO(GPIO_FN_LCDD23, LCDD23_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD22, LCDD22_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD21, LCDD21_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD20, LCDD20_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD19, LCDD19_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD18, LCDD18_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD17, LCDD17_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD16, LCDD16_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD15, LCDD15_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD14, LCDD14_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD13, LCDD13_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD12, LCDD12_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD11, LCDD11_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD10, LCDD10_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD9, LCDD9_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD8, LCDD8_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD7, LCDD7_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD6, LCDD6_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD5, LCDD5_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD4, LCDD4_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD3, LCDD3_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD2, LCDD2_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD1, LCDD1_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD0, LCDD0_MARK),
	PINMUX_GPIO(GPIO_FN_LCDLCLK, LCDLCLK_MARK),
	/* Main LCD */
	PINMUX_GPIO(GPIO_FN_LCDDON, LCDDON_MARK),
	PINMUX_GPIO(GPIO_FN_LCDVCPWC, LCDVCPWC_MARK),
	PINMUX_GPIO(GPIO_FN_LCDVEPWC, LCDVEPWC_MARK),
	PINMUX_GPIO(GPIO_FN_LCDVSYN, LCDVSYN_MARK),
	/* Main LCD - RGB Mode */
	PINMUX_GPIO(GPIO_FN_LCDDCK, LCDDCK_MARK),
	PINMUX_GPIO(GPIO_FN_LCDHSYN, LCDHSYN_MARK),
	PINMUX_GPIO(GPIO_FN_LCDDISP, LCDDISP_MARK),
	/* Main LCD - SYS Mode */
	PINMUX_GPIO(GPIO_FN_LCDRS, LCDRS_MARK),
	PINMUX_GPIO(GPIO_FN_LCDCS, LCDCS_MARK),
	PINMUX_GPIO(GPIO_FN_LCDWR, LCDWR_MARK),
	PINMUX_GPIO(GPIO_FN_LCDRD, LCDRD_MARK),
	/* Sub LCD - SYS Mode */
	PINMUX_GPIO(GPIO_FN_LCDDON2, LCDDON2_MARK),
	PINMUX_GPIO(GPIO_FN_LCDVCPWC2, LCDVCPWC2_MARK),
	PINMUX_GPIO(GPIO_FN_LCDVEPWC2, LCDVEPWC2_MARK),
	PINMUX_GPIO(GPIO_FN_LCDVSYN2, LCDVSYN2_MARK),
	PINMUX_GPIO(GPIO_FN_LCDCS2, LCDCS2_MARK),

	/* BSC */
	PINMUX_GPIO(GPIO_FN_IOIS16, IOIS16_MARK),
	PINMUX_GPIO(GPIO_FN_A25, A25_MARK),
	PINMUX_GPIO(GPIO_FN_A24, A24_MARK),
	PINMUX_GPIO(GPIO_FN_A23, A23_MARK),
	PINMUX_GPIO(GPIO_FN_A22, A22_MARK),
	PINMUX_GPIO(GPIO_FN_BS, BS_MARK),
	PINMUX_GPIO(GPIO_FN_CS6B_CE1B, CS6B_CE1B_MARK),
	PINMUX_GPIO(GPIO_FN_WAIT, WAIT_MARK),
	PINMUX_GPIO(GPIO_FN_CS6A_CE2B, CS6A_CE2B_MARK),

	/* SBSC */
	PINMUX_GPIO(GPIO_FN_HPD63, HPD63_MARK),
	PINMUX_GPIO(GPIO_FN_HPD62, HPD62_MARK),
	PINMUX_GPIO(GPIO_FN_HPD61, HPD61_MARK),
	PINMUX_GPIO(GPIO_FN_HPD60, HPD60_MARK),
	PINMUX_GPIO(GPIO_FN_HPD59, HPD59_MARK),
	PINMUX_GPIO(GPIO_FN_HPD58, HPD58_MARK),
	PINMUX_GPIO(GPIO_FN_HPD57, HPD57_MARK),
	PINMUX_GPIO(GPIO_FN_HPD56, HPD56_MARK),
	PINMUX_GPIO(GPIO_FN_HPD55, HPD55_MARK),
	PINMUX_GPIO(GPIO_FN_HPD54, HPD54_MARK),
	PINMUX_GPIO(GPIO_FN_HPD53, HPD53_MARK),
	PINMUX_GPIO(GPIO_FN_HPD52, HPD52_MARK),
	PINMUX_GPIO(GPIO_FN_HPD51, HPD51_MARK),
	PINMUX_GPIO(GPIO_FN_HPD50, HPD50_MARK),
	PINMUX_GPIO(GPIO_FN_HPD49, HPD49_MARK),
	PINMUX_GPIO(GPIO_FN_HPD48, HPD48_MARK),
	PINMUX_GPIO(GPIO_FN_HPDQM7, HPDQM7_MARK),
	PINMUX_GPIO(GPIO_FN_HPDQM6, HPDQM6_MARK),
	PINMUX_GPIO(GPIO_FN_HPDQM5, HPDQM5_MARK),
	PINMUX_GPIO(GPIO_FN_HPDQM4, HPDQM4_MARK),

	/* IRQ */
	PINMUX_GPIO(GPIO_FN_IRQ0, IRQ0_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ1, IRQ1_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ2, IRQ2_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ3, IRQ3_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ4, IRQ4_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ5, IRQ5_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ6, IRQ6_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ7, IRQ7_MARK),

	/* SDHI */
	PINMUX_GPIO(GPIO_FN_SDHICD, SDHICD_MARK),
	PINMUX_GPIO(GPIO_FN_SDHIWP, SDHIWP_MARK),
	PINMUX_GPIO(GPIO_FN_SDHID3, SDHID3_MARK),
	PINMUX_GPIO(GPIO_FN_SDHID2, SDHID2_MARK),
	PINMUX_GPIO(GPIO_FN_SDHID1, SDHID1_MARK),
	PINMUX_GPIO(GPIO_FN_SDHID0, SDHID0_MARK),
	PINMUX_GPIO(GPIO_FN_SDHICMD, SDHICMD_MARK),
	PINMUX_GPIO(GPIO_FN_SDHICLK, SDHICLK_MARK),

	/* SIU - Port A */
	PINMUX_GPIO(GPIO_FN_SIUAOLR, SIUAOLR_MARK),
	PINMUX_GPIO(GPIO_FN_SIUAOBT, SIUAOBT_MARK),
	PINMUX_GPIO(GPIO_FN_SIUAISLD, SIUAISLD_MARK),
	PINMUX_GPIO(GPIO_FN_SIUAILR, SIUAILR_MARK),
	PINMUX_GPIO(GPIO_FN_SIUAIBT, SIUAIBT_MARK),
	PINMUX_GPIO(GPIO_FN_SIUAOSLD, SIUAOSLD_MARK),
	PINMUX_GPIO(GPIO_FN_SIUMCKA, SIUMCKA_MARK),
	PINMUX_GPIO(GPIO_FN_SIUFCKA, SIUFCKA_MARK),

	/* SIU - Port B */
	PINMUX_GPIO(GPIO_FN_SIUBOLR, SIUBOLR_MARK),
	PINMUX_GPIO(GPIO_FN_SIUBOBT, SIUBOBT_MARK),
	PINMUX_GPIO(GPIO_FN_SIUBISLD, SIUBISLD_MARK),
	PINMUX_GPIO(GPIO_FN_SIUBILR, SIUBILR_MARK),
	PINMUX_GPIO(GPIO_FN_SIUBIBT, SIUBIBT_MARK),
	PINMUX_GPIO(GPIO_FN_SIUBOSLD, SIUBOSLD_MARK),
	PINMUX_GPIO(GPIO_FN_SIUMCKB, SIUMCKB_MARK),
	PINMUX_GPIO(GPIO_FN_SIUFCKB, SIUFCKB_MARK),

	/* AUD */
	PINMUX_GPIO(GPIO_FN_AUDSYNC, AUDSYNC_MARK),
	PINMUX_GPIO(GPIO_FN_AUDATA3, AUDATA3_MARK),
	PINMUX_GPIO(GPIO_FN_AUDATA2, AUDATA2_MARK),
	PINMUX_GPIO(GPIO_FN_AUDATA1, AUDATA1_MARK),
	PINMUX_GPIO(GPIO_FN_AUDATA0, AUDATA0_MARK),

	/* DMAC */
	PINMUX_GPIO(GPIO_FN_DACK, DACK_MARK),
	PINMUX_GPIO(GPIO_FN_DREQ0, DREQ0_MARK),

	/* VOU */
	PINMUX_GPIO(GPIO_FN_DV_CLKI, DV_CLKI_MARK),
	PINMUX_GPIO(GPIO_FN_DV_CLK, DV_CLK_MARK),
	PINMUX_GPIO(GPIO_FN_DV_HSYNC, DV_HSYNC_MARK),
	PINMUX_GPIO(GPIO_FN_DV_VSYNC, DV_VSYNC_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D15, DV_D15_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D14, DV_D14_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D13, DV_D13_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D12, DV_D12_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D11, DV_D11_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D10, DV_D10_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D9, DV_D9_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D8, DV_D8_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D7, DV_D7_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D6, DV_D6_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D5, DV_D5_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D4, DV_D4_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D3, DV_D3_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D2, DV_D2_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D1, DV_D1_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D0, DV_D0_MARK),

	/* CPG */
	PINMUX_GPIO(GPIO_FN_STATUS0, STATUS0_MARK),
	PINMUX_GPIO(GPIO_FN_PDSTATUS, PDSTATUS_MARK),

	/* SIOF0 */
	PINMUX_GPIO(GPIO_FN_SIOF0_MCK, SIOF0_MCK_MARK),
	PINMUX_GPIO(GPIO_FN_SIOF0_SCK, SIOF0_SCK_MARK),
	PINMUX_GPIO(GPIO_FN_SIOF0_SYNC, SIOF0_SYNC_MARK),
	PINMUX_GPIO(GPIO_FN_SIOF0_SS1, SIOF0_SS1_MARK),
	PINMUX_GPIO(GPIO_FN_SIOF0_SS2, SIOF0_SS2_MARK),
	PINMUX_GPIO(GPIO_FN_SIOF0_TXD, SIOF0_TXD_MARK),
	PINMUX_GPIO(GPIO_FN_SIOF0_RXD, SIOF0_RXD_MARK),

	/* SIOF1 */
	PINMUX_GPIO(GPIO_FN_SIOF1_MCK, SIOF1_MCK_MARK),
	PINMUX_GPIO(GPIO_FN_SIOF1_SCK, SIOF1_SCK_MARK),
	PINMUX_GPIO(GPIO_FN_SIOF1_SYNC, SIOF1_SYNC_MARK),
	PINMUX_GPIO(GPIO_FN_SIOF1_SS1, SIOF1_SS1_MARK),
	PINMUX_GPIO(GPIO_FN_SIOF1_SS2, SIOF1_SS2_MARK),
	PINMUX_GPIO(GPIO_FN_SIOF1_TXD, SIOF1_TXD_MARK),
	PINMUX_GPIO(GPIO_FN_SIOF1_RXD, SIOF1_RXD_MARK),

	/* SIM */
	PINMUX_GPIO(GPIO_FN_SIM_D, SIM_D_MARK),
	PINMUX_GPIO(GPIO_FN_SIM_CLK, SIM_CLK_MARK),
	PINMUX_GPIO(GPIO_FN_SIM_RST, SIM_RST_MARK),

	/* TSIF */
	PINMUX_GPIO(GPIO_FN_TS_SDAT, TS_SDAT_MARK),
	PINMUX_GPIO(GPIO_FN_TS_SCK, TS_SCK_MARK),
	PINMUX_GPIO(GPIO_FN_TS_SDEN, TS_SDEN_MARK),
	PINMUX_GPIO(GPIO_FN_TS_SPSYNC, TS_SPSYNC_MARK),

	/* IRDA */
	PINMUX_GPIO(GPIO_FN_IRDA_IN, IRDA_IN_MARK),
	PINMUX_GPIO(GPIO_FN_IRDA_OUT, IRDA_OUT_MARK),

	/* TPU */
	PINMUX_GPIO(GPIO_FN_TPUTO, TPUTO_MARK),

	/* FLCTL */
	PINMUX_GPIO(GPIO_FN_FCE, FCE_MARK),
	PINMUX_GPIO(GPIO_FN_NAF7, NAF7_MARK),
	PINMUX_GPIO(GPIO_FN_NAF6, NAF6_MARK),
	PINMUX_GPIO(GPIO_FN_NAF5, NAF5_MARK),
	PINMUX_GPIO(GPIO_FN_NAF4, NAF4_MARK),
	PINMUX_GPIO(GPIO_FN_NAF3, NAF3_MARK),
	PINMUX_GPIO(GPIO_FN_NAF2, NAF2_MARK),
	PINMUX_GPIO(GPIO_FN_NAF1, NAF1_MARK),
	PINMUX_GPIO(GPIO_FN_NAF0, NAF0_MARK),
	PINMUX_GPIO(GPIO_FN_FCDE, FCDE_MARK),
	PINMUX_GPIO(GPIO_FN_FOE, FOE_MARK),
	PINMUX_GPIO(GPIO_FN_FSC, FSC_MARK),
	PINMUX_GPIO(GPIO_FN_FWE, FWE_MARK),
	PINMUX_GPIO(GPIO_FN_FRB, FRB_MARK),

	/* KEYSC */
	PINMUX_GPIO(GPIO_FN_KEYIN0, KEYIN0_MARK),
	PINMUX_GPIO(GPIO_FN_KEYIN1, KEYIN1_MARK),
	PINMUX_GPIO(GPIO_FN_KEYIN2, KEYIN2_MARK),
	PINMUX_GPIO(GPIO_FN_KEYIN3, KEYIN3_MARK),
	PINMUX_GPIO(GPIO_FN_KEYIN4, KEYIN4_MARK),
	PINMUX_GPIO(GPIO_FN_KEYOUT0, KEYOUT0_MARK),
	PINMUX_GPIO(GPIO_FN_KEYOUT1, KEYOUT1_MARK),
	PINMUX_GPIO(GPIO_FN_KEYOUT2, KEYOUT2_MARK),
	PINMUX_GPIO(GPIO_FN_KEYOUT3, KEYOUT3_MARK),
	PINMUX_GPIO(GPIO_FN_KEYOUT4_IN6, KEYOUT4_IN6_MARK),
	PINMUX_GPIO(GPIO_FN_KEYOUT5_IN5, KEYOUT5_IN5_MARK),
};

static struct pinmux_cfg_reg pinmux_config_regs[] = {
	{ PINMUX_CFG_REG("PACR", 0xa4050100, 16, 2) {
		VIO_D7_SCIF1_SCK, PTA7_OUT, PTA7_IN_PD, PTA7_IN,
		VIO_D6_SCIF1_RXD, 0, PTA6_IN_PD, PTA6_IN,
		VIO_D5_SCIF1_TXD, PTA5_OUT, PTA5_IN_PD, PTA5_IN,
		VIO_D4, 0, PTA4_IN_PD, PTA4_IN,
		VIO_D3, 0, PTA3_IN_PD, PTA3_IN,
		VIO_D2, 0, PTA2_IN_PD, PTA2_IN,
		VIO_D1, 0, PTA1_IN_PD, PTA1_IN,
		VIO_D0_LCDLCLK, 0, PTA0_IN_PD, PTA0_IN }
	},
	{ PINMUX_CFG_REG("PBCR", 0xa4050102, 16, 2) {
		HPD55, PTB7_OUT, 0, PTB7_IN,
		HPD54, PTB6_OUT, 0, PTB6_IN,
		HPD53, PTB5_OUT, 0, PTB5_IN,
		HPD52, PTB4_OUT, 0, PTB4_IN,
		HPD51, PTB3_OUT, 0, PTB3_IN,
		HPD50, PTB2_OUT, 0, PTB2_IN,
		HPD49, PTB1_OUT, 0, PTB1_IN,
		HPD48, PTB0_OUT, 0, PTB0_IN }
	},
	{ PINMUX_CFG_REG("PCCR", 0xa4050104, 16, 2) {
		0, 0, PTC7_IN_PU, PTC7_IN,
		0, 0, 0, 0,
		IOIS16, 0, PTC5_IN_PU, PTC5_IN,
		HPDQM7, PTC4_OUT, 0, PTC4_IN,
		HPDQM6, PTC3_OUT, 0, PTC3_IN,
		HPDQM5, PTC2_OUT, 0, PTC2_IN,
		0, 0, 0, 0,
		HPDQM4, PTC0_OUT, 0, PTC0_IN }
	},
	{ PINMUX_CFG_REG("PDCR", 0xa4050106, 16, 2) {
		SDHICD, 0, PTD7_IN_PU, PTD7_IN,
		SDHIWP, PTD6_OUT, PTD6_IN_PU, PTD6_IN,
		SDHID3, PTD5_OUT, PTD5_IN_PU, PTD5_IN,
		IRQ2_SDHID2, PTD4_OUT, PTD4_IN_PU, PTD4_IN,
		SDHID1, PTD3_OUT, PTD3_IN_PU, PTD3_IN,
		SDHID0, PTD2_OUT, PTD2_IN_PU, PTD2_IN,
		SDHICMD, PTD1_OUT, PTD1_IN_PU, PTD1_IN,
		SDHICLK, PTD0_OUT, 0, 0 }
	},
	{ PINMUX_CFG_REG("PECR", 0xa4050108, 16, 2) {
		A25, PTE7_OUT, PTE7_IN_PD, PTE7_IN,
		A24, PTE6_OUT, PTE6_IN_PD, PTE6_IN,
		A23, PTE5_OUT, PTE5_IN_PD, PTE5_IN,
		A22, PTE4_OUT, PTE4_IN_PD, PTE4_IN,
		0, 0, 0, 0,
		0, 0, 0, 0,
		IRQ5, PTE1_OUT, PTE1_IN_PD, PTE1_IN,
		IRQ4_BS, PTE0_OUT, PTE0_IN_PD, PTE0_IN }
	},
	{ PINMUX_CFG_REG("PFCR", 0xa405010a, 16, 2) {
		0, 0, 0, 0,
		PTF6, PTF6_OUT, PTF6_IN_PD, PTF6_IN,
		SIOSCK_SIUBOBT, PTF5_OUT, PTF5_IN_PD, PTF5_IN,
		SIOSTRB1_SIUBOLR, PTF4_OUT, PTF4_IN_PD, PTF4_IN,
		SIOSTRB0_SIUBIBT, PTF3_OUT, PTF3_IN_PD, PTF3_IN,
		SIOD_SIUBILR, PTF2_OUT, PTF2_IN_PD, PTF2_IN,
		SIORXD_SIUBISLD, 0, PTF1_IN_PD, PTF1_IN,
		SIOTXD_SIUBOSLD, PTF0_OUT, 0, 0 }
	},
	{ PINMUX_CFG_REG("PGCR", 0xa405010c, 16, 2) {
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		AUDSYNC, PTG4_OUT, 0, 0,
		AUDATA3, PTG3_OUT, 0, 0,
		AUDATA2, PTG2_OUT, 0, 0,
		AUDATA1, PTG1_OUT, 0, 0,
		AUDATA0, PTG0_OUT, 0, 0 }
	},
	{ PINMUX_CFG_REG("PHCR", 0xa405010e, 16, 2) {
		LCDVCPWC_LCDVCPWC2, PTH7_OUT, 0, 0,
		LCDVSYN2_DACK, PTH6_OUT, PTH6_IN_PD, PTH6_IN,
		LCDVSYN, PTH5_OUT, PTH5_IN_PD, PTH5_IN,
		LCDDISP_LCDRS, PTH4_OUT, 0, 0,
		LCDHSYN_LCDCS, PTH3_OUT, 0, 0,
		LCDDON_LCDDON2, PTH2_OUT, 0, 0,
		LCDD17_DV_HSYNC, PTH1_OUT, PTH1_IN_PD, PTH1_IN,
		LCDD16_DV_VSYNC, PTH0_OUT, PTH0_IN_PD, PTH0_IN }
	},
	{ PINMUX_CFG_REG("PJCR", 0xa4050110, 16, 2) {
		STATUS0, PTJ7_OUT, 0, 0,
		0, PTJ6_OUT, 0, 0,
		PDSTATUS, PTJ5_OUT, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		IRQ1, PTJ1_OUT, PTJ1_IN_PU, PTJ1_IN,
		IRQ0, PTJ0_OUT, PTJ0_IN_PU, PTJ0_IN }
	},
	{ PINMUX_CFG_REG("PKCR", 0xa4050112, 16, 2) {
		0, 0, 0, 0,
		SIUAILR_SIOF1_SS2, PTK6_OUT, PTK6_IN_PD, PTK6_IN,
		SIUAIBT_SIOF1_SS1, PTK5_OUT, PTK5_IN_PD, PTK5_IN,
		SIUAOLR_SIOF1_SYNC, PTK4_OUT, PTK4_IN_PD, PTK4_IN,
		SIUAOBT_SIOF1_SCK, PTK3_OUT, PTK3_IN_PD, PTK3_IN,
		SIUAISLD_SIOF1_RXD, 0, PTK2_IN_PD, PTK2_IN,
		SIUAOSLD_SIOF1_TXD, PTK1_OUT, 0, 0,
		PTK0, PTK0_OUT, PTK0_IN_PD, PTK0_IN }
	},
	{ PINMUX_CFG_REG("PLCR", 0xa4050114, 16, 2) {
		LCDD15_DV_D15, PTL7_OUT, PTL7_IN_PD, PTL7_IN,
		LCDD14_DV_D14, PTL6_OUT, PTL6_IN_PD, PTL6_IN,
		LCDD13_DV_D13, PTL5_OUT, PTL5_IN_PD, PTL5_IN,
		LCDD12_DV_D12, PTL4_OUT, PTL4_IN_PD, PTL4_IN,
		LCDD11_DV_D11, PTL3_OUT, PTL3_IN_PD, PTL3_IN,
		LCDD10_DV_D10, PTL2_OUT, PTL2_IN_PD, PTL2_IN,
		LCDD9_DV_D9, PTL1_OUT, PTL1_IN_PD, PTL1_IN,
		LCDD8_DV_D8, PTL0_OUT, PTL0_IN_PD, PTL0_IN }
	},
	{ PINMUX_CFG_REG("PMCR", 0xa4050116, 16, 2) {
		LCDD7_DV_D7, PTM7_OUT, PTM7_IN_PD, PTM7_IN,
		LCDD6_DV_D6, PTM6_OUT, PTM6_IN_PD, PTM6_IN,
		LCDD5_DV_D5, PTM5_OUT, PTM5_IN_PD, PTM5_IN,
		LCDD4_DV_D4, PTM4_OUT, PTM4_IN_PD, PTM4_IN,
		LCDD3_DV_D3, PTM3_OUT, PTM3_IN_PD, PTM3_IN,
		LCDD2_DV_D2, PTM2_OUT, PTM2_IN_PD, PTM2_IN,
		LCDD1_DV_D1, PTM1_OUT, PTM1_IN_PD, PTM1_IN,
		LCDD0_DV_D0, PTM0_OUT, PTM0_IN_PD, PTM0_IN }
	},
	{ PINMUX_CFG_REG("PNCR", 0xa4050118, 16, 2) {
		HPD63, PTN7_OUT, 0, PTN7_IN,
		HPD62, PTN6_OUT, 0, PTN6_IN,
		HPD61, PTN5_OUT, 0, PTN5_IN,
		HPD60, PTN4_OUT, 0, PTN4_IN,
		HPD59, PTN3_OUT, 0, PTN3_IN,
		HPD58, PTN2_OUT, 0, PTN2_IN,
		HPD57, PTN1_OUT, 0, PTN1_IN,
		HPD56, PTN0_OUT, 0, PTN0_IN }
	},
	{ PINMUX_CFG_REG("PQCR", 0xa405011a, 16, 2) {
		0, 0, 0, 0,
		SIOF0_SS2_SIM_RST, PTQ6_OUT, 0, 0,
		SIOF0_SS1_TS_SPSYNC, PTQ5_OUT, PTQ5_IN_PD, PTQ5_IN,
		SIOF0_SYNC_TS_SDEN, PTQ4_OUT, PTQ4_IN_PD, PTQ4_IN,
		SIOF0_SCK_TS_SCK, PTQ3_OUT, PTQ3_IN_PD, PTQ3_IN,
		PTQ2, 0, PTQ2_IN_PD, PTQ2_IN,
		PTQ1, PTQ1_OUT, 0, 0,
		PTQ0, PTQ0_OUT, PTQ0_IN_PU, PTQ0_IN }
	},
	{ PINMUX_CFG_REG("PRCR", 0xa405011c, 16, 2) {
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		LCDRD, PTR4_OUT, 0, 0,
		CS6B_CE1B_LCDCS2, PTR3_OUT, 0, 0,
		WAIT, 0, PTR2_IN_PU, PTR2_IN,
		LCDDCK_LCDWR, PTR1_OUT, 0, 0,
		LCDVEPWC_LCDVEPWC2, PTR0_OUT, 0, 0 }
	},
	{ PINMUX_CFG_REG("PSCR", 0xa405011e, 16, 2) {
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		SCIF0_CTS_SIUAISPD, 0, PTS4_IN_PD, PTS4_IN,
		SCIF0_RTS_SIUAOSPD, PTS3_OUT, 0, 0,
		SCIF0_SCK_TPUTO, PTS2_OUT, PTS2_IN_PD, PTS2_IN,
		SCIF0_RXD, 0, PTS1_IN_PD, PTS1_IN,
		SCIF0_TXD, PTS0_OUT, 0, 0 }
	},
	{ PINMUX_CFG_REG("PTCR", 0xa4050140, 16, 2) {
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		FOE_VIO_VD2, PTT4_OUT, PTT4_IN_PD, PTT4_IN,
		FWE, PTT3_OUT, PTT3_IN_PD, PTT3_IN,
		FSC, PTT2_OUT, PTT2_IN_PD, PTT2_IN,
		DREQ0, 0, PTT1_IN_PD, PTT1_IN,
		FCDE, PTT0_OUT, 0, 0 }
	},
	{ PINMUX_CFG_REG("PUCR", 0xa4050142, 16, 2) {
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		NAF2_VIO_D10, PTU4_OUT, PTU4_IN_PD, PTU4_IN,
		NAF1_VIO_D9, PTU3_OUT, PTU3_IN_PD, PTU3_IN,
		NAF0_VIO_D8, PTU2_OUT, PTU2_IN_PD, PTU2_IN,
		FRB_VIO_CLK2, 0, PTU1_IN_PD, PTU1_IN,
		FCE_VIO_HD2, PTU0_OUT, PTU0_IN_PD, PTU0_IN }
	},
	{ PINMUX_CFG_REG("PVCR", 0xa4050144, 16, 2) {
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		NAF7_VIO_D15, PTV4_OUT, PTV4_IN_PD, PTV4_IN,
		NAF6_VIO_D14, PTV3_OUT, PTV3_IN_PD, PTV3_IN,
		NAF5_VIO_D13, PTV2_OUT, PTV2_IN_PD, PTV2_IN,
		NAF4_VIO_D12, PTV1_OUT, PTV1_IN_PD, PTV1_IN,
		NAF3_VIO_D11, PTV0_OUT, PTV0_IN_PD, PTV0_IN }
	},
	{ PINMUX_CFG_REG("PWCR", 0xa4050146, 16, 2) {
		0, 0, 0, 0,
		VIO_FLD_SCIF2_CTS, 0, PTW6_IN_PD, PTW6_IN,
		VIO_CKO_SCIF2_RTS, PTW5_OUT, 0, 0,
		VIO_STEX_SCIF2_SCK, PTW4_OUT, PTW4_IN_PD, PTW4_IN,
		VIO_STEM_SCIF2_TXD, PTW3_OUT, PTW3_IN_PD, PTW3_IN,
		VIO_HD_SCIF2_RXD, PTW2_OUT, PTW2_IN_PD, PTW2_IN,
		VIO_VD_SCIF1_CTS, PTW1_OUT, PTW1_IN_PD, PTW1_IN,
		VIO_CLK_SCIF1_RTS, PTW0_OUT, PTW0_IN_PD, PTW0_IN }
	},
	{ PINMUX_CFG_REG("PXCR", 0xa4050148, 16, 2) {
		0, 0, 0, 0,
		CS6A_CE2B, PTX6_OUT, PTX6_IN_PU, PTX6_IN,
		LCDD23, PTX5_OUT, PTX5_IN_PD, PTX5_IN,
		LCDD22, PTX4_OUT, PTX4_IN_PD, PTX4_IN,
		LCDD21, PTX3_OUT, PTX3_IN_PD, PTX3_IN,
		LCDD20, PTX2_OUT, PTX2_IN_PD, PTX2_IN,
		LCDD19_DV_CLKI, PTX1_OUT, PTX1_IN_PD, PTX1_IN,
		LCDD18_DV_CLK, PTX0_OUT, PTX0_IN_PD, PTX0_IN }
	},
	{ PINMUX_CFG_REG("PYCR", 0xa405014a, 16, 2) {
		0, 0, 0, 0,
		0, 0, 0, 0,
		KEYOUT5_IN5, PTY5_OUT, PTY5_IN_PU, PTY5_IN,
		KEYOUT4_IN6, PTY4_OUT, PTY4_IN_PU, PTY4_IN,
		KEYOUT3, PTY3_OUT, PTY3_IN_PU, PTY3_IN,
		KEYOUT2, PTY2_OUT, PTY2_IN_PU, PTY2_IN,
		KEYOUT1, PTY1_OUT, 0, 0,
		KEYOUT0, PTY0_OUT, PTY0_IN_PU, PTY0_IN }
	},
	{ PINMUX_CFG_REG("PZCR", 0xa405014c, 16, 2) {
		0, 0, 0, 0,
		0, 0, 0, 0,
		KEYIN4_IRQ7, 0, PTZ5_IN_PU, PTZ5_IN,
		KEYIN3, 0, PTZ4_IN_PU, PTZ4_IN,
		KEYIN2, 0, PTZ3_IN_PU, PTZ3_IN,
		KEYIN1, 0, PTZ2_IN_PU, PTZ2_IN,
		KEYIN0_IRQ6, 0, PTZ1_IN_PU, PTZ1_IN,
		0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PSELA", 0xa405014e, 16, 1) {
		PSA15_KEYIN0, PSA15_IRQ6,
		PSA14_KEYIN4, PSA14_IRQ7,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		PSA9_IRQ4, PSA9_BS,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		PSA4_IRQ2, PSA4_SDHID2,
		0, 0,
		0, 0,
		0, 0,
		0, 0 }
	},
	{ PINMUX_CFG_REG("PSELB", 0xa4050150, 16, 1) {
		PSB15_SIOTXD, PSB15_SIUBOSLD,
		PSB14_SIORXD, PSB14_SIUBISLD,
		PSB13_SIOD, PSB13_SIUBILR,
		PSB12_SIOSTRB0, PSB12_SIUBIBT,
		PSB11_SIOSTRB1, PSB11_SIUBOLR,
		PSB10_SIOSCK, PSB10_SIUBOBT,
		PSB9_SIOMCK, PSB9_SIUMCKB,
		PSB8_SIOF0_MCK, PSB8_IRQ3,
		PSB7_SIOF0_TXD, PSB7_IRDA_OUT,
		PSB6_SIOF0_RXD, PSB6_IRDA_IN,
		PSB5_SIOF0_SCK, PSB5_TS_SCK,
		PSB4_SIOF0_SYNC, PSB4_TS_SDEN,
		PSB3_SIOF0_SS1, PSB3_TS_SPSYNC,
		PSB2_SIOF0_SS2, PSB2_SIM_RST,
		PSB1_SIUMCKA, PSB1_SIOF1_MCK,
		PSB0_SIUAOSLD, PSB0_SIOF1_TXD }
	},
	{ PINMUX_CFG_REG("PSELC", 0xa4050152, 16, 1) {
		PSC15_SIUAISLD, PSC15_SIOF1_RXD,
		PSC14_SIUAOBT, PSC14_SIOF1_SCK,
		PSC13_SIUAOLR, PSC13_SIOF1_SYNC,
		PSC12_SIUAIBT, PSC12_SIOF1_SS1,
		PSC11_SIUAILR, PSC11_SIOF1_SS2,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		PSC0_NAF, PSC0_VIO }
	},
	{ PINMUX_CFG_REG("PSELD", 0xa4050154, 16, 1) {
		0, 0,
		0, 0,
		PSD13_VIO, PSD13_SCIF2,
		PSD12_VIO, PSD12_SCIF1,
		PSD11_VIO, PSD11_SCIF1,
		PSD10_VIO_D0, PSD10_LCDLCLK,
		PSD9_SIOMCK_SIUMCKB, PSD9_SIUFCKB,
		PSD8_SCIF0_SCK, PSD8_TPUTO,
		PSD7_SCIF0_RTS, PSD7_SIUAOSPD,
		PSD6_SCIF0_CTS, PSD6_SIUAISPD,
		PSD5_CS6B_CE1B, PSD5_LCDCS2,
		0, 0,
		PSD3_LCDVEPWC_LCDVCPWC, PSD3_LCDVEPWC2_LCDVCPWC2,
		PSD2_LCDDON, PSD2_LCDDON2,
		0, 0,
		PSD0_LCDD19_LCDD0, PSD0_DV }
	},
	{ PINMUX_CFG_REG("PSELE", 0xa4050156, 16, 1) {
		PSE15_SIOF0_MCK_IRQ3, PSE15_SIM_D,
		PSE14_SIOF0_TXD_IRDA_OUT, PSE14_SIM_CLK,
		PSE13_SIOF0_RXD_IRDA_IN, PSE13_TS_SDAT,
		PSE12_LCDVSYN2, PSE12_DACK,
		PSE11_SIUMCKA_SIOF1_MCK, PSE11_SIUFCKA,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		PSE3_FLCTL, PSE3_VIO,
		PSE2_NAF2, PSE2_VIO_D10,
		PSE1_NAF1, PSE1_VIO_D9,
		PSE0_NAF0, PSE0_VIO_D8 }
	},
	{ PINMUX_CFG_REG("HIZCRA", 0xa4050158, 16, 1) {
		0, 0,
		HIZA14_KEYSC, HIZA14_HIZ,
		0, 0,
		0, 0,
		0, 0,
		HIZA10_NAF, HIZA10_HIZ,
		HIZA9_VIO, HIZA9_HIZ,
		HIZA8_LCDC, HIZA8_HIZ,
		HIZA7_LCDC, HIZA7_HIZ,
		HIZA6_LCDC, HIZA6_HIZ,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0 }
	},
	{ PINMUX_CFG_REG("HIZCRB", 0xa405015a, 16, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		HIZB1_VIO, HIZB1_HIZ,
		HIZB0_VIO, HIZB0_HIZ }
	},
	{ PINMUX_CFG_REG("HIZCRC", 0xa405015c, 16, 1) {
		HIZC15_IRQ7, HIZC15_HIZ,
		HIZC14_IRQ6, HIZC14_HIZ,
		HIZC13_IRQ5, HIZC13_HIZ,
		HIZC12_IRQ4, HIZC12_HIZ,
		HIZC11_IRQ3, HIZC11_HIZ,
		HIZC10_IRQ2, HIZC10_HIZ,
		HIZC9_IRQ1, HIZC9_HIZ,
		HIZC8_IRQ0, HIZC8_HIZ,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0 }
	},
	{ PINMUX_CFG_REG("MSELCRB", 0xa4050182, 16, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		MSELB9_VIO, MSELB9_VIO2,
		MSELB8_RGB, MSELB8_SYS,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0 }
	},
	{}
};

static struct pinmux_data_reg pinmux_data_regs[] = {
	{ PINMUX_DATA_REG("PADR", 0xa4050120, 8) {
		PTA7_DATA, PTA6_DATA, PTA5_DATA, PTA4_DATA,
		PTA3_DATA, PTA2_DATA, PTA1_DATA, PTA0_DATA }
	},
	{ PINMUX_DATA_REG("PBDR", 0xa4050122, 8) {
		PTB7_DATA, PTB6_DATA, PTB5_DATA, PTB4_DATA,
		PTB3_DATA, PTB2_DATA, PTB1_DATA, PTB0_DATA }
	},
	{ PINMUX_DATA_REG("PCDR", 0xa4050124, 8) {
		PTC7_DATA, 0, PTC5_DATA, PTC4_DATA,
		PTC3_DATA, PTC2_DATA, 0, PTC0_DATA }
	},
	{ PINMUX_DATA_REG("PDDR", 0xa4050126, 8) {
		PTD7_DATA, PTD6_DATA, PTD5_DATA, PTD4_DATA,
		PTD3_DATA, PTD2_DATA, PTD1_DATA, PTD0_DATA }
	},
	{ PINMUX_DATA_REG("PEDR", 0xa4050128, 8) {
		PTE7_DATA, PTE6_DATA, PTE5_DATA, PTE4_DATA,
		0, 0, PTE1_DATA, PTE0_DATA }
	},
	{ PINMUX_DATA_REG("PFDR", 0xa405012a, 8) {
		0, PTF6_DATA, PTF5_DATA, PTF4_DATA,
		PTF3_DATA, PTF2_DATA, PTF1_DATA, PTF0_DATA }
	},
	{ PINMUX_DATA_REG("PGDR", 0xa405012c, 8) {
		0, 0, 0, PTG4_DATA,
		PTG3_DATA, PTG2_DATA, PTG1_DATA, PTG0_DATA }
	},
	{ PINMUX_DATA_REG("PHDR", 0xa405012e, 8) {
		PTH7_DATA, PTH6_DATA, PTH5_DATA, PTH4_DATA,
		PTH3_DATA, PTH2_DATA, PTH1_DATA, PTH0_DATA }
	},
	{ PINMUX_DATA_REG("PJDR", 0xa4050130, 8) {
		PTJ7_DATA, PTJ6_DATA, PTJ5_DATA, 0,
		0, 0, PTJ1_DATA, PTJ0_DATA }
	},
	{ PINMUX_DATA_REG("PKDR", 0xa4050132, 8) {
		0, PTK6_DATA, PTK5_DATA, PTK4_DATA,
		PTK3_DATA, PTK2_DATA, PTK1_DATA, PTK0_DATA }
	},
	{ PINMUX_DATA_REG("PLDR", 0xa4050134, 8) {
		PTL7_DATA, PTL6_DATA, PTL5_DATA, PTL4_DATA,
		PTL3_DATA, PTL2_DATA, PTL1_DATA, PTL0_DATA }
	},
	{ PINMUX_DATA_REG("PMDR", 0xa4050136, 8) {
		PTM7_DATA, PTM6_DATA, PTM5_DATA, PTM4_DATA,
		PTM3_DATA, PTM2_DATA, PTM1_DATA, PTM0_DATA }
	},
	{ PINMUX_DATA_REG("PNDR", 0xa4050138, 8) {
		PTN7_DATA, PTN6_DATA, PTN5_DATA, PTN4_DATA,
		PTN3_DATA, PTN2_DATA, PTN1_DATA, PTN0_DATA }
	},
	{ PINMUX_DATA_REG("PQDR", 0xa405013a, 8) {
		0, PTQ6_DATA, PTQ5_DATA, PTQ4_DATA,
		PTQ3_DATA, PTQ2_DATA, PTQ1_DATA, PTQ0_DATA }
	},
	{ PINMUX_DATA_REG("PRDR", 0xa405013c, 8) {
		0, 0, 0, PTR4_DATA,
		PTR3_DATA, PTR2_DATA, PTR1_DATA, PTR0_DATA }
	},
	{ PINMUX_DATA_REG("PSDR", 0xa405013e, 8) {
		0, 0, 0, PTS4_DATA,
		PTS3_DATA, PTS2_DATA, PTS1_DATA, PTS0_DATA }
	},
	{ PINMUX_DATA_REG("PTDR", 0xa4050160, 8) {
		0, 0, 0, PTT4_DATA,
		PTT3_DATA, PTT2_DATA, PTT1_DATA, PTT0_DATA }
	},
	{ PINMUX_DATA_REG("PUDR", 0xa4050162, 8) {
		0, 0, 0, PTU4_DATA,
		PTU3_DATA, PTU2_DATA, PTU1_DATA, PTU0_DATA }
	},
	{ PINMUX_DATA_REG("PVDR", 0xa4050164, 8) {
		0, 0, 0, PTV4_DATA,
		PTV3_DATA, PTV2_DATA, PTV1_DATA, PTV0_DATA }
	},
	{ PINMUX_DATA_REG("PWDR", 0xa4050166, 8) {
		0, PTW6_DATA, PTW5_DATA, PTW4_DATA,
		PTW3_DATA, PTW2_DATA, PTW1_DATA, PTW0_DATA }
	},
	{ PINMUX_DATA_REG("PXDR", 0xa4050168, 8) {
		0, PTX6_DATA, PTX5_DATA, PTX4_DATA,
		PTX3_DATA, PTX2_DATA, PTX1_DATA, PTX0_DATA }
	},
	{ PINMUX_DATA_REG("PYDR", 0xa405016a, 8) {
		0, PTY6_DATA, PTY5_DATA, PTY4_DATA,
		PTY3_DATA, PTY2_DATA, PTY1_DATA, PTY0_DATA }
	},
	{ PINMUX_DATA_REG("PZDR", 0xa405016c, 8) {
		0, 0, PTZ5_DATA, PTZ4_DATA,
		PTZ3_DATA, PTZ2_DATA, PTZ1_DATA, PTZ0_DATA }
	},
	{ },
};

static struct pinmux_info sh7722_pinmux_info = {
	.name = "sh7722_pfc",
	.reserved_id = PINMUX_RESERVED,
	.data = { PINMUX_DATA_BEGIN, PINMUX_DATA_END },
	.input = { PINMUX_INPUT_BEGIN, PINMUX_INPUT_END },
	.input_pd = { PINMUX_INPUT_PULLDOWN_BEGIN, PINMUX_INPUT_PULLDOWN_END },
	.input_pu = { PINMUX_INPUT_PULLUP_BEGIN, PINMUX_INPUT_PULLUP_END },
	.output = { PINMUX_OUTPUT_BEGIN, PINMUX_OUTPUT_END },
	.mark = { PINMUX_MARK_BEGIN, PINMUX_MARK_END },
	.function = { PINMUX_FUNCTION_BEGIN, PINMUX_FUNCTION_END },

	.first_gpio = GPIO_PTA7,
	.last_gpio = GPIO_FN_KEYOUT5_IN5,

	.gpios = pinmux_gpios,
	.cfg_regs = pinmux_config_regs,
	.data_regs = pinmux_data_regs,

	.gpio_data = pinmux_data,
	.gpio_data_size = ARRAY_SIZE(pinmux_data),
};

static int __init plat_pinmux_setup(void)
{
	return register_pinmux(&sh7722_pinmux_info);
}

arch_initcall(plat_pinmux_setup);
