#! /usr/bin/perl -w
#                              -*- Mode: Perl -*- 
#
# mkreserve.pl -- Reserved.list 
# Copyright (C) 1999: by FUKUSHIMA Osamu <fuku@amorph.rim.or.jp>
# $Id: mkreserve.pl,v 1.2 2003/03/13 11:32:19 mdk Exp $
# 

use strict;
use DB_File;
use KernelConf qw(:DEFAULT :LOCKS);;

my $reserve_file = "Reserved.list";
my $non_res_word = "";
my @configure = (@ARGV);
my $num_files = @configure;
my $latest    = $configure[$num_files - 1];

my $j;
my @HT;
for ($j = 0; $j < $num_files; $j++) {
  tie(%{$HT[$j]}, 'DB_File', "Mod_$configure[$j].db",
      O_RDONLY, 0644, $DB_BTREE) or die "cant open Mod_$configure[$j].db";
}

my %all_symbols;
foreach my $file (@configure) {
    my $symbols = get_cnflist($file);
    foreach my $key (@$symbols) {
	$all_symbols{$key} = 1;
    }    
}

my $latest_syms = get_cnflist($latest);
my %latest_hash;
foreach my $key (@$latest_syms) {
    $latest_hash{$key} = 1;
}

my @cnf = @$latest_syms;
foreach my $key (sort keys(%all_symbols)) {
    push(@cnf, $key) unless $latest_hash{$key};
}

my $res = {};
open(R, $reserve_file) or die;
while (<R>) {
  next if /^\#/;
  next if /^$/;
  chomp;
  my @w = split;
  $res->{$w[0]} = $w[2] if $w[2];
}
close R;

my $C = {};

foreach my $key (@cnf) {

  my $last_flag = "";
  my $point = 0;
  my @e;

  for ($j = 0; $j < $num_files; $j++) {
    my $e  = " ";
    $e = $HT[$j]{$key} if $HT[$j]{$key};
    
    if ($last_flag) {
      # 2 Ĥʹߤ Config files.

      #  version ̤ä:
      if (($last_flag eq "U") || ($last_flag eq "")) {

	# ⤷ file ǤƤ顢Ϥ version 
	# ʤ줿Ȥˤʤ.
	if ( -r "TRANS-$configure[$j]/$key" ) {
	  $last_flag = "T";
	  $e = "T";
	} else {
	  # file ʤСѤ餺̤Ǥ롣
	  # ⤷status  "-" (same) ʤ顢flag Ѥ餺
	  # ̤ˤʤ.
	  $last_flag = "U";
	  $e = "x" if $e eq "-";
	  $point++;
	}
      } else {
        if ($e eq "*" ) {
	  # ΥСǹ줿
	  if ( -r "TRANS-$configure[$j]/$key" ) {
	    # ⤷ ե뤬СλѤ.
	    $last_flag = "T";
	    $e = "T";
	  } else {
	    # Ǥʤ̤.
	    $last_flag = "U";
	    $point++;
	  }
	}
      }

    } else {
      # ǽ Config file.

      if ( -r "TRANS-$configure[$j]/$key" )  {
	# ⤷ ե뤬СλѤ.
	$last_flag = "T";
	$e = "T";

#      } elsif ($e eq "-"){
	# ⤷ status  "-" (same) ޤ trans-file ʤ顢
	# λѤ.
#	$last_flag = "T";

      }  else {
	# Ǥʤ̤.
	if ($HT[$j]{$key}) {
	  $last_flag = "U";
	  $e = "N";
	  $point++ if $HT[$j]{$key};
	}
      }
      $last_flag = "" unless $e;
    }
    push(@e, $e);
  }
  $C->{$key}->{"stat"} = \@e;
  if ($res->{$key}){
    $C->{$key}->{"reserve"} = "$res->{$key}";
  } else {
    $C->{$key}->{"reserve"} = $non_res_word;
  }
}

foreach my $key (@cnf) {
  my $s = $C->{$key}->{'stat'}->[$num_files -1];
  foreach (@{$C->{$key}->{"stat"}}) {
    $s = "N" if $_ eq "N";  
  }
  $s = "*" if $s eq "x";  
  $s = "T" if ($C->{$key}->{'reserve'} and  $s eq "-");
  $s = "R" if ($C->{$key}->{'reserve'} and ($s eq "N" or $s eq "*"));

  printf("%-40s %-5s%-s\n", 
	 $key, $s,
	 $C->{$key}->{'reserve'});
}

