#! /usr/bin/perl -w

use strict;
use DB_File;
use KernelConf qw(:DEFAULT :LOCKS);;

print "<ul>\n";
foreach (@ARGV) {
  my $archive = "$_.ja.gz";
  next unless -r $archive;
  my @info = stat($archive);
  my $size = int ($info[7] / 1000);
  my %hash;
  my $pt;
  tie(%hash, 'DB_File', "Mod_$_.db",
      O_RDONLY, 0644, $DB_BTREE) or die "cant open Mod_$_.db";

  while (my @v = each %hash) {
    $pt++ unless -r "TRANS-$_/$v[0]";
  }
  print "<li>_LINK($archive,$archive) ($size KB)";
  if ($pt) {
    my @info = stat($archive);
    my ($sec,$min,$hour,$day,$month,$year,$wday,$yday,$isdst) =
      localtime($info[9]);
    $month = $month + 1;
    $month = 1 if $month == 13;
    $month = "0" . $month if $month < 10;
    $day   = "0" . $day if $day < 10;
    $year  += 1900;
    print " ";
    print " ($year-$month-$day)";
  }
  print "</li>\n";
  untie %hash;
} 
print "</ul>\n";
