#! /usr/bin/perl -w
#                              -*- Mode: Perl -*- 
#
# mkmodifydb.pl -- Configure.help ιܥǡ١
# Copyright (C) 1999: by FUKUSHIMA Osamu <fuku@amorph.rim.or.jp>
# Some modification by 2001 GOTO Masanori <gotom@debian.or.jp>
# $Id: mkmodifydb.pl,v 1.4 2002/09/03 10:35:54 mdk Exp $
# 

use Getopt::Std;
use strict;
use vars qw(%opts);
use DB_File;
use KernelConf qw(:DEFAULT :LOCKS);;

my @configure = (@ARGV);
my $num_files = @configure;
my $latest    = $configure[$num_files - 1];

my $verbose = 0;
$|          = 1;

my $md5_table = {};
my $CONFIG_LIST = {};
foreach my $c (@configure) {
  print "$c " if $verbose;
  $CONFIG_LIST->{$c} = splitconf($c, "CONFIG-$c");
  my %MD5_HASH = getmd5($CONFIG_LIST->{$c}, "CONFIG-$c", $verbose);
  $md5_table->{$c} = {%MD5_HASH}; 
  print " done.\n" if $verbose;
}

my $j;
for ($j = 0; $j < $num_files; $j++) {
  my $old_version = $j - 1;
     $old_version = $j if $j == 0;
  print "making DB for $configure[$j]...\n";
  my ($e, $p) =
    compare(\$CONFIG_LIST->{$configure[$j]}, 
	    \$md5_table->{$configure[$j]},
	    \$md5_table->{$configure[$old_version]});

  my %hash;
  unlink "Mod_$configure[$j].db";
  tie(%hash, 'DB_File', "Mod_$configure[$j].db",
      O_RDWR|O_CREAT, 0644, $DB_BTREE) or die;
  %hash = %$p;
  untie %hash;
}

# EOF
