/*
 * LyricHandle.java
 * Copyright (c) 2008 kbinani
 *
 * This file is part of jp.sourceforge.lipsync.vsq.
 *
 * jp.sourceforge.lipsync.vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * jp.sourceforge.lipsync.vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package jp.sourceforge.lipsync.vsq;

public class LyricHandle extends VsqHandle implements Cloneable {
    public LyricHandle() {
    }


    /// <summary>
    /// type = Lyric用のhandleのコンストラクタ
    /// </summary>
    /// <param name="phrase">歌詞</param>
    /// <param name="phonetic_symbol">発音記号</param>
    public LyricHandle( String phrase, String phonetic_symbol ) {
        Type = VsqHandleType.Lyric;
        L0 = new Lyric( phrase, phonetic_symbol );
    }

    /*public property Lyric L0 {
    get {
    return m_lyric;
    }
    set {
    m_lyric = value;
    }
    }*/
    public Object clone() {
        LyricHandle ret = new LyricHandle();
        ret.Type = Type;
        ret.Index = Index;
        ret.L0 = (Lyric)L0.clone();
        return ret;
    }

}
