/*
 * MidiEvent.java
 * Copyright (c) 2008 kbinani
 *
 * This file is part of jp.sourceforge.lipsync.vsq.
 *
 * jp.sourceforge.lipsync.vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * jp.sourceforge.lipsync.vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package jp.sourceforge.lipsync.vsq;

public class MidiEvent implements Comparable<MidiEvent>, Cloneable {
    public int index;
    public MidiEventType type;
    public int[] intValue;
    public String stringValue;
    public byte[] byteValue;

    public static MidiEvent TempoChange( int clock, int tempo ) {
        MidiEvent res = new MidiEvent();
        res.index = clock;
        res.type = MidiEventType.tempo;
        res.intValue = new int[1];
        res.intValue[0] = tempo;
        return res;
    }

    public static MidiEvent TimeSig( int clock, int numerator, int denominator ) {
        MidiEvent res = new MidiEvent();
        res.index = clock;
        res.type = MidiEventType.time_signal;
        res.intValue = new int[2];
        res.intValue[0] = numerator;
        res.intValue[1] = denominator;
        return res;
    }

    public Object clone() {
        MidiEvent res = new MidiEvent();
        res.index = index;
        res.type = type;
        if ( intValue != null ) {
            res.intValue = new int[intValue.length];
            for ( int i = 0; i < intValue.length; i++ ) {
                res.intValue[i] = intValue[i];
            }
        }
        res.stringValue = stringValue;
        if ( byteValue != null ) {
            res.byteValue = new byte[byteValue.length];
            for ( int i = 0; i < byteValue.length; i++ ) {
                res.byteValue[i] = byteValue[i];
            }
        }
        return res;
    }

    public int compareTo( MidiEvent obj ) {
        return this.index - obj.index;
    }

    public boolean Equals( MidiEvent obj ) {
        if ( this.index == obj.index ) {
            return true;
        } else {
            return false;
        }
    }

    private MidiEvent() {
    }

    /**
     * かきかけ。メタテキスト以外のmidiイベントを取り扱う。
     * @param line 
     */
    public MidiEvent( String line ) {
        index = -1;
        type = MidiEventType.unknown;
        //intValue = new int[1];
        //intValue[0] = -9000;
        stringValue = "";
        byteValue = null;

        String[] spl = line.split( " " );
        index = Integer.parseInt( spl[0] );
        if ( spl[1].equals( "Tempo" ) ) {
            type = MidiEventType.tempo;
            intValue = new int[1];
            intValue[0] = Integer.parseInt( spl[2] );
        } else if ( spl[1].equals( "TimeSig" ) ) {
            type = MidiEventType.time_signal;
            intValue = new int[4];
            String[] spl2 = spl[2].split( "/" );
            intValue[0] = Integer.parseInt( spl2[0] );
            intValue[1] = Integer.parseInt( spl2[1] );
            intValue[2] = Integer.parseInt( spl[3] );
            intValue[3] = Integer.parseInt( spl[4] );
        } else if ( spl[1].equals( "Par" ) ) {
            type = MidiEventType.parameter;
            intValue = new int[3];
            String[] spl3 = spl[2].split( "=" );
            intValue[0] = Integer.parseInt( spl3[1] );
            spl3 = spl[3].split( "=" );
            intValue[1] = Integer.parseInt( spl3[1] );
            spl3 = spl[4].split( "=" );
            intValue[2] = Integer.parseInt( spl3[1] );
        } else {
            type = MidiEventType.unknown;
            stringValue = spl[2];
            for ( int i = 1; i < spl.length; i++ ) {
                stringValue += " " + spl[i];
            }
        }

    }

}
