/*
 * SMFReader.java
 * Copyright (c) 2008 kbinani
 *
 * This file is part of jp.sourceforge.lipsync.vsq.
 *
 * jp.sourceforge.lipsync.vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * jp.sourceforge.lipsync.vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package jp.sourceforge.lipsync.vsq;
import java.util.*;
/// <summary>
    /// SMFファイルを解析し、テキストファイル形式のデータに変換します
    /// </summary>
    public class SMFReader {
        //private StreamReader sr = null;

        private MidiFile m_midi = null;
        //private String _result = "";
        private Vector<String> m_lines;

        /// <summary>
        /// デフォルトコンストラクタ。コンストラクトと同時に解析を行い、指定されたファイルに結果を格納します。
        /// </summary>
        /// <param name="_path">解析対象のファイルへのパス</param>
        public SMFReader( String _path ) {
            //_result = Path.GetTempFileName();
            m_midi = new MidiFile( _path );//, _result, Mode.Read );
            //sr = new StreamReader( _result );
            m_lines = new Vector<String>();
            String[] splitted = m_midi.ReadToEnd().split( "\n" );
            for( int i = 0; i < splitted.length; i++ ){
                String spl = splitted[i];
                m_lines.add( spl );
            }
        }

        public void dispose() {
            m_midi.close();
        }

        public Vector<String> getLines() {
                return m_lines;
        }

}