/*
 * BPPair.java
 * Copyright (c) 2008 kbinani
 *
 * This file is part of jp.sourceforge.lipsync.vsq.
 *
 * jp.sourceforge.lipsync.vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * jp.sourceforge.lipsync.vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package jp.sourceforge.lipsync.vsq;

public class TimeSigTableEntry implements Comparable<TimeSigTableEntry>, Cloneable {
    //int m_clock;
    public int Clock;
    //int m_numerator;
    public int Numerator;
    //int m_denominator;
    public int Denominator;
    //int m_bar_count;
    public int BarCount;

    public Object clone() {
        return new TimeSigTableEntry( Clock, Numerator, Denominator, BarCount );
    }

    public int compareTo( TimeSigTableEntry item ) {
        return this.BarCount - item.BarCount;
    }


    /*// <summary>
    /// クロック数
    /// </summary>
    public property int Clock {
    get {
    return m_clock;
    }
    set {
    m_clock = value;
    }
    };*/
    /*// <summary>
    /// 拍子の分母
    /// </summary>
    public property int Numerator {
    get {
    return m_numerator;
    }
    set {
    m_numerator = value;
    }
    };*/
    /*// <summary>
    /// 拍子の分母
    /// </summary>
    public property int Denominator {
    get {
    return m_denominator;
    }
    set {
    m_denominator = value;
    }
    };*/
    /*// <summary>
    /// Clockの時点で何小節目かを取得します。
    /// </summary>
    public property int BarCount {
    get {
    return m_bar_count;
    }
    set {
    m_bar_count = value;
    }
    };*/
    public TimeSigTableEntry(
            int clock,
            int numerator,
            int denominator,
            int bar_count ) {
        Clock = clock;
        Numerator = numerator;
        Denominator = denominator;
        BarCount = bar_count;
    }

}
