﻿/*
 * FontConfig.cs
 * Copyright (c) 2007-2010 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Drawing;

namespace LipSync {

    /// <summary>
    /// フォントの設定値をXmlSerializerで"美しく"格納するためのクラス
    /// </summary>
    public class FontConfig : ICloneable{
        string m_font_family;
        FontStyle m_font_style;
        float m_font_size;
        Font m_font = null;

        public string Family {
            get {
                return m_font_family;
            }
            set {
                m_font_family = value;
            }
        }

        public string Style {
            get {
                return m_font_style + "";
            }
            set {
                m_font_style = (FontStyle)System.Enum.Parse( typeof( FontStyle ), value );
            }
        }

        public float Size {
            get {
                return m_font_size;
            }
            set {
                m_font_size = value;
            }
        }

        public FontConfig() {
            m_font_family = "MS UI Gothic";
            m_font_style = FontStyle.Regular;
            m_font_size = 18;
        }

        public FontConfig( Font value ) {
            m_font_family = value.FontFamily.Name;
            m_font_style = value.Style;
            m_font_size = value.Size;
        }

        public FontConfig( string family, float size ) {
            m_font_family = family;
            m_font_size = size;
            m_font_style = FontStyle.Regular;
        }

        public Font GetFont() {
            if ( m_font == null ) {
                m_font = new Font( m_font_family, m_font_size, m_font_style );
            }
            return m_font;
        }

        public object Clone() {
            FontConfig ret = new FontConfig();
            ret.m_font_family = m_font_family;
            ret.m_font_size = m_font_size;
            ret.m_font_style = m_font_style;
            return ret;
        }
    }

}
