﻿/*
 * IDrawObject.cs
 * Copyright (c) 2009-2010 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Drawing;
using System.ComponentModel;

namespace LipSync {

    public interface IDrawObject {
        [Browsable( false )]
        int ZOrder {
            get;
            set;
        }

        bool PositionFixed {
            get;
            set;
        }

        PointF GetPosition( float time );

        float GetScale( float time );

        float GetAlpha( float time );

        float GetRotate( float time );

        bool IsXFixedAt( float time );

        bool IsYFixedAt( float time );

        Size ImageSize {
            get;
        }
    }

}
