﻿/*
 * PluginConfig.cs
 * Copyright (c) 2007-2010 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;

namespace LipSync {

    [Serializable]
    public class PluginConfig {
        public string ID;
        public string Config;
        public PluginConfig() {
            ID = "";
            Config = "";
        }
        public PluginConfig Clone() {
            return new PluginConfig( ID, Config );
        }
        public PluginConfig( string name, string config, string filename ) {
            ID = name + "@" + filename;
            Config = config;
        }
        public PluginConfig( string id, string config ) {
            ID = id;
            Config = config;
        }
    }

}
