﻿/*
 * PositionConverter.cs
 * Copyright (c) 2007-2010 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.ComponentModel;

namespace LipSync {

    public class PositionConverter : ExpandableObjectConverter {
        //コンバータがオブジェクトを指定した型に変換できるか
        //（変換できる時はTrueを返す）
        //ここでは、CustomClass型のオブジェクトには変換可能とする
        public override bool CanConvertTo( ITypeDescriptorContext context, Type destinationType ) {
            if ( destinationType == typeof( Position ) ) {
                return true;
            }
            return base.CanConvertTo( context, destinationType );
        }

        //指定した値オブジェクトを、指定した型に変換する
        //CustomClass型のオブジェクトをString型に変換する方法を提供する
        public override object ConvertTo( ITypeDescriptorContext context, System.Globalization.CultureInfo culture, object value, Type destinationType ) {
            if ( destinationType == typeof( string ) && value is Position ) {
                Position cc = (Position)value;
                return cc.X + ", " + cc.Y;
            }
            return base.ConvertTo( context, culture, value, destinationType );
        }

        //コンバータが特定の型のオブジェクトをコンバータの型に変換できるか
        //（変換できる時はTrueを返す）
        //ここでは、String型のオブジェクトなら変換可能とする
        public override bool CanConvertFrom( ITypeDescriptorContext context, Type sourceType ) {
            if ( sourceType == typeof( string ) ) {
                return true;
            }
            return base.CanConvertFrom( context, sourceType );
        }

        //指定した値をコンバータの型に変換する
        //String型のオブジェクトをCustomClass型に変換する方法を提供する
        public override object ConvertFrom( ITypeDescriptorContext context, System.Globalization.CultureInfo culture, object value ) {
            if ( value is string ) {
                string[] ss = value.ToString().Split( new char[] { ',' }, 2 );
                Position cc = new Position( 0f, 0f );
                try {
                    cc.X = float.Parse( ss[0] );
                    cc.Y = float.Parse( ss[1] );
                } catch {
                }
                return cc;
            }
            return base.ConvertFrom( context, culture, value );
        }
    }

}
