/*
 * SetSize.cs
 * Copyright (c) 2007-2010 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Drawing;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Reflection;

using Boare.Lib.AppUtil;

namespace LipSync {

    public partial class SetSize<T> : Form, IMultiLanguageControl {
        private T x;
        private T y;
        private MethodInfo m_parse_method_info = null;

        public SetSize( string dialog_title, string title_x, string title_y, T def_x, T def_y ) {
            Assembly a = Assembly.GetAssembly( typeof( T ) );
            Type[] ts = a.GetTypes();
            bool found = false;
            foreach ( Type t in ts ) {
                if ( t.Equals( typeof( T ) ) ) {
                    MethodInfo[] mis = t.GetMethods();
                    foreach ( MethodInfo mi in mis ) {
                        if ( mi.ReturnType.Equals( typeof( T ) ) && mi.Name == "Parse" && mi.IsStatic && mi.IsPublic ) {
                            ParameterInfo[] pis = mi.GetParameters();
                            if ( pis.Length == 1 ) {
                                if ( pis[0].ParameterType.Equals( typeof( string ) ) ) {
                                    m_parse_method_info = mi;
                                    found = true;
                                    break;
                                }
                            }
                        }
                    }
                    if ( found ) {
                        break;
                    }
                }
            }
            if ( !found ) {
                throw new NotSupportedException( "generic type T must support 'public static T Parse( string ){...}' method" );
            }
            InitializeComponent();
            ApplyFont( AppManager.Config.Font.GetFont() );
            label1.Text = title_x;
            label2.Text = title_y;
            txtHeight.Text = def_y.ToString();
            txtWidth.Text = def_x.ToString();
            x = def_x;
            y = def_y;
            this.Text = dialog_title;
        }

        public void ApplyLanguage() {
            this.btnCancel.Text = _( "Cancel" );
            this.btnOK.Text = _( "OK" );
        }

        public void ApplyFont( Font font ) {
            this.Font = font;
            foreach ( Control c in this.Controls ) {
                Boare.Lib.AppUtil.Util.applyFontRecurse( c, font );
            }
        }

        public static string _( string s ) {
            return Messaging.getMessage( s );
        }

        public T ResultWidth {
            get {
                return x;
            }
        }

        public T ResultHeight {
            get {
                return y;
            }
        }

        public string Title {
            get {
                return this.Text;
            }
            set {
                this.Text = value;
            }
        }

        private void btnOK_Click( object sender, EventArgs e ) {
            T xx = x;
            T yy = y;
            try {
                xx = (T)m_parse_method_info.Invoke( typeof( T ), new object[]{ txtWidth.Text } );
                yy = (T)m_parse_method_info.Invoke( typeof( T ), new object[]{ txtHeight.Text } );
            } catch {
                MessageBox.Show(
                    _( "Invalid value has been entered" ),
                    _( "Error" ),
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Exclamation );
                xx = x;
                yy = y;
                return;
            } finally {
                x = xx;
                y = yy;
            }
            this.DialogResult = DialogResult.OK;
            this.Close();
        }

        private void btnCancel_Click( object sender, EventArgs e ) {
            this.DialogResult = DialogResult.Cancel;
            this.Close();
        }
    }

}
