﻿/*
 * TimeTableEntry.cs
 * Copyright (c) 2007-2010 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;

namespace LipSync {

    [Serializable]
    public class TimeTableEntry : IComparable<TimeTableEntry>, IDisposable, ICloneable {
        public float begin;
        public float end;
        public string body;

        public TimeTableEntry() {
            begin = 0.0f;
            end = 0.0f;
            body = "";
        }

        public float Length {
            get {
                return end - begin;
            }
        }

        public void Dispose() {
            this.body = null;
        }

        public object Clone() {
            return new TimeTableEntry( begin, end, body );
        }

        public int CompareTo( TimeTableEntry obj ) {
            double diff = this.begin - obj.begin;
            if ( this.begin == obj.begin ) {
                return 0;
            } else if ( diff > 0.0f ) {
                return 1;
            } else {
                return -1;
            }
        }

        public bool Equals( TimeTableEntry obj ) {
            if ( this.begin == obj.begin ) {
                return true;
            } else {
                return false;
            }
        }

        public TimeTableEntry( float begin, float end, string body ) {
            this.begin = begin;
            this.end = end;
            this.body = body;
        }
    }

}
