﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

using Boare.Lib.AppUtil;

namespace Boare {
    class lang2po {
        static void Main( string[] args ) {
            Console.WriteLine( "input source *.lang file name" );
            string name = Console.ReadLine();
            Console.WriteLine( "input result file name" );
            string result = Console.ReadLine();
            if ( File.Exists( result ) ) {
                Console.WriteLine( "error; file \"" + result + "\" already exists." );
                return;
            }
            Messaging.appendFromFile( "template.po" );
            Messaging.setLanguage( "template" );
            Dictionary<string, string> dict = new Dictionary<string, string>();
            using ( StreamReader sr = new StreamReader( name ) ) {
                string line;
                while ( (line = sr.ReadLine()) != null ) {
                    string[] spl = line.Split( "\t".ToCharArray() );
                    if ( spl.Length >= 2 ) {
                        string id = spl[0];
                        string item = spl[1];
                        item = item.Replace( "\"", "\\\"" );
                        dict.Add( id, item );
                    }
                }
            }
            using ( StreamWriter sw = new StreamWriter( result, false, Encoding.UTF8 ) ) {
                sw.WriteLine( "msgid \"\"" );
                sw.WriteLine( "msgstr \"\"" );
                sw.WriteLine( "\"Project-Id-Version: \\n\"" );
                sw.WriteLine( "\"Report-Msgid-Bugs-To: \\n\"" );
                DateTime now = DateTime.Now;
                DateTime utc = now.ToUniversalTime();
                DateTime local = now.ToLocalTime();
                TimeSpan ts = local.Subtract( utc );
                int minutes = (int)ts.TotalMinutes;
                int absmin = Math.Abs( minutes );
                int hours = absmin / 60;
                int mins = absmin - hours * 60;
                string dt = (minutes > 0) ? "+" : "-";
                dt += hours.ToString( "00" ) + mins.ToString( "00" );
                sw.WriteLine( "\"POT-Creation-Date: " + local.Year + "-" + local.Month.ToString( "00" ) + "-" + local.Day.ToString( "00" ) + " " + local.Hour.ToString( "00" ) + ":" + local.Minute.ToString( "00" ) + dt + "\\n\"" );
                sw.WriteLine( "\"PO-Revision-Date: \\n\"" );
                sw.WriteLine( "\"Last-Translator: \\n\"" );
                sw.WriteLine( "\"Language-Team: \\n\"" );
                sw.WriteLine( "\"MIME-Version: 1.0\\n\"" );
                sw.WriteLine( "\"Content-Type: text/plain; charset=UTF-8\\n\"" );
                sw.WriteLine( "\"Content-Transfer-Encoding: 8bit\\n\"" );
                sw.WriteLine( "\"X-Poedit-Language: \\n\"" );
                sw.WriteLine( "\"X-Poedit-Country: \\n\"" );
                sw.WriteLine( "\"X-Poedit-SourceCharset: utf-8\\n\"" );
                sw.WriteLine( "\"X-Poedit-Basepath: .\\\\" + "\\n\"" );
                sw.WriteLine( "\"X-Poedit-KeywordsList: _\\n\"" );
                sw.WriteLine( "\"X-Poedit-SearchPath-0: Editor\\n\"" );
                sw.WriteLine( "\"X-Poedit-SearchPath-1: Common\\n\"" );
                sw.WriteLine( "\"X-Poedit-SearchPath-2: AviFile\\n\"" );
                string[] keys = Messaging.getKeys( "template" );
                foreach ( string key in keys ) {
                    string oldid = Messaging.getMessage( key );
                    if ( dict.ContainsKey( oldid ) ) {
                        string item = dict[oldid];
                        item = item.Replace( "\"", "\\\"" );
                        string key2 = key.Replace( "\"", "\\\"" );
                        sw.WriteLine( "msgid \"" + key2 + "\"" );
                        sw.WriteLine( "msgstr \"" + item + "\"" );
                        sw.WriteLine();
                    }
                }
            }
        }
    }
}
