/**
 * @file  ShellContextMenu.cpp
 * @brief Windows VF̃ReLXgj[.
 *
 * @author JIN
 *
 * Copyright (C) 2011- JIN All rights reserved.
 */
#include "StdAfx.h"
#include "ShellContextMenu.h"

namespace GenericUtility {

	CShellContextMenu::CShellContextMenu()
		: m_hWnd(NULL)
		, m_idCmdFirst(0)
		, m_idCmdLast(0)
	{
	}

	CShellContextMenu::~CShellContextMenu()
	{
	}

	bool CShellContextMenu::Initialize(HWND hWnd, LPCTSTR lpszPath)
	{
		Terminate();

#if 1
		// HACK: ::SHParseDisplayName()  Windows 2000 ŎgȂ̂ŁAꉞ Desktop oRŎ擾Ă
		CComPtr<IShellFolder> spDesktop;
		if (FAILED(::SHGetDesktopFolder(&spDesktop))) {
			return false;
		}
		ASSERT(spDesktop);

		// ITEMIDLIST 擾
		CAutoCoTaskMem<ITEMIDLIST> pidl;
		if (FAILED(spDesktop->ParseDisplayName(hWnd, NULL, CT2W(lpszPath), NULL, &pidl, NULL))) {
			return false;
		}
		ASSERT(pidl);
#else
		// ITEMIDLIST 擾
		CAutoCoTaskMem<ITEMIDLIST> pidl;
		if (FAILED(::SHParseDisplayName(CT2W(lpszPath), NULL, &pidl, 0, NULL))) {
			return false;
		}
		ASSERT(pidl);
#endif

		// e IShellFolder 擾
		CComPtr<IShellFolder> spParent;
		if (FAILED(::SHBindToParent(pidl, IID_PPV_ARGS(&spParent), NULL))) {
			return false;
		}
		ASSERT(spParent);

		// pX̖[ (t@CȂt@C) 擾
		LPITEMIDLIST pidlChild = ILFindLastID(pidl);
		if (!pidlChild) {
			return false;
		}

		// IContextMenu 擾
		if (FAILED(spParent->GetUIObjectOf(hWnd, 1, (PCUITEMID_CHILD_ARRAY)&pidlChild, IID_IContextMenu, NULL, (void**)&m_spContextMenu))) {
			return false;
		}
		ASSERT(m_spContextMenu);

		m_hWnd = hWnd;
		m_spContextMenu2 = m_spContextMenu;
		return true;
	}

	void CShellContextMenu::Terminate()
	{
		m_hWnd = NULL;
		m_spContextMenu.Release();
		m_spContextMenu2.Release();
		m_idCmdFirst = 0;
		m_idCmdLast  = 0;
	}

	bool CShellContextMenu::QueryContextMenu(
		HMENU hmenu, UINT indexMenu, UINT idCmdFirst, UINT idCmdLast, UINT uFlags)
	{
		m_idCmdFirst = 0;
		m_idCmdLast  = 0;

		if (!m_spContextMenu) {
			return false;
		}

		if (FAILED(m_spContextMenu->QueryContextMenu(hmenu, indexMenu, idCmdFirst, idCmdLast, uFlags))) {
			return false;
		}

		m_idCmdFirst = idCmdFirst;
		m_idCmdLast  = idCmdLast;

		return true;
	}

	bool CShellContextMenu::InvokeCommand(UINT nID)
	{
		if (!m_spContextMenu) {
			return false;
		}
		// ܂ QueryContextMenu() sĂȂ
		if (m_idCmdFirst == 0 || m_idCmdLast == 0) {
			return false;
		}
		// QueryContextMenu() ŒǉR}hł͂Ȃ
		if (nID < m_idCmdFirst || m_idCmdLast < nID) {
			return false;
		}

		CMINVOKECOMMANDINFO info = { sizeof(CMINVOKECOMMANDINFO) };
		info.hwnd   = m_hWnd;
		info.lpVerb = MAKEINTRESOURCEA(nID - m_idCmdFirst);
		info.nShow  = SW_SHOWNORMAL;

		// R}hs
		if (FAILED(m_spContextMenu->InvokeCommand(&info))) {
			return false;
		}

		return true;
	}

	bool CShellContextMenu::HandleMenuMsg(MSG* pMsg)
	{
		// HACK: IContextMenu2::HandleMenuMsg() ̎ssȊÓAtrue Ԃ
		if (!pMsg) {
			return true;
		}
		if (!m_spContextMenu2) {
			return true;
		}

		return SUCCEEDED(m_spContextMenu2->HandleMenuMsg(pMsg->message, pMsg->wParam, pMsg->lParam));
	}

}	// namespace GenericUtility
