/**
 * @file  ChangeFontSize.cpp
 * @brief UI Iy[VɂătHgTCYύX֐.
 *
 * @author JIN
 *
 * Copyright (C) 2011- JIN All rights reserved.
 */
#include "stdafx.h"
#include "ChangeFontSize.h"

namespace DialogUtility {
	namespace {

		template <typename T1, typename T2>
		void IncrementAbs(T1& n, T2 d)
		{
			if (n > 0)
				n += d;
			else if (n < 0)
				n -= d;
		}

		/**
		 * EBhE LogFont 擾.
		 */
		BOOL GetLogFont(CWnd* pWnd, LOGFONT& logfont)
		{
			if (!pWnd) {
				return FALSE;
			}

			CFont* pFont = pWnd->GetFont();
			if (!pFont) {
				return FALSE;
			}

			return pFont->GetLogFont(&logfont);
		}
		/**
		 * EBhE LogFont ݒ肷.
		 */
		BOOL SetLogFont(CWnd* pWnd, const LOGFONT& logfont)
		{
			if (!pWnd) {
				return FALSE;
			}

			CFont* pNewFont = new CFont;
			if (!pNewFont) {
				return FALSE;
			}
			if (!pNewFont->CreateFontIndirect(&logfont)) {
				return FALSE;
			}

			pWnd->SetFont(pNewFont);

			return TRUE;
		}

		/**
		 * tHgTCYύX.
		 */
		BOOL ChangeFontSize(LOGFONT& logfont, short zDelta)
		{
			BOOL bExpand = (zDelta > 0);
			static const double SCALE_RATIO = 1.2;
			double ratio = bExpand ? SCALE_RATIO : 1.0 / SCALE_RATIO;
			LONG lfNewHeight = static_cast<LONG>(logfont.lfHeight * ratio);

			if (lfNewHeight == logfont.lfHeight) {
				IncrementAbs(lfNewHeight, bExpand ? 1 : -1);
			}

			static const LONG MAX_FONT_SIZE = 72;
			static const LONG MIN_FONT_SIZE = 4;
			int fontsize = abs(lfNewHeight);
			if (fontsize < MIN_FONT_SIZE || MAX_FONT_SIZE < fontsize) {
				return FALSE;
			}

			logfont.lfHeight = lfNewHeight;
			logfont.lfWidth = 0;

			return TRUE;
		}

	}	// anonymous namespace

	BOOL ChangeFontSize(CWnd* pWnd, bool expand)
	{
		if (!pWnd) {
			return FALSE;
		}

		LOGFONT logfont;
		if (!GetLogFont(pWnd, logfont)) {
			return FALSE;
		}

		if (!ChangeFontSize(logfont, expand ? 120 : -120)) {
			return FALSE;
		}

		if (!SetLogFont(pWnd, logfont)) {
			return FALSE;
		}

		return TRUE;
	}

	BOOL ChangeFontSizeByMouseWheel(CWnd* pWnd, UINT nFlags, short zDelta, CPoint pt)
	{
		if (!pWnd) {
			return FALSE;
		}

		pWnd->ScreenToClient(&pt);
		CRect rect;
		pWnd->GetClientRect(rect);
		if (!rect.PtInRect(pt)) {
			return FALSE;
		}

		if (nFlags != MK_CONTROL) {
			return FALSE;
		}

		LOGFONT logfont;
		if (!GetLogFont(pWnd, logfont)) {
			return FALSE;
		}

		if (!ChangeFontSize(logfont, zDelta)) {
			return FALSE;
		}

		if (!SetLogFont(pWnd, logfont)) {
			return FALSE;
		}

		return TRUE;
	}

}	// namespace DialogUtility
