/**
 * @file  DelayedExecutionDialog.h
 * @brief xs_CAO̊{NX.
 *
 * @author JIN
 *
 * Copyright (C) 2009- JIN All rights reserved.
 */
#pragma once

#include "MessageMap.h"

namespace Dialog {

/////////////////////////////////////////////////////////////////////////////
/**
 * xs_CAO̊{NX.
 */
template <class BaseClass_>
class CDelayedExecutionDialog : public BaseClass_
{
public:
	CDelayedExecutionDialog()
		: TIMER_ID(0), m_nTimerID(0)
	{
	}
	CDelayedExecutionDialog(int nID)
		: BaseClass_(nID)
		, TIMER_ID(0), m_nTimerID(0)
	{
	}
	CDelayedExecutionDialog(int nID, CWnd* pWnd)
		: BaseClass_(nID, pWnd)
		, TIMER_ID(0), m_nTimerID(0)
	{
	}
	~CDelayedExecutionDialog()
	{
		InitializeDelayedExecution(1 /* dummy */);
	}

	/**
	 * .
	 */
	void InitializeDelayedExecution(UINT_PTR nTimerID)
	{
		// V^C}[ ID
		ASSERT(nTimerID != 0);
		TIMER_ID = nTimerID;

		// ̃^C}[
		if (m_nTimerID != 0) {
			VERIFY(KillTimer(m_nTimerID));
			m_nTimerID = 0;
		}

		// xs֐}bvNA
		m_ExecutorMap.clear();

		// xsׂxs֐̃CfbNXNA
		m_IndexSet.clear();
	}

	/// xs֐
	typedef boost::function<void()> ExecutorFunc;
	/**
	 * xs֐o^.
	 * ̂̂͏㏑.
	 * @note xs͐ݒ肳Ȃ. ʓr SetDelayedExecution() sKv.
	 */
	void SetDelayedExecutor(int nIndex, ExecutorFunc executor)
	{
		// xs֐o^
		m_ExecutorMap[nIndex] = executor;
	}

	/**
	 * xsݒ肷.
	 * xs^C}[́AVlŃZbg.
	 * w莞ԌoߌAxsݒ肳Ă邷ׂĂ̂̂CfbNXɎs.
	 */
	bool SetDelayedExecution(int nIndex, UINT nDelay)
	{
		// (ĂȂ΂ȂȂ)
		ASSERT(TIMER_ID != 0);
		if (TIMER_ID == 0)
			return false;

		// (xs֐o^Ă͂)
		ASSERT(m_ExecutorMap.find(nIndex) != m_ExecutorMap.end());

		// xsׂxs֐̃CfbNXݒ肷
		m_IndexSet.insert(nIndex);

		// VɃ^C}[ݒ肷
		m_nTimerID = SetTimer(TIMER_ID, nDelay, NULL);

		ASSERT(m_nTimerID != 0);
		return m_nTimerID != 0;
	}

	/**
	 * xs.
	 */
	void ResetDelayedExecution(int nIndex)
	{
		// ^C}[ZbgĂȂ
		if (!m_nTimerID) {
			// łɋ̂͂
			ASSERT(m_IndexSet.empty());
			return;
		}

		// xsׂxs֐̃CfbNX
		m_IndexSet.erase(nIndex);

		// 폜ʁAɂȂ
		if (m_IndexSet.empty()) {
			// ^C}[
			VERIFY(KillTimer(m_nTimerID));
			m_nTimerID = 0;
		}
	}

protected:
	BEGIN_MESSAGE_MAP_INLINE(CDelayedExecutionDialog, BaseClass_)
		ON_WM_TIMER()
	END_MESSAGE_MAP()

	afx_msg void OnTimer(UINT_PTR nIDEvent)
	{
		if (m_nTimerID == nIDEvent) {
			// ^C}[
			// HACK: xs֐̎sɂ܂ WM_TIMER ̂h߂ɁA܂
			VERIFY(KillTimer(m_nTimerID));
			m_nTimerID = 0;

			// sO m_IndexSet NA邽߁A[Jϐ swap 
			IndexSet indexSet;
			indexSet.swap(m_IndexSet);

			for (IndexSet::iterator itIndex = indexSet.begin(); itIndex != indexSet.end(); ++itIndex) {
				// xsׂxs֐̃CfbNX
				int nIndex = *itIndex;

				// xs֐
				ExecutorMap::const_iterator itMap = m_ExecutorMap.find(nIndex);
				// (o^Ă͂)
				ASSERT(itMap != m_ExecutorMap.end());
				if (itMap != m_ExecutorMap.end()) {
					// xs֐
					const ExecutorFunc& executor = itMap->second;
					ASSERT(executor);
					if (executor) {
						// xs֐s
						executor();
					}
				}
			}
		}

		BaseClass_::OnTimer(nIDEvent);
	}

private:
	/// xsp^C}[ ID (ݒ肷).
	UINT_PTR TIMER_ID;
	/// xsp^C}[ ID (ݒ肳ꂽ).
	UINT_PTR m_nTimerID;

	/// xs֐}bv
	typedef std::map<int /* CfbNX */, ExecutorFunc> ExecutorMap;
	/// xs֐}bv
	ExecutorMap m_ExecutorMap;

	typedef std::set<int /* CfbNX */> IndexSet;
	/// xsׂxs֐̃CfbNX
	IndexSet m_IndexSet;
};

}	// namespace Dialog
