/**
 * @file  WaitableHandle.cpp
 * @brief WaitForSingleObject() łnh̃bpNX.
 *
 * @author JIN
 *
 * Copyright (C) 2004- JIN All rights reserved.
 */
#include "stdafx.h"
#include "WaitableHandle.h"
#include "MiscUtil.h"

namespace GenericUtility {

/////////////////////////////////////////////////////////////////////////////
CWaitableHandle::CWaitableHandle(HANDLE hHandle) : m_hHandle(hHandle)
{
	ASSERT(m_hHandle);
}

CWaitableHandle::~CWaitableHandle()
{
}

bool CWaitableHandle::IsSet() const
{
	ASSERT(m_hHandle);
	return m_hHandle && ::WaitForSingleObject(m_hHandle, 0) == WAIT_OBJECT_0;
}

bool CWaitableHandle::Wait() const
{
	ASSERT(m_hHandle);
	return m_hHandle && ::WaitForSingleObject(m_hHandle, INFINITE) == WAIT_OBJECT_0;
}

CWaitableHandle::operator HANDLE() const
{
	return m_hHandle;
}

int CWaitableHandle::Wait(const CWaitableHandle& handle1, const CWaitableHandle& handle2)
{
	HANDLE hHandles[] = { handle1, handle2 };
	DWORD dwRet = ::WaitForMultipleObjects(ARRAY_SIZE(hHandles), hHandles, FALSE, INFINITE);
	ASSERT(dwRet == WAIT_OBJECT_0 || dwRet == WAIT_OBJECT_0 + 1);
	if (!(dwRet == WAIT_OBJECT_0 || dwRet == WAIT_OBJECT_0 + 1))
		return -1;
	return dwRet - WAIT_OBJECT_0;
}

/////////////////////////////////////////////////////////////////////////////
CEvent::CEvent() : CWaitableHandle(::CreateEvent(NULL, TRUE, FALSE, NULL))
{
}

CEvent::~CEvent()
{
	if (m_hHandle) {
		VERIFY(::CloseHandle(m_hHandle));
	}
}

bool CEvent::Set()
{
	ASSERT(m_hHandle);
	return m_hHandle && ::SetEvent(m_hHandle) ? true : false;
}

bool CEvent::Reset()
{
	ASSERT(m_hHandle);
	return m_hHandle && ::ResetEvent(m_hHandle) ? true : false;
}

}	// namespace GenericUtility
