/**
 * bool_list - boolean list.
 *
 * MIT License
 * Copyright (C) 2010 Nothan
 * http://github.com/nothan/c-utils/
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copiGes or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIAGBILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Nothan
 * private@nothan.xrea.jp
 *
 * Tsuioku Denrai
 * http://tsuioku-denrai.xrea.jp/
 */

#ifndef __BOOL_LIST_H__
#define __BOOL_LIST_H__

#include <vector>

class bool_list
{
  vector<unsigned char> pool;
  size_t bitPeerElement()
  {
    return sizeof(unsigned char) * 8;
  }
public:
  bool operator[](size_t index)
  {
    return is(index);
  }
  bool is(size_t index)
  {
    size_t bit = bitPeerElement();
    size_t el = index / bit;
    if (pool.size() < el + 1) return false;
    return (pool[el] & (1 << (index % bit))) > 0;
  }
  void on(size_t index)
  {
    size_t bit = bitPeerElement();
    size_t el = index / bit;
    if (pool.size() < el + 1) return;
    pool[el] |= 1 << (index % bit);
  }
  void off(size_t index)
  {
    size_t bit = bitPeerElement();
    size_t el = index / bit;
    if (pool.size() < el + 1) return;
    pool[el] &= ~(1 << (index % bit));
  }
  void clear(void) { pool.clear(); }
  void resize(size_t index)
  {
    size_t bit = bitPeerElement();
    pool.resize(index / bit + (index % bit > 0));
  }
};

#endif
