/**
 * fixed_float - fixed-point number.
 *
 * MIT License
 * Copyright (C) 2010 Nothan
 * http://github.com/nothan/c-utils/
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copiGes or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIAGBILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Nothan
 * private@nothan.xrea.jp
 *
 * Tsuioku Denrai
 * http://tsuioku-denrai.xrea.jp/
 */

#include "fixed_float.h"

#define DECIMAL_POINT_HALF (1 << (DECIMAL_POINT - 1))

fixed_float int_to_fixed_float(int x)
{
  if (x == 0) return 0;
  return (fixed_float)(x << DECIMAL_POINT);
}

fixed_float float_to_fixed_float(float x)
{
  if (x == 0) return 0;
  return (fixed_float)((double)x * (1 << DECIMAL_POINT));
}

int fixed_float_to_int(fixed_float x)
{
  if (x == 0) return 0;
  return (int)(x >> DECIMAL_POINT);
}

float fixed_float_to_float(fixed_float x)
{
  if (x == 0) return 0;
  return (float)((double)x / (1 << DECIMAL_POINT));
}

fixed_float fixed_float_multi(fixed_float x, fixed_float y)
{
  fixed_float result = x * y;

  result += DECIMAL_POINT_HALF * (result > 0 ? 1 : -1);
  result >>= DECIMAL_POINT;

  return result;
}

fixed_float fixed_float_div(fixed_float x, fixed_float y)
{
  fixed_float result = (x << DECIMAL_POINT) / y;

  return result;
}

fixed_float str_to_fixed_float(const char* text)
{
  fixed_float v;
  int float_point = 0;
  int iv = 0;
  float fv = 0;

  while ((*text >= '0' && *text <= '9') || *text == '.')
  {
    char num;
    if (*text == '.')
    {
      float_point = 10;
      text++;
      continue;
    }

    num = *text++ - '0';
    if (float_point)
    {
      fv += (float)num / float_point;
      float_point *= 10;
    }
    else
    {
      if (iv) iv *= 10;
      iv += num;
    }
  }
  v = int_to_fixed_float(iv);
  if (fv) v += float_to_fixed_float(fv);

  return v;
}

int str_to_int(const char* text)
{
  int v = 0;

  while (*text >= '0' && *text <= '9')
  {
    char num;

    num = *text++ - '0';
    if (v) v *= 10;
    v += num;
  }

  return v;
}