/**
 * fixed_float - fixed-point number.
 *
 * MIT License
 * Copyright (C) 2010 Nothan
 * http://github.com/nothan/c-utils/
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copiGes or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIAGBILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Nothan
 * private@nothan.xrea.jp
 *
 * Tsuioku Denrai
 * http://tsuioku-denrai.xrea.jp/
 */

#ifndef __FIXED_FLOAT_H__
#define __FIXED_FLOAT_H__

#define DECIMAL_POINT 8

#ifdef __cplusplus
extern "C" {
#endif

typedef int fixed_float;

fixed_float int_to_fixed_float(int x);
fixed_float float_to_fixed_float(float x);
int fixed_float_to_int(fixed_float x);
float fixed_float_to_float(fixed_float x);
fixed_float fixed_float_multi(fixed_float x, fixed_float y);
fixed_float fixed_float_div(fixed_float x, fixed_float y);
fixed_float str_to_fixed_float(const char* text);
int str_to_int(const char* text);

#ifdef __cplusplus
}
#endif

#endif
