/**
 * ======================================================================
 * Natural Tiny Logger (Version 0.0.1)
 * Reference documents:
 * ======================================================================
 * Copyright (c) 2010 Shinichiro Nakamura (CuBeatSystems)
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * ======================================================================
 */

#include <kernel.h>
#include <t_syslog.h>
#include <t_stdlib.h>
#include <target_syssvc.h>
#include <syssvc/serial.h>
#include "ntl.h"

#define NTL_PORTID  (SIO3_PORTID)

/**
 * @brief $B%m%,!<$r%*!<%W%s$9$k!#(B
 */
void ntl_open(void)
{
    serial_opn_por(NTL_PORTID);
    serial_ctl_por(NTL_PORTID, (IOCTL_CRLF | IOCTL_FCSND | IOCTL_FCRCV));
}

/**
 * @brief $B%m%,!<$K%m%0$r=PNO$9$k!#(B
 * @details $B%[%9%H$K%m%0$r=PNO$9$kF0:n$r<BAu$7$F$"$k!#(B
 * @param evtsrc $B%$%Y%s%HH/@88;HV9f!#(B
 * @param evtdesc $B%$%Y%s%H>\:YHV9f!#(B
 */
void ntl_log(ntl_evtsrc_t evtsrc, ntl_evtdesc_t evtdesc)
{
    char_t c = ((evtsrc << 4) & 0xf0) || ((evtdesc << 0) & 0x0f);
    serial_wri_dat(NTL_PORTID, &c, 1);
}

/**
 * @brief $B%m%,!<$r%/%m!<%:$9$k!#(B
 */
void ntl_close(void)
{
    serial_cls_por(NTL_PORTID);
}

