#ifndef TASK_DISPLAY_H
#define TASK_DISPLAY_H

#define TSKPRI_DISPLAY  6
#define TSKSTK_DISPLAY  2048

/**
 * @brief ディスプレイタスクへのメッセージ通信用構造体。
 */
typedef struct {
    T_MSG header;       /**< カーネルが使用するメッセージヘッダ。 */
    uint8_t cmd;        /**< コマンド。 */
    uint8_t param[64];  /**< 最大64バイトのパラメータ領域。 */
} display_msg_t;

/**
 * @brief ディスプレイタスクの実装。
 * @param exinf タスクへのパラメータ。
 */
void task_display(intptr_t exinf);

#define DOT_LEFT_UPPER           (1 << 0)
#define DOT_LEFT_LOWER           (1 << 1)
#define DOT_CENTER_LEFT_UPPER    (1 << 2)
#define DOT_CENTER_LEFT_LOWER    (1 << 3)
#define DOT_CENTER_RIGHT_UPPER   (1 << 4)
#define DOT_CENTER_RIGHT_LOWER   (1 << 5)
#define DOT_RIGHT_UPPER          (1 << 6)
#define DOT_RIGHT_LOWER          (1 << 7)

/**
 * @brief ディスプレイ更新命令。
 */
void tskapi_display_update(
        uint8_t h10,
        uint8_t h01,
        uint8_t m10,
        uint8_t m01,
        uint8_t s10,
        uint8_t s01,
        uint8_t col);
#define TSKAPI_DISPLAY_UPDATE(H10, H01, M10, M01, S10, S01, COL) \
    tskapi_display_update(H10, H01, M10, M01, S10, S01, COL)

#endif

