﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Aqua877.WinApp.IronLivetube.CommandOptionWindows
{
	public partial class VoteBanCommandOptionWindow : Form
	{
		public VoteBanCommandOptionWindow()
		{
			this.InitializeComponent();

			this.ExecuteCommandBorderTextBox.Value = GlobalValues.Setting.ExecuteCommandBorder;
			this.IsCheckOverlapByIDAndHostCheckBox.Checked = GlobalValues.Setting.IsCheckOverlapByIDAndHost;
			this.IsSetValidityPeriodCheckBox.Checked = GlobalValues.Setting.IsSetValidityPeriod;
		}

		private void OKButton_Click(object sender, EventArgs e)
		{
			this.Close();
		}

		private void ExecuteCommandBorderTextBox_ValueChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.ExecuteCommandBorder = (uint)this.ExecuteCommandBorderTextBox.Value;
		}

		private void IsCheckOverlapByIDAndHostCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.IsCheckOverlapByIDAndHost = this.IsCheckOverlapByIDAndHostCheckBox.Checked;
		}

		private void IsSetValidityPeriodCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.IsSetValidityPeriod = this.IsSetValidityPeriodCheckBox.Checked;

			if (this.IsSetValidityPeriodCheckBox.Checked)
			{
				this.VoteValidityPeriodTextBox.Enabled = true;
			}
			else
			{
				this.VoteValidityPeriodTextBox.Enabled = false;
			}
		}

		private void VoteValidityPeriodTextBox_ValueChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.VoteValidityPeriod = (uint)this.VoteValidityPeriodTextBox.Value;
		}
	}
}
