﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Text.RegularExpressions;

namespace Aqua877.WinApp.IronLivetube
{
	public partial class OpenLiveFromStreamIDWindow : Form
	{
		public OpenLiveFromStreamIDWindow()
		{
			InitializeComponent();
		}

		private void OpenLiveButton_Click(object sender, EventArgs e)
		{
			if (this.StreamIDTextBox.Text == "")
			{
				this.ErrorMessageTextBox.Visible = true;
				this.ErrorMessageTextBox.Text = "    StreamIDを入力してください。";
			}
			else if (!Regex.IsMatch(this.StreamIDTextBox.Text, GlobalValues.StreamIDPattern))
			{
				this.ErrorMessageTextBox.Visible = true;
				this.ErrorMessageTextBox.Text = "    StreamIDの形式が正しくありません。";
			}
			else
			{
				this.Tag = this.StreamIDTextBox.Text;
				this.DialogResult = System.Windows.Forms.DialogResult.OK;
				this.Close();
			}
		}
	}
}
