﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Aqua877.WinApp.IronLivetube
{
	public enum LivetubeServers
	{
		Large03,
		Large04,
		Large05,
		H,
		Tes01,
		Default
	};

	public enum ShortenSites
	{
		Auto,
		BitLy,
		JMp,
		IsGd,
		UxNu,
		PTl
	}

	public class SoundEffectRule
	{
		public string SoundFilePath { get; set; }
		public string PlaySoundEffectCondition { get; set; }
		public bool ExactMatch { get; set; }
		public bool IsUseRegularExpression { get; set; }
	}

	[Serializable]
	public class Settings
	{
		public string[] CredentialData = new string[] { };
		public string LivetubeUserID = "";
		public string LivetubePassword = "";
		public bool IsPlayNotifySound = false;
		public string NotifySoundPath = "";
		public bool IsShowCommentAnchor = false;
		public bool IsShowAllComments = true;
		public int ShowCommentCount = 0;
		public bool IsSelectServer = false;
		public LivetubeServers SelectedServer = LivetubeServers.Default;
		public bool IsUseShortenURLSite;

		public bool IsEnableAutoBanContinuousComments;
		

		public bool IsShowWindowMostTop = false;
		public bool IsEnableSemitransparentMode = true;
		public bool IsEnablePutWindowIntoTaskTrayCheckBox = false;
		public bool IsLockSortOrder = false;
		public SortOrder CommentsSortOrder = SortOrder.Ascending;
		public bool IsShowGridLines = false;
		public bool IsEnableAutoScroll = true;

		public bool IsEnableCommand = false;
		public bool IsUseReplaceCommand = false;
			public bool IsDisableCommandForShortlyString = true;
			public bool IsNotifyWhenCommandExecuted = true;
			public bool IsReflectCommandForWordAddedByUser = true;
		public bool IsUseUnreplaceCommand = false;
		public bool IsUseVoteBanCommand = false;
			public uint ExecuteCommandBorder = 10;
			public bool IsCheckOverlapByIDAndHost = true;
			public bool IsSetValidityPeriod = true;
			public uint VoteValidityPeriod = 5;		
		public bool IsUseVoteUnBanCommand = false;
		public bool IsUsePlaySoundCommand = false;
		public bool IsUseCancelPlayingSoundCommand = false;
		public bool IsUseAddFilteringRuleCommand = false;
		public bool IsUseRemoveFilteringRuleCommand = false;

		public bool IsEnableReading = false;
		public string SoftalkPath = "";
		public string ReadingTemplate = "レス{ResID} {Writer[さん]} {PostText}";
		public List<Replacement> ReplacementWords = new List<Replacement>();
		public bool IsReadCommentAtFirst = false;
		public bool IsEnableAdjustReadSpeed = true;

		public bool IsEnableSoundEffect = false;
		public List<SoundEffectRule> SoundEffectRules = new List<SoundEffectRule>();
		
		public bool IsEnableFiltering = false;
		public List<FilteringRule> FilteringRules = new List<FilteringRule>();
		public bool IsExceptMatchedComment;
	}
}
