<?php

class MacWikiCaptcha extends SimpleCaptcha {

        function getCaptcha() {
                $a = mt_rand(1000, 1500);
                $b = mt_rand(0, 10);
                $op = mt_rand(0, 1) ? '+' : '-';

                $za = preg_replace(array('/0/','/1/','/2/','/3/','/4/','/5/','/6/','/7/','/8/','/9/'), array('０','１','２','３','４','５','６','７','８','９'), $a);
                $zb = preg_replace(array('/0/','/1/','/2/','/3/','/4/','/5/','/6/','/7/','/8/','/9/'), array('０','１','２','３','４','５','６','７','８','９'), $b);

                if ($op == '+') {
                   $answer = ($a + $b);
                   $test = "$za に $zb を加算すると";
                } else {
                   $answer = ($a - $b);
                   $test = "$za より $zb を減じると";
                }

                return array('question' => $test, 'answer' => $answer);
        }

        function getForm() {
                $captcha = $this->getCaptcha();
                $index = $this->storeCaptcha( $captcha );

                return "<p><label for=\"wpCaptchaWord\">{$captcha['question']}</label> = " .
                        Xml::element( 'input', array(
                                'name' => 'wpCaptchaWord',
                                'id'   => 'wpCaptchaWord',
                                'tabindex' => 1 ) ) . // tab in before the edit textarea
                        "</p>\n" .
                        Xml::element( 'input', array(
                                'type'  => 'hidden',
                                'name'  => 'wpCaptchaId',
                                'id'    => 'wpCaptchaId',
                                'value' => $index ) );
        }

        function keyMatch( $answer, $info ) {
                return preg_replace(array('/０/','/１/','/２/','/３/','/４/','/５/','/６/','/７/','/８/','/９/'), array('0','1','2','3','4','5','6','7','8','9'), $answer) == $info['answer'];
        }
}
?>
