<?php
/* ϊ̊G^Cv */
define('MPC_TO_FOMA'    , 'FOMA');
define('MPC_TO_EZWEB'   , 'EZWEB');
define('MPC_TO_SOFTBANK', 'SOFTBANK');
/* ϊ̊Ǧn */
define('MPC_TO_OPTION_RAW' , 'RAW'); // oCiR[h
define('MPC_TO_OPTION_WEB' , 'WEB'); // Web̓R[h
define('MPC_TO_OPTION_IMG' , 'IMG'); // 摜

// {{{ class MPC_common
/**
* Gϊx[XNX
* 
* @author   ryster <ryster@php-develop.org>
* @license  http://www.opensource.org/licenses/mit-license.php The MIT License
* @link     http://php-develop.org/MobilePictogramConverter/
*/
class MPC_Common
{
    /**
    * ϊ镶
    * @var mixed
    */
    var $string;
    
    /**
    * ϊ镶̕R[h (MPC_FROM_CHARSET_SJIS, MPC_FROM_CHARSET_UTF8)
    * @var string
    */
    var $from_charset;
    
    /**
    * ϊ镶̊G^Cv (MPC_FROM_FOMA, MPC_FROM_EZWEB, MPC_FROM_SOFTBANK)
    * @var string
    */
    var $from;
    
    /**
    * ϊG^Cv (MPC_TO_FOMA, MPC_TO_EZWEB, MPC_TO_SOFTBANK)
    * @var string
    */
    var $to;
    
    /**
    * ϊIvV (MPC_TO_OPTION_RAW, MPC_TO_OPTION_WEB, MPC_TO_OPTION_IMG)
    * @var string
    */
    var $option;
    
    /**
    * ϊ镶̊G^Cv (MPC_FROM_OPTION_RAW, MPC_FROM_OPTION_WEB, MPC_FROM_OPTION_IMG)
    * @var string
    */
    var $strtype;
    
    /**
    * i-modeG摜i[pX
    * @var string
    */
    var $i_img_path = 'img/i/';
    
    /**
    * EZwebG摜i[pX
    * @var string
    */
    var $e_img_path = 'img/e/';
    
    /**
    * SoftBankG摜i[pX
    * @var string
    */
    var $s_img_path = 'img/s/';
    
    /**
    * i-mode => EZwebϊ}bv (map/i2e_table.phpQ)
    * @var array
    */
    var $i2e_table = array();
    
    /**
    * i-mode => SoftBankϊ}bv (map/i2s_table.phpQ)
    * @var array
    */
    var $i2s_table = array();
    
    /**
    * SoftBank => i-modeϊ}bv (map/s2i_table.phpQ)
    * @var array
    */
    var $s2i_table = array();
    
    /**
    * SoftBank => EZwebϊ}bv (map/s2e_table.phpQ)
    * @var array
    */
    var $s2e_table = array();
    
    /**
    * EZweb => i-modeϊ}bv (map/e2i_table.phpQ)
    * @var array
    */
    var $e2i_table = array();
    
    /**
    * EZweb => SoftBankϊ}bv (map/e2s_table.phpQ)
    * @var array
    */
    var $e2s_table = array();
    
    /**
    * EZweb(iconԍ) => EZweb(Shift_JIS Hex)ϊ}bv (map/e2icon_table.phpQ)
    * @var array
    */
    var $e2icon_table = array();
    
    /**
    * ϊ̊G݂Ȃꍇ̑֕
    * @var string
    */
    var $substitute = '';
    
    /**
    * idecji[ϐ
    * @var array
    */
    var $decstring = array();
    
    /**
    * CNgp
    * @var integer
    */
    var $i = 0;
    
    /**
    * Yzp
    * @var integer
    */
    var $n = 0;
    
    /**
    * i[ϐ
    * @var array
    */
    var $unPictograms = array();
    
    /**
    * Gi[ϐ
    * @var array
    */
    var $Pictograms = array();
    
    /**
    * oC[U[G[WFg
    * @var array
    */
    var $mobile_user_agent = array(
       'DoCoMo'   => '/^DoCoMo\/\d\.\d[ \/]/',
       'SoftBank' => '/^(?:(?:SoftBank|Vodafone|J-PHONE)\/\d\.\d|MOT-)/',
       'EZweb'    => '/^(?:KDDI-[A-Z]+\d+[A-Z]? )?UP\.Browser\//',
    );
    
    /**
    * [U[G[WFgLAʂ
    * ΉGɎϊ
    * 
    * @return string
    */
    function autoConvert($toCharset = null)
    {
        $useragent = $_SERVER['HTTP_USER_AGENT'];
        if (preg_match($this->getRegexp('DoCoMo'), $useragent)) {
            $to     = MPC_TO_FOMA;
            $option = MPC_TO_OPTION_RAW;
        } elseif (preg_match($this->getRegexp('SoftBank'), $useragent)) {
            $to     = MPC_TO_SOFTBANK;
            $option = MPC_TO_OPTION_WEB;
        } elseif (preg_match($this->getRegexp('EZweb'), $useragent)) {
            $to     = MPC_TO_EZWEB;
            $option = MPC_TO_OPTION_RAW;
        } else {
            $to     = str_replace('MPC_', '', strtoupper(get_class($this)));
            $option = MPC_TO_OPTION_IMG;
        }
        
        return $this->Convert($to, $option, $toCharset);
    }
    
    /**
    * Gw肵G̎w肵tH[}bg֕ϊ
    * 
    * @param integer $data
    * @return string
    */
    function encoder($data)
    {
        $buf  = '';
        $to   = $this->getTo();
        $c    = ($to == MPC_TO_EZWEB) ? 'e' : (($to == MPC_TO_SOFTBANK) ? 's' : 'i');
        $options_encode = $c.'_options_encode';
        
        $data = ($to == $this->getFrom()) ? $data : $this->MapSearch($data, $this->getTo());
        if (gettype($data) == 'integer') {
            $buf = $this->$options_encode($data);
        } else {
            $strings = explode('/', $data);
            if (is_array($strings) && count($strings) > 1) {
                foreach ($strings as $value) {
                    $buf .= $this->$options_encode($value);
                }
            } else {
                $buf = ($this->getFromCharset() == MPC_FROM_CHARSET_UTF8) ? mb_convert_encoding($data, 'UTF-8', 'SJIS-win') : $data;
            }
        }
        return $buf;
    }
    
    /**
    * Gϊ}bv
    * 
    * @param  integer $key
    * @param  integer $to
    * @return string
    */
    function MapSearch($key, $to)
    {
        $from = $this->getFrom();
        $f = (($from == MPC_FROM_FOMA) ? 'i' : (($from == MPC_FROM_EZWEB) ? 'e' : 's'));
        $t = (($to   == MPC_TO_FOMA)   ? 'i' : (($to == MPC_TO_EZWEB)     ? 'e' : 's'));
        $map = $f.'2'.$t.'_table';
        if(empty($this->$map)) {
            require 'map/'.$map.'.php';
        }
        $mapping = $this->$map;
        return (empty($mapping[$key]) == false) ? $mapping[$key] : $this->getSubstitute();
    }
    
    /**
    * i-modeGi10ijw肳ꂽtH[}bg֕ϊ
    * 
    * @param  integer $dec
    * @return string
    */
    function i_options_encode($dec)
    {
        switch($this->getOption()) {
            case MPC_TO_OPTION_RAW:
                $buf = pack('H*', dechex($dec));
                if ($this->getFromCharset() == MPC_FROM_CHARSET_UTF8) {
                    $buf = mb_convert_encoding($buf, 'UTF-8', 'SJIS-win');
                }
                break;
            case MPC_TO_OPTION_WEB:
                $buf = ($dec >= 63921 && $dec <= 63996) ? '&#x'.strtoupper(bin2hex(mb_convert_encoding(pack('H*', dechex($dec)), 'unicode', 'SJIS-win'))).';' : '&#'.$dec.';';
                break;
            case MPC_TO_OPTION_IMG:
                $buf = '<img src="'.rtrim($this->i_img_path, '/').'/'.$dec.'.gif" alt="" border="0" width="12" height="12" />';
                break;
        }
        return $buf;
    }
    
    /**
    * EZwebGiiconԍjw肳ꂽtH[}bg֕ϊ
    * 
    * @param  integer $iconno
    * @return string
    */
    function e_options_encode($iconno)
    {
        switch($this->getOption()) {
            case MPC_TO_OPTION_RAW:
                if (empty($this->e2icon_table)) {
                    require 'map/e2icon_table.php';
                }
                $hex = dechex($this->e2icon_table[$iconno]);
                $buf = ($this->getFromCharset() == MPC_FROM_CHARSET_UTF8) ? mb_convert_encoding(pack('H*', dechex(hexdec($hex) - 1792)), 'UTF-8', 'unicode') : pack('H*', $hex);
                break;
            case MPC_TO_OPTION_WEB:
                $buf = '<img localsrc="'.$iconno.'" alt="" />';
                break;
            case MPC_TO_OPTION_IMG:
                $width = ($iconno == 174) ? 7 : (($iconno == 175) ? 4 : 15);
                $buf = '<img src="'.rtrim($this->e_img_path, '/').'/'.$iconno.'.gif" alt="" border="0" width="'.$width.'" height="15" />';
                break;
        }
        return $buf;
    }
    
    /**
    * SoftBankGi10ijw肳ꂽtH[}bg֕ϊ
    * 
    * @param  integer $dec
    * @return string
    */
    function s_options_encode($dec)
    {
        switch($this->getOption()) {
            case MPC_TO_OPTION_RAW:
                list($hex1, $hex2) = sscanf(dechex($dec), '%02s%02s');
                $dec1  = hexdec($hex1);
                $dec2  = hexdec($hex2);
                $num   = ($dec1 == 0x51) ? 0x60 : (($dec2 <= 0x5F) ? 0x60 : 0x20);
                $char2 = ($dec1 == 0x47) ? 0x80 : (($dec1 == 0x45) ? 0x84 : (($dec1 == 0x46) ? 0x88 : (($dec1 == 0x4F) ? 0x8C : (($dec1 == 0x50) ? 0x90 : 0x94))));
                if ($dec2 > 0x5F) {
                    $char2++;
                }
                $char3 = $dec2 + $num;
                $buf   = pack('C*', 0xEE, $char2, $char3);
                
                if ($this->getFromCharset() === 'SJIS') {
                    if (($char2 == 0x80 && ($char3 >= 0x81 && $char3 <= 0xBF)) || ($char2 == 0x81 && ($char3 >= 0x80 && $char3 <= 0x9A))) {
                        $diff = (($char2 == 0x80 && $char3 == 0xBF) || ($char2 == 0x81 && ($char3 >= 0x80 && $char3 <= 0x9A))) ? 6465 : 6464;
                    } elseif (($char2 == 0x84 && ($char3 >= 0x81 && $char3 <= 0xBF)) || ($char2 == 0x85 && ($char3 >= 0x80 && $char3 <= 0x9A))) {
                        $diff = (($char2 == 0x84 && $char3 == 0xBF) || ($char2 == 0x85 && ($char3 >= 0x80 && $char3 <= 0x9A))) ? 5697 : 5696;
                    } elseif (($char2 == 0x88 && ($char3 >= 0x81 && $char3 <= 0xBF)) || ($char2 == 0x89 && ($char3 >= 0x80 && $char3 <= 0x93))) {
                        $diff = 5536;
                    } elseif (($char2 == 0x8C && ($char3 >= 0x81 && $char3 <= 0xBF)) || ($char2 == 0x8D && ($char3 >= 0x80 && $char3 <= 0x8D))) {
                        $diff = 5792;
                    } elseif (($char2 == 0x90 && ($char3 >= 0x81 && $char3 <= 0xBF)) || ($char2 == 0x91 && ($char3 >= 0x80 && $char3 <= 0x8C))) {
                        $diff = (($char2 == 0x90 && $char3 == 0xBF) || ($char2 == 0x91 && ($char3 >= 0x80 && $char3 <= 0x8C))) ? 5953 : 5952;
                    } else {
                        $diff = 5792;
                    }
                    
                    $buf = pack('H*', dechex(hexdec(bin2hex(mb_convert_encoding($buf, 'unicode', 'UTF-8'))) + $diff));
                }
                break;
            case MPC_TO_OPTION_WEB:
                $buf = pack('H*', '1B24'.dechex($dec).'0F');
                break;
            case MPC_TO_OPTION_IMG:
                $width = ($dec >= 20828 && $dec <= 20830) ? 18 : 15;
                $buf = '<img src="'.rtrim($this->s_img_path, '/').'/'.$dec.'.gif" alt="" border="0" width="'.$width.'" height="15" />';
                break;
        }
        return $buf;
    }
    
    /**
    * ̌
    * G̉\Ȃ當i10iji[zԂ
    * 
    * return array
    */
    function Inspection()
    {
        $ds = $this->getCurrentDS();
        // 1byte
        if ($ds >= 0x00 && $ds <= 0x7F || ($this->getFromCharset() === MPC_FROM_CHARSET_SJIS && $ds >= 0xA0 && $ds <= 0xDF)) {
            $this->setUnPictogram(pack('C*', $ds));
        // 2byte <=
        } elseif ($this->getFromCharset() === MPC_FROM_CHARSET_SJIS && isset($this->decstring[$this->i + 1])) {
            $chars = array($ds, $this->decstring[$this->i + 1]);
            $this->i++;
        } else {
            if ($ds >= 0xE0 && $ds <= 0xEF && isset($this->decstring[$this->i + 1]) && isset($this->decstring[$this->i + 2])) {
                $chars = array($ds, $this->decstring[$this->i + 1], $this->decstring[$this->i + 2]);
                $this->i += 2;
            } else {
                $this->setUnPictogram(pack('C*', $ds));
            }
        }
        if (empty($chars) === false) {
            return $chars;
        } else {
            return null;
        }
    }
    
    /**
    * ݂̕i10i擾j
    *
    * @return string
    */
    function getCurrentDS()
    {
        if (isset($this->decstring[$this->i])) {
            return $this->decstring[$this->i];
        }
        return null;
    }
    
    /**
    * i10iji[
    * 
    * @param array
    */
    function setDS($decstrings)
    {
        if (is_array($decstrings)) {
            $this->decstring = $decstrings;
        }
    }
    
    /**
    * zɊi[
    * 
    * @param string $str
    */
    function setUnPictogram($str)
    {
        $this->unPictograms[$this->n] = $str;
        $this->n++;
    }
    
    /**
    * 擾
    * 
    * @return array
    */
    function getUnPictograms()
    {
        return $this->unPictograms;
    }
    
    /**
    * i[Ă镶J
    * 
    * @return void
    */
    function ReleaseUnPictograms()
    {
        $this->unPictograms = array();
    }
    
    /**
    * GzɊi[
    * 
    * @param string $pictogram
    */
    function setPictogram($pictogram)
    {
        $this->Pictograms[$this->n] = $pictogram;
        $this->n++;
    }
    
    /**
    * G擾
    * 
    * @return array
    */
    function getPictograms()
    {
        return $this->Pictograms;
    }
    
    /**
    * i[ĂGJ
    * 
    * @return void
    */
    function ReleasePictograms()
    {
        $this->Pictograms = array();
    }
    
    /**
    * J
    * 
    * @return void
    */
    function Clean()
    {
        $this->i2e_table = $this->i2s_table = $this->s2i_table = $this->s2e_table = $this->e2i_table = $this->e2s_table = $this->e2icon_table = array();
    }
    
    /**
    * w肵LARegex擾
    * 
    * @param string $carrier
    * @return string
    */
    function getRegexp($carrier)
    {
        return $this->mobile_user_agent[$carrier];
    }
    
    
    /**
    * G摜i[fBNg̈ꊇݒ
    * 
    * @param string $path
    */
    function setImagePath($path)
    {
        $path = rtrim($path, '/');
        $this->setFOMAImagePath($path.'/i/');
        $this->setEZwebImagePath($path.'/e/');
        $this->setSoftBankImagePath($path.'/s/');
    }
    
    /**
    * FOMAG摜i[fBNg̐ݒ
    * 
    * @param string $path
    */
    function setFOMAImagePath($path)
    {
        $this->i_img_path = $path;
    }
    
    /**
    * ݒ肳ĂFOMAG摜i[fBNg擾
    * 
    * @return string
    */
    function getFOMAImagePath()
    {
        return $this->i_img_path;
    }
    
    /**
    * EZwebG摜i[fBNg̐ݒ
    * 
    * @param string $path
    */
    function setEZwebImagePath($path)
    {
        $this->e_img_path = $path;
    }
    
    /**
    * ݒ肳ĂEZwebG摜i[fBNg擾
    * 
    * @return string
    */
    function getEZwebImagePath()
    {
        return $this->e_img_path;
    }
    
    /**
    * SoftBankG摜i[fBNg̐ݒ
    * 
    * @param string $path
    */
    function setSoftBankImagePath($path)
    {
        $this->s_img_path = $path;
    }
    
    /**
    * ݒ肳ĂSoftBankG摜i[fBNg擾
    * 
    * @return string
    */
    function getSoftBankImagePath()
    {
        return $this->s_img_path;
    }
    
    /**
    * ϊ镶̐ݒ
    *
    * @param mixed $str
    */
    function setString($string)
    {
        $charset = ($this->getFromCharset() == MPC_FROM_CHARSET_SJIS) ? 'SJIS-win' : 'UTF-8';
        $this->string = mb_convert_encoding($string, $charset, $charset);
    }
    
    /**
    * ݒ肳Ăϊ镶擾
    *
    * @return mixed
    */
    function getString()
    {
        return $this->string;
    }
    
    /**
    * ϊOG̃LAݒ (MPC_FROM_FOMA, MPC_FROM_EZWEB, MPC_FROM_SOFTBANK)
    *
    * @param string $from
    */
    function setFrom($from)
    {
        $this->from = $from;
    }
    
    /**
    * ݒ肳ĂϊOGLA擾
    *
    * @return string
    */
    function getFrom()
    {
        return $this->from;
    }
    
    /**
    * ϊG̃LAݒ (MPC_TO_FOMA, MPC_TO_EZWEB, MPC_TO_SOFTBANK)
    *
    * @param string $to
    */
    function setTo($to)
    {
        $this->to = $to;
    }
    
    /**
    * ݒ肳ĂϊG̃LA擾
    *
    * @return string
    */
    function getTo()
    {
        return $this->to;
    }
    
    /**
    * ϊIvVݒ (MPC_TO_OPTION_RAW, MPC_TO_OPTION_WEB, MPC_TO_OPTION_IMG)
    *
    * @param string $to
    */
    function setOption($option)
    {
        $this->option = $option;
    }
    
    /**
    * ݒ肳ĂϊIvV擾
    *
    * @param string $to
    */
    function getOption()
    {
        return $this->option;
    }
    
    /**
    * ϊOG̃^Cvݒ (MPC_FROM_OPTION_RAW, MPC_FROM_OPTION_WEB, MPC_FROM_OPTION_IMG)
    *
    * @param string $strtype
    */
    function setStringType($strtype)
    {
        $this->strtype = $strtype;
    }
    
    /**
    * ݒ肳ĂϊOG̃^Cv擾
    *
    * @return string
    */
    function getStringType()
    {
        return $this->strtype;
    }
    
    /**
    * ϊ镶̕R[hݒ (MPC_FROM_CHARSET_SJIS, MPC_FROM_CHARSET_UTF8)
    *
    * @param string $charset
    */
    function setFromCharset($charset)
    {
        $this->from_charset = strtoupper($charset);
    }
    
    /**
    * ݒ肳Ăϊ镶̕R[h擾
    * 
    * @return string
    */
    function getFromCharset()
    {
        return $this->from_charset;
    }
    
    /**
    * w肵AK\擾
    * 
    * @param $type (WEB, IMG)
    * @return string
    */
    function getRegex($type) {
        if (isset($this->regex[$type])) {
            return $this->regex[$type];
        }
    }
    
    /**
    * ֕ݒ
    * 
    * @param mixed $str
    */
    function setSubstitute($str) {
        $this->substitute = $str;
    }
    
    /**
    * ݒ肳Ă֕擾
    * 
    * @return string
    */
    function getSubstitute() {
        return $this->substitute;
    }
    
    /**
    * 10iizj16iɕϊ
    * @param array $decs
    * @return string
    */
    function decs2hex($decs, $upper = true)
    {
        if (is_array($decs) === false) {
            return null;
        }
        $hex = '';
        foreach ($decs as $dec) {
            $hex .= dechex($dec);
        }
        return ($upper == true) ? strtoupper($hex) : $hex;
    }
}
// }}}
?>