/**
 * Copyright (c) 2009 - 2010 Chris Leonello
 * jqPlot is currently available for use in all personal or commercial projects 
 * under both the MIT (http://www.opensource.org/licenses/mit-license.php) and GPL 
 * version 2.0 (http://www.gnu.org/licenses/gpl-2.0.html) licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly. 
 *
 * Although not required, the author would appreciate an email letting him 
 * know of any substantial use of jqPlot.  You can reach the author at: 
 * chris at jqplot  or see http://www.jqplot.com/info.php .
 *
 * If you are feeling kind and generous, consider supporting the project by
 * making a donation at: http://www.jqplot.com/donate.php .
 *
 * jqPlot includes date instance methods and printf/sprintf functions by other authors:
 *
 * Date instance methods contained in jqplot.dateMethods.js:
 *
 *     author Ken Snyder (ken d snyder at gmail dot com)
 *     date 2008-09-10
 *     version 2.0.2 (http://kendsnyder.com/sandbox/date/)     
 *     license Creative Commons Attribution License 3.0 (http://creativecommons.org/licenses/by/3.0/)
 *
 * JavaScript printf/sprintf functions contained in jqplot.sprintf.js:
 *
 *     version 2007.04.27
 *     author Ash Searle
 *     http://hexmen.com/blog/2007/03/printf-sprintf/
 *     http://hexmen.com/js/sprintf.js
 *     The author (Ash Searle) has placed this code in the public domain:
 *     "This code is unrestricted: you are free to use it however you like."
 * 
 */
(function(c){c.jqplot.MeterGaugeRenderer=function(){c.jqplot.LineRenderer.call(this)};c.jqplot.MeterGaugeRenderer.prototype=new c.jqplot.LineRenderer();c.jqplot.MeterGaugeRenderer.prototype.constructor=c.jqplot.MeterGaugeRenderer;c.jqplot.MeterGaugeRenderer.prototype.init=function(e){this.diameter=null;this.padding=null;this.shadowOffset=2;this.shadowAlpha=0.07;this.shadowDepth=4;this.background="#efefef";this.ringColor="#BBC6D0";this.needleColor="#C3D3E5";this.tickColor="989898";this.ringWidth=null;this.min;this.max;this.ticks=[];this.showTicks=true;this.showTickLabels=true;this.label=null;this.labelHeightAdjust=0;this.labelPosition="inside";this.intervals=[];this.intervalColors=["#4bb2c5","#EAA228","#c5b47f","#579575","#839557","#958c12","#953579","#4b5de4","#d8b83f","#ff5800","#0085cc","#c747a3","#cddf54","#FBD178","#26B4E3","#bd70c7"];this.intervalInnerRadius=null;this.intervalOuterRadius=null;this.tickRenderer=c.jqplot.MeterGaugeTickRenderer;this.tickPositions=[1,2,2.5,5,10];this.tickSpacing=30;this.numberMinorTicks=null;this.hubRadius=null;this.tickPadding=null;this.needleThickness=null;this.needlePad=6;this.pegNeedle=true;c.extend(true,this,e);this.type=null;this.numberTicks=null;this.tickInterval=null;this.span=180;if(this.type=="circular"){this.semiCircular=false}else{if(this.type!="circular"){this.semiCircular=true}else{this.semiCircular=(this.span<=180)?true:false}}this._tickPoints=[];this._labelElm=null;this.startAngle=(90+(360-this.span)/2)*Math.PI/180;this.endAngle=(90-(360-this.span)/2)*Math.PI/180;this.setmin=!!(this.min==null);this.setmax=!!(this.max==null);if(this.intervals.length){if(this.intervals[0].length==null||this.intervals.length==1){for(var f=0;f<this.intervals.length;f++){this.intervals[f]=[this.intervals[f],this.intervals[f],this.intervalColors[f]]}}else{if(this.intervals[0].length==2){for(f=0;f<this.intervals.length;f++){this.intervals[f]=[this.intervals[f][0],this.intervals[f][1],this.intervalColors[f]]}}}}if(this.ticks.length){if(this.ticks[0].length==null||this.ticks[0].length==1){for(var f=0;f<this.ticks.length;f++){this.ticks[f]=[this.ticks[f],this.ticks[f]]}}this.min=(this.min==null)?this.ticks[0][0]:this.min;this.max=(this.max==null)?this.ticks[this.ticks.length-1][0]:this.max;this.setmin=false;this.setmax=false;this.numberTicks=this.ticks.length;this.tickInterval=this.ticks[1][0]-this.ticks[0][0];this.tickFactor=Math.floor(parseFloat((Math.log(this.tickInterval)/Math.log(10)).toFixed(11)));this.numberMinorTicks=b(this.tickPositions,this.tickInterval,this.tickFactor);if(!this.numberMinorTicks){this.numberMinorTicks=b(this.tickPositions,this.tickInterval,this.tickFactor-1)}if(!this.numberMinorTicks){this.numberMinorTicks=1}}else{if(this.intervals.length){this.min=(this.min==null)?0:this.min;this.setmin=false;if(this.max==null){if(this.intervals[this.intervals.length-1][0]>=this.data[0][1]){this.max=this.intervals[this.intervals.length-1][0];this.setmax=false}}else{this.setmax=false}}else{this.min=(this.min==null)?0:this.min;this.setmin=false;if(this.max==null){this.max=this.data[0][1]*1.25;this.setmax=true}else{this.setmax=false}}}};c.jqplot.MeterGaugeRenderer.prototype.setGridData=function(j){var f=[];var k=[];var e=this.startAngle;for(var h=0;h<this.data.length;h++){f.push(this.data[h][1]);k.push([this.data[h][0]]);if(h>0){f[h]+=f[h-1]}}var g=Math.PI*2/f[f.length-1];for(var h=0;h<f.length;h++){k[h][1]=f[h]*g}this.gridData=k};c.jqplot.MeterGaugeRenderer.prototype.makeGridData=function(j,k){var f=[];var l=[];var e=this.startAngle;for(var h=0;h<j.length;h++){f.push(j[h][1]);l.push([j[h][0]]);if(h>0){f[h]+=f[h-1]}}var g=Math.PI*2/f[f.length-1];for(var h=0;h<f.length;h++){l[h][1]=f[h]*g}return l};function b(h,f,g){var e;for(i=h.length-1;i>=0;i--){e=f/(h[i]*Math.pow(10,g));if(e==4||e==5){return e-1}}return null}c.jqplot.MeterGaugeRenderer.prototype.draw=function(W,aA,an){var Z;var aK=(an!=undefined)?an:{};var ah=0;var ag=0;var aq=1;if(an.legendInfo&&an.legendInfo.placement=="inside"){var aG=an.legendInfo;switch(aG.location){case"nw":ah=aG.width+aG.xoffset;break;case"w":ah=aG.width+aG.xoffset;break;case"sw":ah=aG.width+aG.xoffset;break;case"ne":ah=aG.width+aG.xoffset;aq=-1;break;case"e":ah=aG.width+aG.xoffset;aq=-1;break;case"se":ah=aG.width+aG.xoffset;aq=-1;break;case"n":ag=aG.height+aG.yoffset;break;case"s":ag=aG.height+aG.yoffset;aq=-1;break;default:break}}if(this.label){this._labelElem=c('<div class="jqplot-meterGauge-label" style="position:absolute;">'+this.label+"</div>");this.canvas._elem.after(this._labelElem)}var k=(aK.shadow!=undefined)?aK.shadow:this.shadow;var M=(aK.showLine!=undefined)?aK.showLine:this.showLine;var H=(aK.fill!=undefined)?aK.fill:this.fill;var J=W.canvas.width;var R=W.canvas.height;if(this.padding==null){this.padding=Math.round(Math.min(J,R)/30)}var P=J-ah-2*this.padding;var aa=R-ag-2*this.padding;if(this.labelPosition=="bottom"&&this.label){aa-=this._labelElem.outerHeight(true)}var K=Math.min(P,aa);var ac=K;if(!this.diameter){if(this.semiCircular){if(P>=2*aa){if(!this.ringWidth){this.ringWidth=2*aa/35}this.needleThickness=this.needleThickness||2+Math.pow(this.ringWidth,0.8);this.innerPad=this.ringWidth/2+this.needleThickness/2+this.needlePad;this.diameter=2*(aa-2*this.innerPad)}else{if(!this.ringWidth){this.ringWidth=P/35}this.needleThickness=this.needleThickness||2+Math.pow(this.ringWidth,0.8);this.innerPad=this.ringWidth/2+this.needleThickness/2+this.needlePad;this.diameter=P-2*this.innerPad}this._center=[(J-aq*ah)/2+aq*ah,(R+aq*ag-this.padding-this.ringWidth-this.innerPad)]}else{if(!this.ringWidth){this.ringWidth=ac/35}this.needleThickness=this.needleThickness||2+Math.pow(this.ringWidth,0.8);this.innerPad=0;this.diameter=ac-this.ringWidth;this._center=[(J-aq*ah)/2+aq*ah,(R-aq*ag)/2+aq*ag]}}if(this._labelElem&&this.labelPosition=="bottom"){this._center[1]-=this._labelElem.outerHeight(true)}this._radius=this.diameter/2;this.tickSpacing=6000/this.diameter;if(!this.hubRadius){this.hubRadius=this.diameter/18}this.shadowOffset=0.5+this.ringWidth/9;this.shadowWidth=this.ringWidth*1;this.tickPadding=3+Math.pow(this.diameter/20,0.7);this.tickOuterRadius=this._radius-this.ringWidth/2-this.tickPadding;this.tickLength=(this.showTicks)?this._radius/13:0;if(this.ticks.length==0){var z=this.max,aJ=this.min,p=this.setmax,aE=this.setmin,ar=(z-aJ)*this.tickSpacing/this.span;var au=Math.floor(parseFloat((Math.log(ar)/Math.log(10)).toFixed(11)));var am=(ar/Math.pow(10,au));(am>2&&am<=2.5)?am=2.5:am=Math.ceil(am);var S=this.tickPositions;var ay,aj;for(Z=0;Z<S.length;Z++){if(am==S[Z]||Z&&S[Z-1]<am&&am<S[Z]){ar=S[Z]*Math.pow(10,au);ay=Z}}for(Z=0;Z<S.length;Z++){if(am==S[Z]||Z&&S[Z-1]<am&&am<S[Z]){ar=S[Z]*Math.pow(10,au);aj=Math.ceil((z-aJ)/ar)}}if(p&&aE){var aN=(aJ>0)?aJ-aJ%ar:aJ-aJ%ar-ar;if(!this.forceZero){var C=Math.min(aJ-aN,0.8*ar);var n=Math.floor(C/S[ay]);if(n>1){aN=aN+S[ay]*(n-1);if(parseInt(aN,10)!=aN&&parseInt(aN-S[ay],10)==aN-S[ay]){aN=aN-S[ay]}}}if(aJ==aN){aJ-=ar}else{if(aJ-aN>0.23*ar){aJ=aN}else{aJ=aN-ar;aj+=1}}aj+=1;var D=aJ+(aj-1)*ar;if(z>=D){D+=ar;aj+=1}if(D-z<0.23*ar){D+=ar;aj+=1}this.max=z=D;this.min=aJ;this.tickInterval=ar;this.numberTicks=aj;var N;for(Z=0;Z<aj;Z++){N=parseFloat((aJ+Z*ar).toFixed(11));this.ticks.push([N,N])}this.max=this.ticks[aj-1][1];this.tickFactor=au;this.numberMinorTicks=b(this.tickPositions,this.tickInterval,this.tickFactor);if(!this.numberMinorTicks){this.numberMinorTicks=b(this.tickPositions,this.tickInterval,this.tickFactor-1)}}else{if(p){var D=aJ+(aj-1)*ar;if(z>=D){z=D+ar;aj+=1}else{z=D}this.tickInterval=this.tickInterval||ar;this.numberTicks=this.numberTicks||aj;var N;for(Z=0;Z<this.numberTicks;Z++){N=parseFloat((aJ+Z*this.tickInterval).toFixed(11));this.ticks.push([N,N])}this.max=this.ticks[this.numberTicks-1][1];this.tickFactor=au;this.numberMinorTicks=b(this.tickPositions,this.tickInterval,this.tickFactor);if(!this.numberMinorTicks){this.numberMinorTicks=b(this.tickPositions,this.tickInterval,this.tickFactor-1)}}}if(!p&&!aE){var O=this.max-this.min;au=Math.floor(parseFloat((Math.log(O)/Math.log(10)).toFixed(11)))-1;var aL=[5,6,4,7,3,8,9,10,2],U,B,at=0,L;if(O>1){var aH=String(O);if(aH.search(/\./)==-1){var aD=aH.search(/0+$/);at=(aD>0)?aH.length-aD-1:0}}L=O/Math.pow(10,at);for(Z=0;Z<aL.length;Z++){U=L/(aL[Z]-1);if(U==parseInt(U,10)){this.numberTicks=aL[Z];this.tickInterval=O/(this.numberTicks-1);this.tickFactor=au+1;break}}var N;for(Z=0;Z<this.numberTicks;Z++){N=parseFloat((this.min+Z*this.tickInterval).toFixed(11));this.ticks.push([N,N])}this.numberMinorTicks=b(this.tickPositions,this.tickInterval,this.tickFactor);if(!this.numberMinorTicks){this.numberMinorTicks=b(this.tickPositions,this.tickInterval,this.tickFactor-1)}if(!this.numberMinorTicks){this.numberMinorTicks=1;var aF=[4,5,3,6,2];for(Z=0;Z<5;Z++){temp=this.tickInterval/aF[Z];if(temp==parseInt(temp)){this.numberMinorTicks=aF[Z]-1;break}}}}}var T=this._radius,aC=this.startAngle,g=this.endAngle,G=Math.PI,e=Math.PI/2;if(this.semiCircular){var x=Math.atan(this.innerPad/T),ab=this.outerStartAngle=aC-x,az=this.outerEndAngle=g+x,A=this.hubStartAngle=aC-Math.atan(this.innerPad/this.hubRadius*2),ae=this.hubEndAngle=g+Math.atan(this.innerPad/this.hubRadius*2);W.save();W.translate(this._center[0],this._center[1]);W.lineJoin="round";W.lineCap="round";W.save();W.beginPath();W.fillStyle=this.background;W.arc(0,0,T,ab,az,false);W.closePath();W.fill();W.restore();var ai="rgba(0,0,0,"+this.shadowAlpha+")";W.save();for(var Z=0;Z<this.shadowDepth;Z++){W.translate(this.shadowOffset*Math.cos(this.shadowAngle/180*Math.PI),this.shadowOffset*Math.sin(this.shadowAngle/180*Math.PI));W.beginPath();W.strokeStyle=ai;W.lineWidth=this.shadowWidth;W.arc(0,0,T,ab,az,false);W.closePath();W.stroke()}W.restore();W.save();var ax=parseInt((this.shadowDepth+1)/2,10);for(var Z=0;Z<ax;Z++){W.translate(this.shadowOffset*Math.cos(this.shadowAngle/180*Math.PI),this.shadowOffset*Math.sin(this.shadowAngle/180*Math.PI));W.beginPath();W.fillStyle=ai;W.arc(0,0,this.hubRadius,A,ae,false);W.closePath();W.fill()}W.restore();W.save();W.beginPath();W.strokeStyle=this.ringColor;W.lineWidth=this.ringWidth;W.arc(0,0,T,ab,az,false);W.closePath();W.stroke();W.restore();W.save();W.beginPath();W.fillStyle=this.ringColor;W.arc(0,0,this.hubRadius,A,ae,false);W.closePath();W.fill();W.restore();if(this.showTicks){W.save();var f=this.tickOuterRadius,ao=this.tickLength,u=ao/2,E=this.numberMinorTicks,al=this.span*Math.PI/180/(this.ticks.length-1),o=al/(E+1);for(Z=0;Z<this.ticks.length;Z++){W.beginPath();W.lineWidth=1.5+this.diameter/360;W.strokeStyle=this.ringColor;var ad=al*Z+aC;W.moveTo(-f*Math.cos(al*Z+aC),f*Math.sin(al*Z+aC));W.lineTo(-(f-ao)*Math.cos(al*Z+aC),(f-ao)*Math.sin(al*Z+aC));this._tickPoints.push([(f-ao)*Math.cos(al*Z+aC)+this._center[0]+this.canvas._offsets.left,(f-ao)*Math.sin(al*Z+aC)+this._center[1]+this.canvas._offsets.top,al*Z+aC]);W.stroke();W.lineWidth=1+this.diameter/440;if(Z<this.ticks.length-1){for(var X=1;X<=E;X++){W.beginPath();W.moveTo(-f*Math.cos(al*Z+o*X+aC),f*Math.sin(al*Z+o*X+aC));W.lineTo(-(f-u)*Math.cos(al*Z+o*X+aC),(f-u)*Math.sin(al*Z+o*X+aC));W.stroke()}}}W.restore()}if(this.showTickLabels){var I,V,S,aM,F,m=0;var am=this.tickPadding*(1-1/(this.diameter/80+1));for(Z=0;Z<this.ticks.length;Z++){I=c('<div class="jqplot-meterGauge-tick" style="position:absolute;">'+this.ticks[Z][1]+"</div>");this.canvas._elem.after(I);aM=I.outerWidth(true);eh=I.outerHeight(true);V=this._tickPoints[Z][0]-aM*(this._tickPoints[Z][2]-Math.PI)/Math.PI-am*Math.cos(this._tickPoints[Z][2]);S=this._tickPoints[Z][1]-eh/2+eh/2*Math.pow(Math.abs((Math.sin(this._tickPoints[Z][2]))),0.5)+am/3*Math.pow(Math.abs((Math.sin(this._tickPoints[Z][2]))),0.5);I.css({left:V,top:S});F=aM*Math.cos(this._tickPoints[Z][2])+eh*Math.sin(Math.PI/2+this._tickPoints[Z][2]/2);m=(F>m)?F:m}}if(this.label&&this.labelPosition=="inside"){var V=this._center[0]+this.canvas._offsets.left;var am=this.tickPadding*(1-1/(this.diameter/80+1));var S=0.5*(this._center[1]+this.canvas._offsets.top-this.hubRadius)+0.5*(this._center[1]+this.canvas._offsets.top-this.tickOuterRadius+this.tickLength+am)+this.labelHeightAdjust;V-=this._labelElem.outerWidth(true)/2;S-=this._labelElem.outerHeight(true)/2;this._labelElem.css({left:V,top:S})}else{if(this.label&&this.labelPosition=="bottom"){var V=this._center[0]+this.canvas._offsets.left-this._labelElem.outerWidth(true)/2;var S=this._center[1]+this.canvas._offsets.top+this.innerPad+ +this.ringWidth+this.padding+this.labelHeightAdjust;this._labelElem.css({left:V,top:S})}}W.save();var av=this.intervalInnerRadius||this.hubRadius*1.5;if(this.intervalOuterRadius==null){if(this.showTickLabels){var af=(this.tickOuterRadius-this.tickLength-this.tickPadding-this.diameter/8)}else{var af=(this.tickOuterRadius-this.tickLength-this.diameter/16)}}else{var af=this.intervalOuterRadius}var O=this.max-this.min;var aB=this.intervals[this.intervals.length-1]-this.min;var y,Y,s=this.span*Math.PI/180;for(Z=0;Z<this.intervals.length;Z++){y=(Z==0)?aC:aC+(this.intervals[Z-1][0]-this.min)*s/O;if(y<0){y=0}Y=aC+(this.intervals[Z][0]-this.min)*s/O;if(Y<0){Y=0}W.beginPath();W.fillStyle=this.intervals[Z][2];W.arc(0,0,av,y,Y,false);W.lineTo(af*Math.cos(Y),af*Math.sin(Y));W.arc(0,0,af,Y,y,true);W.lineTo(av*Math.cos(y),av*Math.sin(y));W.closePath();W.fill()}W.restore();var aw=this.data[0][1];var Q=this.max-this.min;if(this.pegNeedle){if(this.data[0][1]>this.max+Q*3/this.span){aw=this.max+Q*3/this.span}if(this.data[0][1]<this.min-Q*3/this.span){aw=this.min-Q*3/this.span}}var ak=(aw-this.min)/Q*this.span*Math.PI/180+this.startAngle;W.save();W.beginPath();W.fillStyle=this.ringColor;W.strokeStyle=this.ringColor;this.needleLength=(this.tickOuterRadius-this.tickLength)*0.85;this.needleThickness=(this.needleThickness<2)?2:this.needleThickness;var aI=this.needleThickness*0.4;var v=this.needleLength/10;var q=(this.needleThickness-aI)/10;var ap;for(var Z=0;Z<10;Z++){ap=this.needleThickness-Z*q;W.moveTo(v*Z*Math.cos(ak),v*Z*Math.sin(ak));W.lineWidth=ap;W.lineTo(v*(Z+1)*Math.cos(ak),v*(Z+1)*Math.sin(ak));W.stroke()}W.restore()}else{this._center=[(J-aq*ah)/2+aq*ah,(R-aq*ag)/2+aq*ag]}};c.jqplot.MeterGaugeAxisRenderer=function(){c.jqplot.LinearAxisRenderer.call(this)};c.jqplot.MeterGaugeAxisRenderer.prototype=new c.jqplot.LinearAxisRenderer();c.jqplot.MeterGaugeAxisRenderer.prototype.constructor=c.jqplot.MeterGaugeAxisRenderer;c.jqplot.MeterGaugeAxisRenderer.prototype.init=function(e){this.tickRenderer=c.jqplot.MeterGaugeTickRenderer;c.extend(true,this,e);this._dataBounds={min:0,max:100};this.min=0;this.max=100;this.showTicks=false;this.ticks=[];this.showMark=false;this.show=false};c.jqplot.MeterGaugeLegendRenderer=function(){c.jqplot.TableLegendRenderer.call(this)};c.jqplot.MeterGaugeLegendRenderer.prototype=new c.jqplot.TableLegendRenderer();c.jqplot.MeterGaugeLegendRenderer.prototype.constructor=c.jqplot.MeterGaugeLegendRenderer;c.jqplot.MeterGaugeLegendRenderer.prototype.init=function(e){this.numberRows=null;this.numberColumns=null;c.extend(true,this,e)};c.jqplot.MeterGaugeLegendRenderer.prototype.draw=function(){var g=this;if(this.show){var p=this._series;var t="position:absolute;";t+=(this.background)?"background:"+this.background+";":"";t+=(this.border)?"border:"+this.border+";":"";t+=(this.fontSize)?"font-size:"+this.fontSize+";":"";t+=(this.fontFamily)?"font-family:"+this.fontFamily+";":"";t+=(this.textColor)?"color:"+this.textColor+";":"";t+=(this.marginTop!=null)?"margin-top:"+this.marginTop+";":"";t+=(this.marginBottom!=null)?"margin-bottom:"+this.marginBottom+";":"";t+=(this.marginLeft!=null)?"margin-left:"+this.marginLeft+";":"";t+=(this.marginRight!=null)?"margin-right:"+this.marginRight+";":"";this._elem=c('<table class="jqplot-table-legend" style="'+t+'"></table>');var x=false,o=false,e,m;var q=p[0];if(q.show){var y=q.data;if(this.numberRows){e=this.numberRows;if(!this.numberColumns){m=Math.ceil(y.length/e)}else{m=this.numberColumns}}else{if(this.numberColumns){m=this.numberColumns;e=Math.ceil(y.length/this.numberColumns)}else{e=y.length;m=1}}var w,v,f,k,h,l,n,u;var r=0;for(w=0;w<e;w++){if(o){f=c('<tr class="jqplot-table-legend"></tr>').prependTo(this._elem)}else{f=c('<tr class="jqplot-table-legend"></tr>').appendTo(this._elem)}for(v=0;v<m;v++){if(r<y.length){l=this.labels[r]||y[r][0].toString();u=colorGenerator.next();if(!o){if(w>0){x=true}else{x=false}}else{if(w==e-1){x=false}else{x=true}}n=(x)?this.rowSpacing:"0";k=c('<td class="jqplot-table-legend" style="text-align:center;padding-top:'+n+';"><div><div class="jqplot-table-legend-swatch" style="border-color:'+u+';"></div></div></td>');h=c('<td class="jqplot-table-legend" style="padding-top:'+n+';"></td>');if(this.escapeHtml){h.text(l)}else{h.html(l)}if(o){h.prependTo(f);k.prependTo(f)}else{k.appendTo(f);h.appendTo(f)}x=true}r++}}}}return this._elem};function a(j,h,f){f=f||{};f.axesDefaults=f.axesDefaults||{};f.legend=f.legend||{};f.seriesDefaults=f.seriesDefaults||{};f.grid=f.grid||{};f.gridPadding=f.gridPadding||{};var e=false;if(f.seriesDefaults.renderer==c.jqplot.MeterGaugeRenderer){e=true}else{if(f.series){for(var g=0;g<f.series.length;g++){if(f.series[g].renderer==c.jqplot.MeterGaugeRenderer){e=true}}}}if(e){f.axesDefaults.renderer=c.jqplot.MeterGaugeAxisRenderer;f.legend.renderer=c.jqplot.MeterGaugeLegendRenderer;f.legend.preDraw=true;f.grid.background=f.grid.background||"white";f.grid.drawGridlines=false;f.grid.borderWidth=(f.grid.borderWidth!=null)?f.grid.borderWidth:0;f.grid.shadow=(f.grid.shadow!=null)?f.grid.shadow:false;f.gridPadding.top=(f.gridPadding.top!=null)?f.gridPadding.top:0;f.gridPadding.bottom=(f.gridPadding.bottom!=null)?f.gridPadding.bottom:0;f.gridPadding.left=(f.gridPadding.left!=null)?f.gridPadding.left:0;f.gridPadding.right=(f.gridPadding.right!=null)?f.gridPadding.right:0}}function d(e){}c.jqplot.preInitHooks.push(a);c.jqplot.postParseOptionsHooks.push(d);c.jqplot.MeterGaugeTickRenderer=function(){c.jqplot.AxisTickRenderer.call(this)};c.jqplot.MeterGaugeTickRenderer.prototype=new c.jqplot.AxisTickRenderer();c.jqplot.MeterGaugeTickRenderer.prototype.constructor=c.jqplot.MeterGaugeTickRenderer})(jQuery);