/*!	
	@file
	@brief	R[h}l[W
*/

#ifndef MaidCString_h
#define MaidCString_h

#include"../Setup/CompileMode.h"
#include"mstring.h"
#include<string>

namespace Maid
{
	namespace CString
	{
		bool IsSJIS1( char x );


		mstring ConvertSJIStoMAID( const MySTL::string& str );
		MySTL::string ConvertMAIDtoSJIS( const mstring& str );

		MySTL::string ConvertMAIDtoSJIS( unt32 c );
		unt32 ConvertCharaMAIDtoSJIS( const MySTL::string& str );


		int		CountByte( const mstring& str );
		int   AtoI( const mstring& str );
		float AtoF( const mstring& str );
		bool  IsHankaku( unt32 c );
		bool  IsGaizi( unt32 c );
		unt32 MakeGaizi( unt32 c );

		mstring ItoA( int value );
		mstring FtoA( float value );


		mstring ToLower( const mstring& str );
		mstring GetDirectory( const mstring& Path );
		mstring GetExtension( const mstring& Path );
		mstring GetFileName( const mstring& Path );

	}


}

#endif
