/*!
 	@file
 	@brief Win32 pAT[g֐
 */


#ifndef CAssert_h
#define CAssert_h

#include"../../Setup/CompileMode.h"
#include"../Macro.h"

#include <streambuf>
#include <ostream>


namespace Maid
{
	class CAssert : public MySTL::ostream
	{
	public:
		CAssert( const char* szFile, int Line );

	private:
		class StreamBuf : public MySTL::streambuf 
		{
			const MySTL::string	m_FileName;
			const int	m_Line;
			MySTL::string m_Message;
		public:
			StreamBuf( const char* szFile, int Line );
			~StreamBuf();
			virtual int_type overflow(int_type iChar = EOF);
		};

		StreamBuf	m_StreamBuf;
	};

}

#ifdef USE_ASSERT
    #pragma COMPILERMSG("assert Lɂ܂")	
	#define MAID_ASSERT( check, mess )	{ if( check ) { Maid::CAssert d(__FILE__,__LINE__); d<<mess; 	}}
#else
	#pragma COMPILERMSG("assert 𖳌ɂ܂")	
	#define MAID_ASSERT( check, mess )
#endif

#endif
