/*!
 	@file
 	@brief g[X֐
 */


#ifndef CTrace_h
#define CTrace_h

#include"../../Setup/CompileMode.h"
#include"../Macro.h"

#include <streambuf>
#include <ostream>

namespace Maid
{
	class CTrace : public MySTL::ostream
	{
	public:
		CTrace( const char* szFile, int Line );

	private:
		class StreamBuf : public MySTL::streambuf 
		{
			const MySTL::string	m_FileName;
			const int	m_Line;
			MySTL::string m_Message;
		public:
			StreamBuf( const char* szFile, int Line );
			~StreamBuf();
			virtual int_type overflow(int_type iChar = EOF);
		};

		StreamBuf	m_StreamBuf;
	};
}

#ifdef USE_TRACE
    #pragma COMPILERMSG("trace Lɂ܂")	
	#define MAID_TRACE( mess )	{ Maid::CTrace d(__FILE__,__LINE__); d<<mess; }
#else
    #pragma COMPILERMSG("trace 𖳌ɂ܂")	
	#define MAID_TRACE( mess )
#endif


#endif
