/*!
 	@file
 	@brief xO֐
 */


#ifndef CWarning_h
#define CWarning_h

#include"../../Setup/CompileMode.h"
#include"../Macro.h"

#include <streambuf>
#include <ostream>


namespace Maid
{
 	class CWarning : public MySTL::ostream
	{
	public:
		CWarning( const char* szFile, int Line );

	private:
		class StreamBuf : public MySTL::streambuf 
		{
			const MySTL::string	m_FileName;
			const int	m_Line;
			MySTL::string m_Message;
		public:
			StreamBuf( const char* szFile, int Line );
			~StreamBuf();
			virtual int_type overflow(int_type iChar = EOF);
		};

		StreamBuf	m_StreamBuf;
	};
}

#ifdef USE_WARNING
    #pragma COMPILERMSG("warning Lɂ܂")	
	#define MAID_WARNING( mess )	{ Maid::CWarning d(__FILE__,__LINE__); d<<mess; }
#else
    #pragma COMPILERMSG("warning 𖳌ɂ܂")	
	#define MAID_WARNING( mess )
#endif

#endif