#include"CFileRead.h"
#include"../CString.h"

#include<io.h>

#include"CFileReadNormal.h"
#include"CFileReadMemory.h"
#include"../Debug/CWarning.h"
#include"../Debug/CAssert.h"
#include"../Debug/CException.h"


namespace Maid
{

	CPackFileManager CFileRead::s_PackManager;


/*!
 	@class	CFileRead CFileRead.h
 	@brief	̃t@Cǂݍ݂T|[gNX
 
 */

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 */
CFileRead::CFileRead()
{

}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 */
CFileRead::~CFileRead()
{
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! w肵t@CJ
/*!
 	@param	FileName	[i ]	ǂݍރt@C
 */
void CFileRead::Open( const mstring& FileName )
{
	MAID_ASSERT( !IsExist(FileName), "t@C݂Ă܂" << FileName );

	Close();

	try {
		const MySTL::string str = CString::ConvertMAIDtoSJIS(FileName);

		if( ::access(str.c_str(),0)!=-1 )
		{
			//	ʂ̃t@C炻
			boost::shared_ptr<CFileReadNormal> pFile( new CFileReadNormal );

			pFile->Open(FileName);

			m_pFile = pFile;
		}else
		{
			//	݂ĂȂpbNt@Cǂݍ

			mstring name(FileName);
			{
				for( int i=0; i<(int)name.length(); ++i )
				{
					const unt32 c = name[i];
					if( c=='/'    ) { name[i] = '\\'; }
				}
			}

			m_pFile = s_PackManager.FindFile( name );
		}
	}
	catch( CException& e )
	{
		//	G烍OcĂ
		MAID_WARNING( "t@C̃I[vɎs" << FileName << e.Text );
		throw;
	}

	m_FileName = FileName;
	m_IsOnmemory = false;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t@CI[vAɓWJĂ
/*!
 	@param	FileName	[i ]	ǂݍރt@C
 */
void	CFileRead::OpenOnmemory( const mstring& FileName )
{
	Close();

	boost::shared_array<unt08> pDat;

	CFileRead hFile;

	hFile.Open(FileName);

	const int FileSize = hFile.GetSize();

	pDat.reset( new unt08[FileSize] );

	hFile.Read( pDat.get(), FileSize );

	{
		boost::shared_ptr<CFileReadMemory> pObj(new CFileReadMemory);

		pObj->Open(pDat, FileSize);

		m_pFile = pObj;
	}

	m_FileName = FileName;
	m_IsOnmemory = true;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! łɊJĂt@C
/*!
 */
void CFileRead::Close()
{
	m_pFile.reset();
	m_IsOnmemory = false;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t@Cǂݍ
/*!
 *	\param	pData	[ o]	Ǎ
 *	\param	Size	[i ]	ǂݍޒioCgPʁj
 *
 *	\return	ۂɓǂݍ񂾃oCg
 */
int CFileRead::Read( void* pData, int Size )
{
	MAID_ASSERT( !m_pFile, "t@CJĂ܂" );
	if( !m_pFile ) { return 0; }
	return m_pFile->Read( pData, Size );
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t@C|WV̈ړ
/*!
 *	\param	Size	[i ]	ړʁioCgPʁj
 *	\param	ePos	[i ]	ړʒu
 *
 *	\return	֐̐ DENRESULT_OK
 *			֐̎s 0ȊO
 */
void	CFileRead::Seek( int Size, IFileRead::POSITION ePos )
{
	MAID_ASSERT( !m_pFile, "t@CJĂ܂" );
	if( !m_pFile ) { return; }
	return m_pFile->Seek( Size, ePos );
}

void	CFileRead::SetPosition( int pos )
{
	m_pFile->Seek( pos, IFileRead::POSITION_BEGIN );
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 *	\return IFileRead::GetSize Ɠ
 */
int		CFileRead::GetSize()    const
{
	MAID_ASSERT( !m_pFile, "t@CJĂ܂" );
	if( !m_pFile ) { return 0; }
	return m_pFile->GetSize();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 *	\return IFileRead::GetPosition Ɠ
 */
int		CFileRead::GetPosition() const
{
	MAID_ASSERT( !m_pFile, "t@CJĂ܂" );
	if( !m_pFile ) { return 0; }
	return m_pFile->GetPosition();
}

bool CFileRead::IsEOF() const
{
	return GetSize() <= GetPosition();
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! PoCgrbNGfBAœǂݍ
/*!
 */
unt08 CFileRead::Read1ByteBigEndian()
{
	//	PoCgăGfBA֌WȂ˂(L_T`)
	unt08 r=0;
	Read( &r, sizeof(r) );
	return r;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! QoCgrbNGfBAœǂݍ
/*!
 */
unt16 CFileRead::Read2ByteBigEndian()
{
	unt08 r[2] = {0};
	Read( &r, sizeof(r) );

	return (r[0]<<8) | (r[1]<<0);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RoCgrbNGfBAœǂݍ
/*!
 */
unt32 CFileRead::Read3ByteBigEndian()
{
	unt08 r[3] = {0};
	Read( &r, sizeof(r) );

	return (r[0]<<16) | (r[1]<<8) | (r[2]<<0);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! SoCgrbNGfBAœǂݍ
/*!
 */
unt32 CFileRead::Read4ByteBigEndian()
{
	unt08 r[4] = {0};
	Read( &r, sizeof(r) );

	return (r[0]<<24) | (r[1]<<16) | (r[2]<<8) | (r[3]<<0);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! PoCggGfBAœǂݍ
/*!
 */
unt08 CFileRead::Read1ByteLittleEndian()
{
	//	PoCgăGfBA֌WȂ˂(L_T`)
	return Read1ByteBigEndian();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! QoCggGfBAœǂݍ
/*!
 */
unt16 CFileRead::Read2ByteLittleEndian()
{
	unt08 r[2] = {0};
	Read( &r, sizeof(r) );

	return (r[1]<<8) | (r[0]<<0);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RoCggGfBAœǂݍ
/*!
 */
unt32 CFileRead::Read3ByteLittleEndian()
{
	unt08 r[3] = {0};
	Read( &r, sizeof(r) );

	return (r[2]<<16) | (r[1]<<8) | (r[0]<<0);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! SoCggGfBAœǂݍ
/*!
 */
unt32 CFileRead::Read4ByteLittleEndian()
{
	unt08 r[4] = {0};
	Read( &r, sizeof(r) );

	return (r[3]<<24) | (r[2]<<16) | (r[1]<<8) | (r[0]<<0);
}
float CFileRead::ReadfloatBigEndian()
{
	float ret;
	unt08 tmp[sizeof(ret)] = {0};
	Read( tmp, sizeof(tmp) );

	unt08* p = (unt08*)&ret;
	for( int i=0; i<sizeof(ret); ++i ) { p[(sizeof(ret)-1)-i]=tmp[i]; }

	return ret;
}

float CFileRead::ReadfloatLittleEndian()
{
	float ret;
	unt08 tmp[sizeof(ret)] = {0};
	Read( tmp, sizeof(tmp) );
	unt08* p = (unt08*)&ret;

	for( int i=0; i<sizeof(ret); ++i ) { p[i]=tmp[i]; }

	return ret;
}

double CFileRead::ReaddoubleBigEndian()
{
	double ret;
	unt08 tmp[sizeof(ret)] = {0};
	Read( tmp, sizeof(tmp) );

	unt08* p = (unt08*)&ret;
	for( int i=0; i<sizeof(ret); ++i ) { p[(sizeof(ret)-1)-i]=tmp[i]; }

	return ret;
}

double CFileRead::ReaddoubleLittleEndian()
{
	double ret;
	unt08 tmp[sizeof(ret)] = {0};
	Read( tmp, sizeof(tmp) );
	unt08* p = (unt08*)&ret;

	for( int i=0; i<sizeof(ret); ++i ) { p[i]=tmp[i]; }

	return ret;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݂̏ꏊ '\0' ܂œǂݎ
/*!
 	@param	endian	[i ]	ǂݎIɍ킹(ftHg1)
 
 	@return ݂Ƃ
 */
mstring CFileRead::ReadString( int endian )
{
	MAID_ASSERT( endian<=0, "PȏKv" );
	MySTL::string str;

	while( true )
	{
		const char c = (char)Read1ByteBigEndian();

		if( c=='\0' )
		{
			const int len = (int)str.length()+1;
			const int mod = len%endian;

			Seek( mod, IFileRead::POSITION_CURRENT );
			break;
		}

		str += c;
	}

	//	{Ȃ當R[h𔻕ʂȂƂȂǁAhĈŃX[


	return CString::ConvertSJIStoMAID(str);
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t@C݂Ă邩H
/*!
 *	\param	FileName	[i ]	ׂt@C
 *
 *	\return ݂ĂȂ true
 */
bool CFileRead::IsExist( const mstring& FileName )
{
	const MySTL::string str = CString::ConvertMAIDtoSJIS(FileName);

	if( ::access(str.c_str(),0)!=-1 ) { return true; }

	return s_PackManager.IsExist( FileName );
}


CPackFileManager& CFileRead::GetPackFile()
{
	return s_PackManager;
}


}