#include"CFileReadFileRange.h"
#include<sys/stat.h>

#include"../Debug/CWarning.h"
#include"../Debug/CAssert.h"
#include"../Debug/CException.h"


namespace Maid
{

/*!
 	@class	CFileReadFileRange CFileReadFileRange.h
 	@brief	t@C̓ԂPt@CƂĈNX 
 */

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 */
CFileReadFileRange::CFileReadFileRange() : m_BeginPosition(0), m_Size(0),m_Position(0)
{

}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 */
CFileReadFileRange::~CFileReadFileRange()
{
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t@CJ
/*!
 	@param	FileName		[i ]	Jt@C
 	@param	BeginPosition	[i ]	ǂݍ݊Jnʒu
 	@param	Size			[i ]	ǂݍݔ͈
 
 	@exception CException I[vɎsꍇ
 */
void CFileReadFileRange::Open( const mstring& FileName, int BeginPosition, int Size )
{
	Close();

	m_hFile.Open( FileName );

	{
		//	Jꂽt@C̃t@CTCY𒲂ׂā@傫悤ȂG[
		if( m_hFile.GetSize() < BeginPosition+Size )
		{
			MAID_ASSERT( true, "w肳ꂽt@CTCYsł" << BeginPosition << "-" << BeginPosition+Size );
			MAID_THROWEXCEPTION(MAIDTEXT("w肳ꂽt@CTCYsł"));
		}
	}

	m_BeginPosition = BeginPosition;
	m_Size     = Size;
	m_Position = 0;

	m_hFile.Seek( m_BeginPosition, IFileRead::POSITION_BEGIN );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t@Cǂݍ
/*!
 *	Ȃǂ IFileRead::Read() QƂ邱
 */
int CFileReadFileRange::Read( void* pData, int Size )
{
	const int ReadSize = MySTL::min(Size,m_Size-m_Position);
	const int ret = m_hFile.Read( pData, ReadSize );

	m_Position += ret;

	return ret;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t@CTCY̎擾
/*!
 *	Ȃǂ IFileRead::GetSize() QƂ邱
 */
int CFileReadFileRange::GetSize() const
{
	return m_Size;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݂̃t@C|WV̎擾
/*!
 *	Ȃǂ IFileRead::GetPosition() QƂ邱
 */
int CFileReadFileRange::GetPosition() const
{
	return m_hFile.GetPosition()-m_BeginPosition;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t@C|WV̈ړ
/*!
 *	Ȃǂ IFileRead::Seek() QƂ邱
 */
void CFileReadFileRange::Seek( int Size, IFileRead::POSITION ePos )
{
	int NewPos;

	switch( ePos )
	{
	case IFileRead::POSITION_BEGIN:
		{
			if( Size<0 ) { NewPos = 0;    }
			else		 { NewPos = Size; }
		}break;
	case IFileRead::POSITION_END:
		{
			if( 0<m_Size ) { NewPos = m_Size;    }
			else		   { NewPos = Size; }
		}break;

	case IFileRead::POSITION_CURRENT:
		{
			NewPos = m_Position + Size;
			if( NewPos<0		) { NewPos = 0;			}
			if( m_Size<NewPos	) { NewPos = m_Size;    }

		}break;
	}

	m_hFile.Seek( m_BeginPosition+NewPos, IFileRead::POSITION_BEGIN );
	m_Position = NewPos;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! JĂt@C
/*!
 *	Ȃǂ IFileRead::Close() QƂ邱
 */
void CFileReadFileRange::Close()
{
	m_hFile.Close();
	m_BeginPosition = 0;
	m_Size    = 0;
	m_Position= 0;
}


}
