#include"CFileReadNormal.h"
#include<sys/stat.h>
#include"../CString.h"
#include"../Debug/CAssert.h"
#include"../Debug/CException.h"
#include"../Debug/CWarning.h"


namespace Maid
{
/*!
 	@class	CFileReadNormal CFileReadNormal.h
 	@brief	ʏ̃t@Cǂݍ݃NX
\n			Cu͂b^CgĂ܂B
\n			̃NXg CFileRead gق֗ł
 
 */


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 */
CFileReadNormal::CFileReadNormal() 
	: m_Handle(NULL), m_Size(0), m_Position(0)
{

}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 */
CFileReadNormal::~CFileReadNormal()
{
	Close();
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t@CJ
/*!
	@param	FileName [i ]	Jt@C

	@exception CException I[vɎsꍇ
 */
void CFileReadNormal::Open( const mstring& FileName )
{
	Close();

	MySTL::string str = CString::ConvertMAIDtoSJIS(FileName);

	m_Handle = ::fopen( str.c_str(), "rb" );

	if( m_Handle==NULL )
	{
		MAID_ASSERT( true, "t@C̃I[vɎs" << FileName );
		MAID_THROWEXCEPTION(MAIDTEXT("t@C̃I[vɎs"));
	}

	//	t@CTCY𒲂ׂ
	struct stat StatFile; 
	::fstat( ::fileno(m_Handle), &StatFile );

	m_Size     = StatFile.st_size;
	m_Position = 0;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t@Cǂݍ
/*!
 	Ȃǂ IFileRead::Read() QƂ邱
 */
int CFileReadNormal::Read( void* pData, int Size )
{
	MAID_ASSERT( m_Handle==NULL, "t@CJĂ܂" );

	if( Size==0 ) { return 0; }
	//	t@C̖[zȂ悤ɓǂݍ
	int ReadSize;
	
	if( m_Position+Size>m_Size )	{ ReadSize = m_Size-m_Position; }
	else							{ ReadSize = Size; }

	::fread( pData, ReadSize, 1, m_Handle );

	m_Position += ReadSize;


	return ReadSize;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t@CTCY̎擾
/*!
 	Ȃǂ IFileRead::GetSize() QƂ邱
 */
int CFileReadNormal::GetSize() const
{
	MAID_ASSERT( m_Handle==NULL, "t@CJĂ܂" );
	return m_Size;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݂̃t@C|WV̎擾
/*!
 	Ȃǂ IFileRead::GetPosition() QƂ邱
 */
int CFileReadNormal::GetPosition() const
{
	MAID_ASSERT( m_Handle==NULL, "t@CJĂ܂" );
	return m_Position;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t@C|WV̈ړ
/*!
 	Ȃǂ IFileRead::Seek() QƂ邱
 */
void CFileReadNormal::Seek( int Size, IFileRead::POSITION ePos )
{
	MAID_ASSERT( m_Handle==NULL, "t@CJĂ܂" );

	long Origin;
	switch( ePos )
	{
	case IFileRead::POSITION_BEGIN:		{ Origin = SEEK_SET; }break;
	case IFileRead::POSITION_END:		{ Origin = SEEK_END; }break;
	case IFileRead::POSITION_CURRENT:	{ Origin = SEEK_CUR; }break;
	}
	
	::fseek( m_Handle, Size, Origin );

	m_Position = ::ftell( m_Handle );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! JĂt@C
/*!
 	Ȃǂ IFileRead::Close() QƂ邱
 */
void CFileReadNormal::Close()
{
	if( m_Handle!=NULL )
	{
		::fclose( m_Handle );
		m_Handle  = NULL;
		m_Size    = 0;
		m_Position= 0;
	}
}

}
