/*!
 	@file
 	@brief	Ǝ`pbNt@CCӂ̃t@CǂݍރNX
 */

#ifndef CPackFileManager2_h
#define CPackFileManager2_h

#include"../../Setup/CompileMode.h"
#include"../mstring.h"
#include"CFileReadInterface.h"

#include<vector>
#include<set>
#include<list>
#include<map>
#include<boost/smart_ptr.hpp>
#include<boost/bind.hpp>
#include<boost/function.hpp>
#include"../Thread/CThreadController.h"
#include"../Thread/CThreadMutex.h"

namespace Maid
{
	class CPackFile;
	class CPackFileManager
	{
	public:
		CPackFileManager();
		void Mount(   const mstring& PackFileName,  const mstring& MountDirectory=mstring() );
		void UnMount( const mstring& PackFileName );


		boost::shared_ptr<IFileRead> FindFile( const mstring& FileName );
		bool IsExist ( const mstring& FileName );

	private:
		mstring CreateMountDirectory( const mstring& name );

		typedef boost::shared_ptr<CPackFile>	SPPACKFILE;
		typedef MySTL::list<SPPACKFILE>			PACKLIST;
		typedef MySTL::map<mstring,PACKLIST >	MOUNTLIST;

		MOUNTLIST	m_PackFileList;
	};


	class CPackFileCreater
	{
	public:
		void SetNoCompressList( const MySTL::vector<mstring>& List );

		void BeginArchive( const mstring& DirectoryName, const mstring& OutputName );

		struct STATUS
		{
			enum STATE
			{
				STATE_OK,		//!<	s
				STATE_ERROR,	//!<	G[N
				STATE_SUCCESS,	//!<	ďI
				STATE_CANCEL,	//!<	LZ߂łďI
			};

			STATE	State;		//!<	݂̏
			mstring	Text;		//!<	݂̏Ԃ\eLXg
			unt32	Progress;	//!<	is(0-100)
		};

		STATUS GetStatus();
		void   OnCancel();

		const MySTL::vector<mstring>& GetNoCompressFileList() const { return 	m_NoCompressFileList; }

	private:
		unt32		PackThread( volatile CThreadController::BRIGEDATA& Brige );



		typedef MySTL::vector<mstring> FILELIST;

		void	PickupFile( const mstring& Dir, FILELIST& List );

		void CreateZlibCompressFile( const mstring& src, const mstring& dst );
		void CreateNoCompressFile( const mstring& src, const mstring& dst );
		void AddAlignmentByte( MySTL::vector<unt08>& dat, int size );


	private:	//	Xbh܂f[^
		typedef MySTL::set<mstring>	EXTLIST;
		EXTLIST		m_NoCompressList;	//!<	kȂt@CIʂgqXg

		mstring m_DirectoryName;
		mstring m_OutputName;

		MySTL::vector<mstring>	m_NoCompressFileList;

	private:
		CThreadMutex		m_Section;
		CThreadController	m_Thread;
		STATUS				m_Status;

	};

}


#endif
