#include"CThreadController.h"
#include"../Debug/CAssert.h"
#include"../Debug/CWarning.h"
#include"../Debug/CException.h"
#include"../Debug/CTrace.h"
#include"../../Setup/Win32.h"

namespace Maid
{

	/*!
	 	@class	CThreadController CThreadController.h
	 	@brief	Xbh쐬NX
	\n			XbhŎsĂ֐͈ȉ̃[邱
	\n			BRIGEDATA::IsExit  true ̎͑ return 邱
	\n
	\n			̃Xbh C^Cgpꍇ̒
	\n
	\n				http://msdn2.microsoft.com/ja-jp/library/7t9ha0zh(VS.80).aspx
	\n
	\n				Libcmt.lib gpărhvO C ^C [`Ăяoꍇ́A
	\n				_beginthread ֐܂ _beginthreadex ֐ŃXbhNKv܂B
	\n				Win32  ExitThread ֐ CreateThread ֐͎gpȂłB
	\n				܂AC ^C Cũf[^\̂փANZX̃XbhāA
	\n				̊҂Ă镡̃Xbh݂ꍇ SuspendThread gƁA
	\n				fbhbNԂɂȂ܂B
	\n
	\n
	\n			₷Ɓ@Q̃Xbhꂼ printf() ĂƂ
	\n			Е̃Xbh SuspendThread() ƁAfbhbN邱Ƃ܂B
	\n
	\n			ɂƂ߂Ȃق݂łB

	 */


void CThreadController::Sleep( unt time )
{
	::Sleep( time );
}



/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 */
CThreadController::CThreadController()
{
	m_hThread = NULL;
	m_BrigeData.IsExit    = false;
	m_BrigeData.IsExecute = false;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 */
CThreadController::~CThreadController()
{
	Close();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Xbhōs֐̐ݒ
/*!
 *	\param	Function	[i ]	ݒ肷֐
 */
void CThreadController::SetFunc( const THREADFUNCTION& Function )
{
	m_Func = Function;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Xbh̋N
/*!
 */
void CThreadController::Execute( PRIORITY priority )
{
	Close();
	unt32 no;
	m_BrigeData.IsExecute = true;

	if( priority!=PRIORITY_NORMAL )
	{
		m_hThread = ::_beginthreadex( NULL, 0, Thread, this, CREATE_SUSPENDED, &no );
		SetPriority( priority );
		Resume();
	}else
	{
		m_hThread = ::_beginthreadex( NULL, 0, Thread, this, 0, &no );
	}
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Xbh̏I
/*!
 */
void CThreadController::Close()
{
	if( m_hThread!=NULL )
	{
		m_BrigeData.IsExit = true;
		while( m_BrigeData.IsExecute ) { ::WaitForSingleObject((HANDLE)m_hThread,100); }
		::CloseHandle( (HANDLE)m_hThread );
		m_hThread = NULL;
	}

	m_BrigeData.IsExit    = false;
	m_BrigeData.IsExecute = false;
	m_BrigeData.IsAssert  = false;

	const mstring m = m_ExceptionText;
	m_ExceptionText.clear();

	if( !m.empty() )
	{
		throw CException(m);
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Dx̕ύX
/*!
 *	\param	priority	[i ]	VDx
 */
void CThreadController::SetPriority( PRIORITY priority )
{
	int p;
	switch( priority )
	{
	case PRIORITY_HIGH2:	{ p = THREAD_PRIORITY_HIGHEST; }break;
	case PRIORITY_HIGH1:	{ p = THREAD_PRIORITY_ABOVE_NORMAL; }break;
	case PRIORITY_NORMAL:	{ p = THREAD_PRIORITY_NORMAL; }break;
	case PRIORITY_LOW1:		{ p = THREAD_PRIORITY_BELOW_NORMAL; }break;
	case PRIORITY_LOW2:		{ p = THREAD_PRIORITY_LOWEST; }break;
	}
	::SetThreadPriority( (HANDLE)m_hThread, p );
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Xbhꎞ~߂
/*!
 */
void CThreadController::Pause()
{
	::SuspendThread( (HANDLE)m_hThread );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ~ĂXbhN
/*!
 */
void CThreadController::Resume()
{
	::ResumeThread( (HANDLE)m_hThread );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Xbh̏IH
/*!
 */
bool CThreadController::IsThreadExited() const
{
	return !m_BrigeData.IsExecute;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Xbh̏I
/*!
 */
bool CThreadController::IsThreadAssert() const
{
	return m_BrigeData.IsAssert;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Xbh̖߂l̎擾
/*!
	IsThreadExited()==true ̂ƂĂяo
 */
unt CThreadController::GetReturnCode() const
{
	MAID_ASSERT( !IsThreadExited(), "Xbh͎sł" );
	if( !IsThreadExited() ) { return 0; }

	DWORD ret;
	::GetExitCodeThread( (HANDLE)m_hThread, &ret );
	return ret;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Xbho֐ŋN邽߂̓ݑ֐
/*!
 	@param	pVoid	[i ]	 _beginthreadex Ăяo CThread* ł邱
 */
unsigned __stdcall CThreadController::Thread( void* pVoid )
{
	unt RetCode = 0;
	CThreadController* pThis = (CThreadController*)pVoid;

	try
	{
		RetCode = pThis->m_Func( pThis->m_BrigeData );
	}
	catch( CException& e )
	{
		//	ʃXbh̗O̓CXbhŃLb`łȂ̂
		//	OďI
		e.WriteLog();

		pThis->m_ExceptionText = e.Text;
		pThis->m_BrigeData.IsAssert = true;
	}

	pThis->m_BrigeData.IsExecute = false;
	_endthreadex(RetCode);

	return RetCode;
}


}
