#ifndef CThreadController_h
#define CThreadController_h

/*!
 	\file
 	\brief	XbhNX
 */

#include"../../Setup/CompileMode.h"
#include"../Macro.h"
#include"../mstring.h"
#include<process.h>
#include<boost/function.hpp>
#include<boost/bind.hpp>

namespace Maid
{
	class CThreadController
	{
	public:

		/*!
		 	@class	BRIGEDATA CThreadController.h
		 	@brief	Xbh쐬NXƃXbhĂ΂ꂽNX
		\n			󂯓nf[^
		 */
		struct BRIGEDATA
		{
			volatile bool	IsExit;		//!<	I߂łĂ邩H
			volatile bool	IsExecute;	//!<	XbhNH
			volatile bool	IsAssert;	//!<	XbhIH
		};

	public:
		CThreadController();
		~CThreadController();

		//!	Xbh̗Dx
		enum PRIORITY
		{
			PRIORITY_HIGH2,		//!<	ԍ
			PRIORITY_HIGH1,
			PRIORITY_NORMAL,	//!<	ftHg
			PRIORITY_LOW1,
			PRIORITY_LOW2,		//!<	ԒႢ
		};

		typedef boost::function1<unt, volatile BRIGEDATA&>	THREADFUNCTION;
		void	SetFunc( const THREADFUNCTION& Function );
		void	Execute( PRIORITY priority = PRIORITY_NORMAL );
		void	Close();

		void SetPriority( PRIORITY priority );

		void Pause();
		void Resume();

		bool IsThreadExited() const;
		bool IsThreadAssert() const;
		unt GetReturnCode() const;

		static void Sleep( unt time );

	private:
		static  unsigned __stdcall Thread( void* pVoid );

		THREADFUNCTION	m_Func;
		uintptr_t		m_hThread;

		volatile BRIGEDATA		m_BrigeData;
		mstring				m_ExceptionText;
	};

	#define MakeThreadObject(pFunc,pObject) boost::bind( pFunc, pObject, _1 )

}

#endif


