#include"COpenFileName.h"
#include"CShell.h"
#include"../CString.h"

static char s_FullPath[MAX_PATH];		
static char s_FileTitle[MAX_PATH];

namespace Maid
{



/*!
 *	\class COpenFileName COpenFileName.h
 *	\brief GetOpenFileName() or GetSaveFileName()@̃bp[NX
 *
 *			Rł Windows pł
 *
*/

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!	
 *
 */
COpenFileName::COpenFileName()
{
	//m_ofn̏
	ZeroMemory( &m_ofn, sizeof(m_ofn) );
//	m_ofn.lStructSize = OPENFILENAME_SIZE_VERSION_400;	//Win2000ȊOłg悤ɂ
	m_ofn.lStructSize = sizeof(m_ofn);	
	m_ofn.nMaxFile		 = MAX_PATH;
	m_ofn.nMaxFileTitle  = MAX_PATH;

	SetDefaultDirectory( CShell::GetCurrentDirectory() );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!	
 *
 */
COpenFileName::~COpenFileName()
{
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! _CAOJƂɃftHgŊJĂfBNg̐ݒ
/*!
 *
 *	\param  _strDirectry	[i ]	fBNg
 *
 */
void COpenFileName::SetDefaultDirectory( const mstring& _strDirectry )
{
	m_DefaultDirectry = CString::ConvertMAIDtoSJIS(_strDirectry);
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Iłgq̐ݒ
/*!
 *	\param  _szFilter	[i ]	gq
 */
void COpenFileName::SetFileFilter( char* _szFilter )
{
	// tB^[͋؂蕶 '\0' gpĂ邽߁Astring͎gȂ̂ŎŌvZ
	int i=2;
	while( true )
	{
		if( (_szFilter[i-2]=='\0') && (_szFilter[i-1]=='\0') ) { break; }
		i++;
	}

	m_pFilter.reset( new char[i] );
	memcpy( m_pFilter.get(), _szFilter, i );
}



/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ut@CJv_CAO{bNXo
/*!
 	@param  hWnd		[i ]	I[i[nh
 	@param  Title		[i ]	_CAO{bNX̃^Cgo[ɕ\镶
 	@param  DefExt		[i ]	_CAOłƂɃftHgœĂ镶
 	@param  DefaultName	[i ]	ŏGfBbg{bNXɓĂt@C
 
	@return t@Cw肵āmOKn{^ƁAtrueԂ܂
 			_CAO{bNXLZ肵ꍇ́Afalse Ԃ܂	
*/
bool COpenFileName::ShowOpenDialog( HWND hWnd, const mstring& Title, const mstring& DefExt, const mstring& DefaultName )
{
	BOOL ret;

	const MySTL::string sjis_tittle = CString::ConvertMAIDtoSJIS(Title);
	const MySTL::string sjis_ext    = CString::ConvertMAIDtoSJIS(DefExt);
	const MySTL::string sjis_name   = CString::ConvertMAIDtoSJIS(DefaultName);

	::lstrcpy( s_FileTitle, sjis_name.c_str() );

	m_ofn.hwndOwner			= hWnd;
	m_ofn.lpstrFilter		= m_pFilter.get();
	m_ofn.nFilterIndex		= 1;				// tB^[̏ʒu
	m_ofn.lpstrFile			= s_FullPath;		// t@Cpobt@
	m_ofn.lpstrFileTitle	= s_FileTitle;		// t@C̃^Cgpobt@
	m_ofn.lpstrDefExt		= sjis_ext.c_str();
	m_ofn.lpstrInitialDir	= m_DefaultDirectry.c_str();
	m_ofn.Flags				= OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
	m_ofn.lpstrTitle		= sjis_tittle.c_str(); // ^Cg

	{
		const mstring dir = CShell::GetCurrentDirectory();
		ret = ::GetOpenFileName( &m_ofn );

		CShell::SetCurrentDirectory(dir);
	}

	if( ret==0 )
	{
		const DWORD d = ::CommDlgExtendedError();

		//	GetSaveFileName() ̓G[ǁA CommDlgExtendedError() ̓G[łȂ
		//	== LZꂽ
		if( d==0 ) { return false; }

	}else
	{
		m_FullPath = CString::ConvertSJIStoMAID(s_FullPath);
		m_FileName = CString::ConvertSJIStoMAID(s_FileTitle);
		return true;
	}

	return false;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ut@Cۑv_CAO{bNXo
/*!
 	@param  hWnd		[i ]	I[i[nh
 	@param  Title		[i ]	_CAO{bNX̃^Cgo[ɕ\镶
 	@param  DefExt		[i ]	_CAOłƂɃftHgœĂ镶
 	@param  DefaultName	[i ]	ŏGfBbg{bNXɓĂt@C
 
	@return t@Cw肵āmOKn{^ƁAtrueԂ܂
 			_CAO{bNXLZ肵ꍇ́Afalse Ԃ܂	
*/
bool COpenFileName::ShowSaveDialog( HWND hWnd, const mstring& Title, const mstring& DefExt, const mstring& DefaultName )
{
	BOOL ret;

	const MySTL::string sjis_tittle = CString::ConvertMAIDtoSJIS(Title);
	const MySTL::string sjis_ext    = CString::ConvertMAIDtoSJIS(DefExt);
	const MySTL::string sjis_name   = CString::ConvertMAIDtoSJIS(DefaultName);

	::lstrcpy( s_FileTitle, sjis_name.c_str() );
	m_ofn.hwndOwner			= hWnd;
	m_ofn.lpstrFilter		= m_pFilter.get();
	m_ofn.nFilterIndex		= 1;				// tB^[̏ʒu
	m_ofn.lpstrFile			= s_FullPath;		// t@Cpobt@
	m_ofn.lpstrFileTitle	= s_FileTitle;	// t@C̃^Cgpobt@
	m_ofn.lpstrDefExt		= sjis_ext.c_str();
	m_ofn.lpstrInitialDir	= m_DefaultDirectry.c_str();
	m_ofn.Flags				= OFN_FILEMUSTEXIST;
	m_ofn.lpstrTitle		= sjis_tittle.c_str(); // ^Cg

	{
		const mstring dir = CShell::GetCurrentDirectory();
		ret = ::GetSaveFileName( &m_ofn );
		CShell::SetCurrentDirectory(dir);
	}


	if( ret==0 )
	{
		const DWORD d = ::CommDlgExtendedError();

		//	GetSaveFileName() ̓G[ǁA CommDlgExtendedError() ̓G[łȂ
		//	== LZꂽ
		if( d==0 ) { return false; }

	}else
	{
		m_FullPath = CString::ConvertSJIStoMAID(s_FullPath);
		m_FileName = CString::ConvertSJIStoMAID(s_FileTitle);

		if( IsFlag(m_ofn.Flags,OFN_EXTENSIONDIFFERENT) )
		{
			//	gqႤ

		}

		return true;
	}

	return ret==TRUE;
}

}