#include"CRegistry.h"
#include"../Debug/CAssert.h"

#include"../CString.h"


namespace Maid
{

/*!
 	@class CRegistry CRegistry.h
 	@brief WXgL[擾E쐬NX
 
 		łɃL[݂ĂƂ͏㏑܂
 */

inline HKEY ConvertKey( CRegistry::KEY k )
{
	HKEY hKey;

	switch( k )
	{
	case CRegistry::KEY_CLASSES_ROOT:	{ hKey = HKEY_CLASSES_ROOT; }break;
	case CRegistry::KEY_CURRENT_USER:	{ hKey = HKEY_CURRENT_USER; }break;
	case CRegistry::KEY_LOCAL_MACHINE:	{ hKey = HKEY_LOCAL_MACHINE; }break;
	case CRegistry::KEY_USERS:			{ hKey = HKEY_USERS; }break;
	default: { MAID_ASSERT( true, "͈͊ÕL[ł" ); } break;
	}
	return hKey;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!	
 *
 */
CRegistry::CRegistry()
{
	m_hKey = NULL;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!	
 *
 */
CRegistry::~CRegistry()
{
	Close();
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! WXgL[J
/*!	
 
 	@param	hKey	[i ]	匳̃L[
 	@param	SubKey	[i ]	TuL[̖O
 
	@exception CException I[vɎsꍇ
 */
void CRegistry::Open( CRegistry::KEY hKey, const mstring& SubKey )
{
	Close();

	const MySTL::string sjis_sub = CString::ConvertMAIDtoSJIS(SubKey);

	if( ::RegOpenKeyEx( ConvertKey(hKey), sjis_sub.c_str(), 0, KEY_ALL_ACCESS, &m_hKey )!=ERROR_SUCCESS ) 
	{
		MAID_THROWEXCEPTION(MAIDTEXT("RegOpenKeyEx()"));
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! WXgL[쐬AJ
/*!	
 
 	@param	hKey	[i ]	匳̃L[
 	@param	SubKey	[i ]	TuL[̖O
 
	@exception CException	L[쐬āAI[vɎsꍇ
									L[݂ĂāAI[vɎsꍇ
 */
void CRegistry::Create( CRegistry::KEY hKey, const mstring& SubKey )
{
	Close();
	const MySTL::string sjis_sub = CString::ConvertMAIDtoSJIS(SubKey);

	DWORD ret=0;

	const LONG code = ::RegCreateKeyEx( ConvertKey(hKey), sjis_sub.c_str(), 0, "", REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &m_hKey, &ret );
	if( code!=ERROR_SUCCESS )
	{
		MAID_THROWEXCEPTION(MAIDTEXT("RegCreateKeyEx()"));
	}
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! DWORD lZbg
/*!	
 
 	@param	Name	[i ]	쐬閼O
 	@param	Data	[i ]	Zbgl
 
	@exception CException ֐̎s
 */
void CRegistry::SetValue( const mstring& Name, unt32 Data )
{
	MAID_ASSERT( m_hKey==NULL, "L[JĂ܂" );
	if( m_hKey==NULL ) { return ; }

	const MySTL::string sjis_name = CString::ConvertMAIDtoSJIS(Name);
	if( ::RegSetValueEx( m_hKey, sjis_name.c_str(), 0, REG_DWORD, (BYTE*)&Data, sizeof(Data) )!=ERROR_SUCCESS ) 
	{
		MAID_THROWEXCEPTION(MAIDTEXT("RegSetValueEx()"));
	}
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! lZbg
/*!	
 
 	@param	Name	[i ]	쐬閼O
 	@param	Data	[i ]	Zbg镶
 
	@exception CException ֐̎s
 */
void CRegistry::SetValue( const mstring& Name, const mstring& Data )
{
	MAID_ASSERT( m_hKey==NULL, "L[JĂ܂" );
	if( m_hKey==NULL ) { return ; }

	const MySTL::string sjis_name = CString::ConvertMAIDtoSJIS(Name);
	const MySTL::string sjis_data = CString::ConvertMAIDtoSJIS(Data);
	if( ::RegSetValueEx( m_hKey, sjis_name.c_str(), 0, REG_SZ, (BYTE*)sjis_data.c_str(), (DWORD)sjis_data.length()+1 )!=ERROR_SUCCESS ) 
	{
		MAID_THROWEXCEPTION(MAIDTEXT("RegSetValueEx()"));
	}
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! lZbg
/*!	
 
 	@param	Name	[i ]	쐬閼O
 	@param	pData	[i ]	ZbgoCif[^
 	@param	Length	[i ]	_pData ̒
 
	@exception CException ֐̎s
 */
void CRegistry::SetValue( const mstring& Name, const void* pData, unt32 Length )
{
	MAID_ASSERT( m_hKey==NULL, "L[JĂ܂" );
	if( m_hKey==NULL ) { return ; }

	const MySTL::string sjis_name = CString::ConvertMAIDtoSJIS(Name);
	if( ::RegSetValueEx( m_hKey, sjis_name.c_str(), 0, REG_BINARY, (BYTE*)pData, Length+1 )!=ERROR_SUCCESS )
	{
		MAID_THROWEXCEPTION(MAIDTEXT("RegSetValueEx()"));
	}
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! DWORD l擾
/*!	
 
 	@param	Name	[i ]	擾閼O
 	@param	Data	[ o]	擾DWORDl
 
	@exception CException ֐̎s
 */
void CRegistry::GetValue( const mstring& Name, unt32& Data )
{
	MAID_ASSERT( m_hKey==NULL, "L[JĂ܂" );
	if( m_hKey==NULL ) { return ; }

	DWORD	dwKeyType;
	DWORD	dwKeyData;
	DWORD	dwKeyBuffLen = 4;
	const MySTL::string sjis_name = CString::ConvertMAIDtoSJIS(Name);

	if( ::RegQueryValueEx( m_hKey, sjis_name.c_str(), NULL, &dwKeyType, (BYTE*)&dwKeyData, &dwKeyBuffLen )!=ERROR_SUCCESS )
	{
		MAID_THROWEXCEPTION(MAIDTEXT("RegQueryValueEx()"));
	}

	if( dwKeyType!=REG_DWORD ) 
	{
		MAID_THROWEXCEPTION(MAIDTEXT("dwKeyType!=REG_DWORD"));
	}
	Data = dwKeyData;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//!  l擾
/*!	
 
 	@param	Name	[i ]	擾閼O
 	@param	Data	[ o]	擾镶
 
	@exception CException ֐̎s
 */
void CRegistry::GetValue( const mstring& Name, mstring& Data )
{
	MAID_ASSERT( m_hKey==NULL, "L[JĂ܂" );
	if( m_hKey==NULL ) { return ; }


	const MySTL::string sjis_name = CString::ConvertMAIDtoSJIS(Name);

	DWORD	dwKeyType;
	DWORD	dwKeyBuffLen=0;

	if( ::RegQueryValueEx( m_hKey, sjis_name.c_str(), NULL, &dwKeyType, NULL, &dwKeyBuffLen )!=ERROR_SUCCESS )
	{
		MAID_THROWEXCEPTION(MAIDTEXT("RegQueryValueEx()"));
	}
	if( dwKeyType!=REG_SZ )
	{
		MAID_THROWEXCEPTION(MAIDTEXT("dwKeyType!=REG_SZ"));
	}

	MySTL::string s;
	s.resize(dwKeyBuffLen-1);

	if( ::RegQueryValueEx( m_hKey, sjis_name.c_str(), NULL, &dwKeyType, (BYTE*)s.data(), &dwKeyBuffLen )!=ERROR_SUCCESS )
	{
		MAID_THROWEXCEPTION(MAIDTEXT("RegQueryValueEx()"));
	}

	Data = CString::ConvertSJIStoMAID(s);
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! oCif[^ l擾
/*!	
 
 	@param	Name	[i ]	擾閼O
 	@param	pData	[ o]	擾oCif[^
 	@param	Length	[ o]	oCif[^̒
 
	@exception CException ֐̎s
 */
void CRegistry::GetValue( const mstring& Name, boost::shared_array<unt08>& pData, unt32& Length )
{
	MAID_ASSERT( m_hKey==NULL, "L[JĂ܂" );
	if( m_hKey==NULL ) { return ; }

	DWORD	dwKeyType;
	DWORD	dwKeyBuffLen=0;

	const MySTL::string sjis_name = CString::ConvertMAIDtoSJIS(Name);

	if( ::RegQueryValueEx( m_hKey, sjis_name.c_str(), NULL, &dwKeyType, NULL, &dwKeyBuffLen )!=ERROR_SUCCESS )
	{
		MAID_THROWEXCEPTION(MAIDTEXT("RegQueryValueEx()"));
	}
	if( dwKeyType!=REG_BINARY ) 
	{
		MAID_THROWEXCEPTION(MAIDTEXT("dwKeyType!=REG_BINARY"));
	}

	pData.reset( new unt08[dwKeyBuffLen] );

	if( ::RegQueryValueEx( m_hKey, sjis_name.c_str(), NULL, &dwKeyType, pData.get(), &dwKeyBuffLen )!=ERROR_SUCCESS ) 
	{
		MAID_THROWEXCEPTION(MAIDTEXT("RegQueryValueEx()"));
	}
	Length = dwKeyBuffLen;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! l폜
/*!	
 	@param	ValueName	[i ]	폜l̖O
 
	@exception CException ֐̎s
 */
void CRegistry::DeleteValue( const mstring& ValueName )
{
	MAID_ASSERT( m_hKey==NULL, "L[JĂ܂" );
	if( m_hKey==NULL ) { return ; }

	const MySTL::string sjis_name = CString::ConvertMAIDtoSJIS(ValueName);
	if( ::RegDeleteValue( m_hKey, sjis_name.c_str() )!=ERROR_SUCCESS ) 
	{
		MAID_THROWEXCEPTION(MAIDTEXT("RegDeleteValue()"));
	}
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! WXg̑I
/*!	
 */
void CRegistry::Close()
{
	if( m_hKey!=NULL )
	{
		::RegCloseKey( m_hKey );
		m_hKey = NULL;
	}
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! WXgL[̍폜
/*!	
 	@param	hKey	[i ]	폜L[
 	@param	SubKey	[i ]	폜TuL[
 
	@exception CException 폜̎s
 */
void CRegistry::DeleteKey( KEY hKey, const mstring& SubKey )
{
	const MySTL::string sjis_key = CString::ConvertMAIDtoSJIS(SubKey);
	if( ::RegDeleteKey( ConvertKey(hKey), sjis_key.c_str() )!=ERROR_SUCCESS ) 
	{
		MAID_THROWEXCEPTION(MAIDTEXT("RegDeleteKey()"));
	}
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! WXg̒l̍폜
/*!	
 	@param	hKey		[i ]	폜L[
 	@param	SubKey		[i ]	TTuL[
 	@param	ValueName	[i ]	폜l
 
	@exception CException 폜̎s
 */
void CRegistry::DeleteValue( KEY hKey, const mstring& SubKey, const mstring& ValueName )
{
	CRegistry hReg;
	hReg.Open( hKey, SubKey );
	hReg.DeleteValue( ValueName );
}


}